/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.jcr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.brandadvocacy.jcr.DAO;
import org.exoplatform.brandadvocacy.model.Address;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;
import org.exoplatform.brandadvocacy.service.JCRImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AddressDAO
extends DAO {
    private static final Log log = ExoLogger.getLogger(AddressDAO.class);
    private static final String node_prop_labelID = "exo:labelID";
    private static final String node_prop_fname = "exo:fname";
    private static final String node_prop_lname = "exo:lname";
    private static final String node_prop_address = "exo:address";
    private static final String node_prop_city = "exo:city";
    private static final String node_prop_country = "exo:country";
    private static final String node_prop_phone = "exo:phone";

    public AddressDAO(JCRImpl jcrImpl) {
        super(jcrImpl);
    }

    private Node getOrCreateAddressHome(String programId, String username) {
        if (null == username || "".equals(username)) {
            log.error((Object)"ERROR cannot get or create address home in participant null");
            return null;
        }
        Node participant = this.getJcrImplService().getParticipantDAO().getNodeByUserName(programId, username);
        if (null != participant) {
            return this.getJcrImplService().getParticipantDAO().getOrCreateAddressHome(participant);
        }
        return null;
    }

    public void setProperties(Node aNode, Address adrs) throws RepositoryException {
        aNode.setProperty(node_prop_labelID, adrs.getLabelID());
        aNode.setProperty(node_prop_fname, adrs.getfName());
        aNode.setProperty(node_prop_lname, adrs.getlName());
        aNode.setProperty(node_prop_address, adrs.getAddress());
        aNode.setProperty(node_prop_city, adrs.getCity());
        aNode.setProperty(node_prop_country, adrs.getCountry());
        aNode.setProperty(node_prop_phone, adrs.getPhone());
    }

    public Address transferNode2Object(Node node) throws RepositoryException {
        if (null == node) {
            return null;
        }
        Address address = new Address();
        address.setId(node.getUUID());
        PropertyIterator iter = node.getProperties("exo:*");
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            String name = p.getName();
            if (name.equals(node_prop_labelID)) {
                address.setLabelID(p.getString());
                continue;
            }
            if (name.equals(node_prop_fname)) {
                address.setfName(p.getString());
                continue;
            }
            if (name.equals(node_prop_lname)) {
                address.setlName(p.getString());
                continue;
            }
            if (name.equals(node_prop_address)) {
                address.setAddress(p.getString());
                continue;
            }
            if (name.equals(node_prop_city)) {
                address.setCity(p.getString());
                continue;
            }
            if (name.equals(node_prop_country)) {
                address.setCountry(p.getString());
                continue;
            }
            if (!name.equals(node_prop_phone)) continue;
            address.setPhone(p.getString());
        }
        try {
            address.checkValid();
            return address;
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)"ERROR cannot transfer node to object");
            return null;
        }
    }

    public List<Address> transferNodes2Objects(List<Node> nodes) {
        ArrayList<Address> addresses = new ArrayList<Address>(nodes.size());
        for (Node node : nodes) {
            try {
                Address address = this.transferNode2Object(node);
                if (null == address) continue;
                addresses.add(address);
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return addresses;
    }

    public Address addAddress2Participant(String programId, String username, Address address) {
        try {
            Node addressHomeNode = this.getOrCreateAddressHome(programId, username);
            address.checkValid();
            if (null != addressHomeNode) {
                Node addressNode = null;
                addressNode = !addressHomeNode.hasNode(address.getLabelID()) ? addressHomeNode.addNode(address.getLabelID(), "brad:address") : addressHomeNode.getNode(address.getLabelID());
                if (null != addressNode) {
                    this.setProperties(addressNode, address);
                    addressHomeNode.save();
                    return this.transferNode2Object(addressNode);
                }
            }
        }
        catch (ItemExistsException ie) {
            log.error((Object)(" === ERROR cannot add existing item " + ie.getMessage()));
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.error((Object)("=== ERROR cannot add address to participant " + e.getMessage()));
        }
        catch (RepositoryException e) {
            log.error((Object)("=== ERROR cannot add address to participant " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("=== ERROR cannot add address " + brade.getMessage()));
        }
        return null;
    }

    public List<Address> getAllAddressesByParticipantInProgram(String programId, String username) {
        try {
            Node addressHomeNode = this.getOrCreateAddressHome(programId, username);
            if (null != addressHomeNode) {
                NodeIterator nodes = addressHomeNode.getNodes();
                return this.transferNodes2Objects(Lists.newArrayList((Iterator)nodes));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR get all propositions " + e.getMessage()));
        }
        return null;
    }

    public Address updateAddress(Address address) {
        try {
            address.checkValid();
            Node addressNode = this.getNodeById(address.getId());
            if (null != addressNode) {
                this.setProperties(addressNode, address);
                addressNode.save();
                return this.transferNode2Object(addressNode);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot update address " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)brade.getMessage());
        }
        return null;
    }

    public void removeAddress(String id) {
        if (null == id || "".equals(id)) {
            log.error((Object)"ERROR cannot remove address null");
            return;
        }
        try {
            Node addressNode = this.getNodeById(id);
            if (null != addressNode) {
                Session session = addressNode.getSession();
                addressNode.remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot remove address " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)brade.getMessage());
        }
    }

    public Address getAddressById(String id) {
        if (null == id || "".equals(id)) {
            return null;
        }
        try {
            Node node = this.getNodeById(id);
            if (null != node) {
                return this.transferNode2Object(node);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"ERROR getAddressById cannot get address node");
        }
        return null;
    }
}

