/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

import java.util.List;
import java.util.UUID;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;
import org.json.JSONObject;

public class Program {
    private String id;
    private String labelID;
    private String title;
    private Boolean active;
    private List<Manager> managers;
    private JSONObject settings;
    public static final String banner_url_setting_key = "banner_url";
    public static final String email_sender_setting_key = "email_sender";

    public Program(String title) {
        this.setLabelID(UUID.randomUUID().toString());
        this.setTitle(title);
        this.setActive(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabelID() {
        return this.labelID;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Manager> getManagers() {
        return this.managers;
    }

    public void setManagers(List<Manager> managers) {
        this.managers = managers;
    }

    public void checkValid() throws BrandAdvocacyServiceException {
        if (null == this.getTitle() || "".equals(this.getTitle())) {
            throw new BrandAdvocacyServiceException(14, " progam must have title");
        }
        if (null == this.getLabelID() || "".equals(this.getLabelID())) {
            throw new BrandAdvocacyServiceException(8, "program must have label id");
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public JSONObject getSettings() {
        return this.settings;
    }

    public void setSettings(JSONObject settings) {
        this.settings = settings;
    }
}

