/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

public enum Status {
    OPEN(1),
    INPROGRESS(2),
    WAITING_FOR_VALIDATE(3),
    VALIDATED(4),
    SHIPPED(5),
    REJECTED(6);

    private final int status;

    private Status(int status) {
        this.status = status;
    }

    public int getValue() {
        return this.status;
    }

    public String getLabel() {
        switch (this.status) {
            case 6: {
                return "Rejected";
            }
            case 5: {
                return "Shipped";
            }
            case 4: {
                return "Validated";
            }
            case 3: {
                return "Waiting For Validate";
            }
            case 2: {
                return "In Progress";
            }
            case 1: {
                return "Open";
            }
        }
        return "No name";
    }

    public static Status getStatus(int status) {
        for (Status type : Status.values()) {
            if (type.getValue() != status) continue;
            return type;
        }
        return OPEN;
    }
}

