/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

import java.util.List;
import java.util.UUID;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.model.Proposition;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;

public class Mission {
    private String id;
    private String programId;
    private String title;
    private String third_part_link;
    private long priority;
    private Boolean active;
    List<Proposition> propositions;
    private long createdDate;
    private long modifiedDate;
    private List<Manager> managers;
    private String labelID;

    public Mission() {
        this.init();
    }

    public Mission(String title) {
        this.setTitle(title);
        this.init();
    }

    public Mission(String programId, String title) {
        this.setProgramId(programId);
        this.setTitle(title);
        this.init();
    }

    public void init() {
        this.setPriority(0L);
        this.setLabelID(UUID.randomUUID().toString());
        this.setCreatedDate(System.currentTimeMillis());
        this.setModifiedDate(System.currentTimeMillis());
        this.setActive(false);
    }

    public String getLabelID() {
        return this.labelID;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getThird_part_link() {
        return this.third_part_link;
    }

    public void setThird_part_link(String third_part_link) {
        this.third_part_link = third_part_link;
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public List<Proposition> getPropositions() {
        return this.propositions;
    }

    public void setPropositions(List<Proposition> propositions) {
        this.propositions = propositions;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(long modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public List<Manager> getManagers() {
        return this.managers;
    }

    public void setManagers(List<Manager> managers) {
        this.managers = managers;
    }

    public void checkValid() throws BrandAdvocacyServiceException {
        if (null == this.getProgramId() || "".equals(this.getProgramId())) {
            throw new BrandAdvocacyServiceException(6, "mission must belong to a program");
        }
        if (null == this.getLabelID() || "".equals(this.getLabelID())) {
            throw new BrandAdvocacyServiceException(8, "mission must have label id");
        }
        if (null == this.getTitle() || "".equals(this.getTitle()) || this.getTitle().trim().isEmpty()) {
            throw new BrandAdvocacyServiceException(6, "mission must have title");
        }
    }

    public String toString() {
        return this.getTitle() + " - " + this.getActive() + " - " + this.getPriority();
    }

    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }
}

