/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.brandadvocacy.model.Address;
import org.exoplatform.brandadvocacy.model.User;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;

public class Participant
extends User {
    private String programId;
    private List<Address> addresses;
    private Set<String> mission_participant_ids = new HashSet<String>();
    private Set<String> mission_ids = new HashSet<String>();

    public Participant() {
    }

    public Participant(String username) {
        this.setUserName(username);
    }

    public Set<String> getMission_participant_ids() {
        return this.mission_participant_ids;
    }

    public void setMission_participant_ids(Set<String> mission_participant_ids) {
        this.mission_participant_ids = mission_participant_ids;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public void checkValid() throws BrandAdvocacyServiceException {
        if (null == this.getProgramId() || "".equals(this.getProgramId())) {
            throw new BrandAdvocacyServiceException(12, " participant must belong to a program");
        }
        if (null == this.getUserName() || "".equals(this.getUserName())) {
            throw new BrandAdvocacyServiceException(12, "participant must have username");
        }
    }

    public String toString() {
        return this.getClass().getName() + " - username = " + this.getUserName() + " - number missions " + this.getMission_participant_ids().size();
    }

    public Set<String> getMission_ids() {
        return this.mission_ids;
    }

    public void setMission_ids(Set<String> mission_ids) {
        this.mission_ids = mission_ids;
    }

    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }
}

