/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ApacheHttpClient {
    private static final Log log = ExoLogger.getLogger(ApacheHttpClient.class);

    public static void sendRequest(String endpoint, String token, String method, List params) {
        if (null == endpoint || "".equals(endpoint) || null == token || "".equals(token)) {
            return;
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = null;
        if (method.equals("post")) {
            HttpPost httpPost = new HttpPost(endpoint);
            StringEntity input = null;
            try {
                input = new StringEntity(params.toString());
                httpPost.setHeader("Accept", "application/json");
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
                httpPost.setEntity((HttpEntity)input);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                response = httpClient.execute((HttpUriRequest)httpPost);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (ClientProtocolException e) {
                log.error((Object)(" error ClientProtocolException request to " + endpoint));
                e.printStackTrace();
            }
            catch (IOException e) {
                log.error((Object)(" cannot send post request to " + endpoint));
                e.printStackTrace();
            }
        } else {
            HttpGet httpGet = new HttpGet(endpoint);
            httpGet.addHeader("accept", "application/json");
            try {
                response = httpClient.execute((HttpUriRequest)httpGet);
            }
            catch (IOException e) {
                log.error((Object)(" cannot send get request to " + endpoint));
                e.printStackTrace();
            }
        }
        if (null != response) {
            try {
                String output;
                if (response.getStatusLine().getStatusCode() != 200) {
                    log.error((Object)"error request ");
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                log.info((Object)"Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    log.info((Object)output);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        httpClient.getConnectionManager().shutdown();
    }
}

