/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.exoplatform.brandadvocacy.service.JCRImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class DAO {
    private static final Log log = ExoLogger.getLogger(DAO.class);
    private JCRImpl jcrImplService;

    public JCRImpl getJcrImplService() {
        return this.jcrImplService;
    }

    public void setJcrImplService(JCRImpl jcrImplService) {
        this.jcrImplService = jcrImplService;
    }

    public DAO(JCRImpl jcrImpl) {
        this.jcrImplService = jcrImpl;
    }

    public List<Node> getNodesByQuery(String sql, int offset, int limit) {
        ArrayList<Node> list = new ArrayList<Node>();
        try {
            Session session = this.getJcrImplService().getSession();
            QueryImpl query = (QueryImpl)session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            if (0 != offset) {
                query.setOffset((long)offset);
            }
            if (0 != limit) {
                query.setLimit((long)limit);
            }
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                list.add(nodes.nextNode());
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot get nodes by query  " + sql));
            e.printStackTrace();
        }
        return list;
    }

    public Node getNodeById(String id) throws RepositoryException {
        return this.getJcrImplService().getSession().getNodeByUUID(id);
    }

    public Node getOrCreateNodeCommon(Node parent, String refChild, String nodeChildType) throws RepositoryException {
        Node child = parent.hasNode(refChild) ? parent.getNode(refChild) : parent.addNode(refChild, nodeChildType);
        return child;
    }

    protected String getProgramJcrPath(String programId) {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("/BrandAdvocacys").append("/").append(programId).append("/");
        return stringBuilder.toString();
    }
}

