/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.jcr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.brandadvocacy.jcr.DAO;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.model.Role;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;
import org.exoplatform.brandadvocacy.service.JCRImpl;
import org.exoplatform.brandadvocacy.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ManagerDAO
extends DAO {
    public static final String node_prop_parent_id = "exo:parent_id";
    public static final String node_prop_username = "exo:username";
    public static final String node_prop_role = "exo:role";
    public static final String node_prop_notif = "exo:notification";
    private static final Log log = ExoLogger.getLogger(ManagerDAO.class);

    public ManagerDAO(JCRImpl jcrImpl) {
        super(jcrImpl);
    }

    private Node getOrCreateProgramManagerHome(String programId) {
        if (null == programId || "".equals(programId)) {
            log.error((Object)"ERROR cannot get mission home for an invalid program id ");
            return null;
        }
        try {
            Node node = this.getNodeById(programId);
            return this.getJcrImplService().getProgramDAO().getOrCreateManagerHome(node);
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot get mission home for an invalid program " + e.getMessage()));
            return null;
        }
    }

    private Node getOrCreateMissionManagerHome(String missionId) {
        if (null == missionId || "".equals(missionId)) {
            log.error((Object)"ERROR cannot get mission home for an invalid program id ");
            return null;
        }
        try {
            Node node = this.getNodeById(missionId);
            return this.getJcrImplService().getMissionDAO().getOrCreateManagerHome(node);
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot get mission home for an invalid program " + e.getMessage()));
            return null;
        }
    }

    private void setProperties(Node aNode, Manager m) throws RepositoryException {
        aNode.setProperty(node_prop_parent_id, m.getParentId());
        aNode.setProperty(node_prop_username, m.getUserName());
        aNode.setProperty(node_prop_notif, m.getNotif().booleanValue());
        aNode.setProperty(node_prop_role, (long)m.getRole().getValue());
    }

    public Manager transferNode2Object(Node node) throws RepositoryException {
        if (null == node) {
            return null;
        }
        Manager manager = new Manager();
        PropertyIterator iter = node.getProperties("exo:*");
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            String name = p.getName();
            if (name.equals(node_prop_parent_id)) {
                manager.setParentId(p.getString());
                continue;
            }
            if (name.equals(node_prop_username)) {
                manager.setUserName(p.getString());
                continue;
            }
            if (name.equals(node_prop_role)) {
                manager.setRole(Role.getRole((int)p.getLong()));
                continue;
            }
            if (!name.equals(node_prop_notif)) continue;
            manager.setNotif(p.getBoolean());
        }
        try {
            manager.checkValid();
            return manager;
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)"ERROR cannot transfer node to manager object");
            return null;
        }
    }

    public List<Manager> transferNodes2Objects(List<Node> nodes) {
        ArrayList<Manager> managers = new ArrayList<Manager>(nodes.size());
        for (Node node : nodes) {
            try {
                Manager manager = this.transferNode2Object(node);
                if (null == manager) continue;
                managers.add(manager);
            }
            catch (RepositoryException e) {
                log.error((Object)("ERROR cannot transfer node to manager object " + e.getMessage()));
            }
        }
        return managers;
    }

    private Node getMissionManagerNodeById(String missionId, String username) {
        StringBuilder sql = new StringBuilder("select * from brad:manager where ");
        sql.append(node_prop_parent_id).append(" = '").append(missionId).append("'");
        sql.append(" AND ").append(node_prop_username).append(" = '").append(Utils.queryEscape(username)).append("'");
        return this.getNodesByQuery(sql.toString(), 0, 1).get(0);
    }

    private Node addManager(Node homeNode, Manager manager) {
        try {
            manager.checkValid();
            if (!homeNode.hasNode(manager.getUserName())) {
                Node managerNode = homeNode.addNode(manager.getUserName(), "brad:manager");
                this.setProperties(managerNode, manager);
                homeNode.save();
                return managerNode;
            }
            return homeNode.getNode(manager.getUserName());
        }
        catch (RepositoryException re) {
            log.error((Object)("ERROR cannot add manager " + re.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR cannot add manager " + brade.getMessage()));
        }
        return null;
    }

    public Manager addManager2Mission(Manager manager) {
        try {
            manager.checkValid();
            String mid = manager.getParentId();
            Node nodeHome = this.getOrCreateMissionManagerHome(mid);
            if (null != nodeHome) {
                return this.transferNode2Object(this.addManager(nodeHome, manager));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot add manager to mission " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR " + brade.getMessage()));
        }
        return null;
    }

    public List<Manager> addManagers2Mission(String mid, List<Manager> managers) {
        ArrayList<Node> nodes = new ArrayList<Node>(managers.size());
        Node nodeHome = this.getOrCreateMissionManagerHome(mid);
        if (null != nodeHome) {
            for (Manager manager : managers) {
                manager.setParentId(mid);
                Node node = this.addManager(nodeHome, manager);
                if (null == node) continue;
                nodes.add(node);
            }
            if (nodes.size() > 0) {
                return this.transferNodes2Objects(nodes);
            }
        }
        return null;
    }

    public List<Manager> getAllMissionManagers(String mid) {
        if (null == mid || "".equals(mid)) {
            log.error((Object)"ERROR cannot get all managers from mission null");
            return null;
        }
        try {
            Node managerHomeNode = this.getOrCreateMissionManagerHome(mid);
            if (null != managerHomeNode) {
                NodeIterator nodes = managerHomeNode.getNodes();
                return this.transferNodes2Objects(Lists.newArrayList((Iterator)nodes));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR get all managers " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)(" ERROR cannot get all managers " + brade.getMessage()));
        }
        return null;
    }

    public Manager updateMissionManager(String missionId, Manager manager) {
        try {
            manager.checkValid();
            Node managerNode = this.getMissionManagerNodeById(missionId, manager.getUserName());
            if (null != managerNode) {
                this.setProperties(managerNode, manager);
                managerNode.save();
                return this.transferNode2Object(managerNode);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot update manager " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)brade.getMessage());
        }
        return null;
    }

    public void removeMissionManager(String missionId, String username) {
        try {
            Node managerNode = this.getMissionManagerNodeById(missionId, username);
            if (null != managerNode) {
                Session session = managerNode.getSession();
                managerNode.remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot remove manager " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)brade.getMessage());
        }
    }

    public Manager getMissionManagerByUserName(String missionId, String username) {
        if (null == username || null == missionId || "".equals(missionId) || "".equals(username)) {
            return null;
        }
        try {
            return this.transferNode2Object(this.getMissionManagerNodeById(missionId, username));
        }
        catch (RepositoryException e) {
            log.error((Object)" ERROR cannot get manager from mission");
            return null;
        }
    }

    public Manager addManager2Program(Manager manager) {
        try {
            manager.checkValid();
            String programId = manager.getParentId();
            Node nodeHome = this.getOrCreateProgramManagerHome(programId);
            if (null != nodeHome) {
                return this.transferNode2Object(this.addManager(nodeHome, manager));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot add manager 2 program " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR " + brade.getMessage()));
        }
        return null;
    }

    public List<Manager> addManagers2Program(String programId, List<Manager> managers) {
        ArrayList<Node> nodes = new ArrayList<Node>(managers.size());
        Node nodeHome = this.getOrCreateProgramManagerHome(programId);
        if (null != nodeHome) {
            for (Manager manager : managers) {
                manager.setParentId(programId);
                Node node = this.addManager(nodeHome, manager);
                if (null == node) continue;
                nodes.add(node);
            }
            if (nodes.size() > 0) {
                return this.transferNodes2Objects(nodes);
            }
        }
        return null;
    }

    private Node getProgramManagerNodeById(String programId, String username) {
        Node homeNode = this.getOrCreateProgramManagerHome(programId);
        if (null != homeNode) {
            try {
                if (homeNode.hasNode(username)) {
                    return homeNode.getNode(username);
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<Manager> getAllManagersInProgram(String programId) {
        try {
            Node nodeHome = this.getOrCreateProgramManagerHome(programId);
            if (null != nodeHome) {
                NodeIterator nodes = nodeHome.getNodes();
                return this.transferNodes2Objects(Lists.newArrayList((Iterator)nodes));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR get all managers " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)(" ERROR cannot get all managers " + brade.getMessage()));
        }
        return null;
    }

    public Manager getProgramManagerByUserName(String programId, String username) {
        try {
            return this.transferNode2Object(this.getProgramManagerNodeById(programId, username));
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot get program manager " + e.getMessage()));
            return null;
        }
    }

    public Boolean removeManagerFromProgram(String programId, String username) {
        Node managerNode = this.getProgramManagerNodeById(programId, username);
        if (null != managerNode) {
            try {
                Session session = managerNode.getSession();
                managerNode.remove();
                session.save();
                return true;
            }
            catch (RepositoryException e) {
                log.error((Object)("ERROR cannot remove manager from program " + e.getMessage()));
            }
        }
        return false;
    }

    public Manager updateProgramManager(Manager manager) {
        try {
            manager.checkValid();
            String programId = manager.getParentId();
            Node managerNode = this.getProgramManagerNodeById(programId, manager.getUserName());
            if (null != managerNode) {
                this.setProperties(managerNode, manager);
                managerNode.save();
                return this.transferNode2Object(managerNode);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot update program manager" + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR cannot update program manager" + brade.getMessage()));
        }
        return null;
    }
}

