/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.brandadvocacy.jcr.DAO;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;
import org.exoplatform.brandadvocacy.service.JCRImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgramDAO
extends DAO {
    private static final Log log = ExoLogger.getLogger(ProgramDAO.class);
    public static final String node_prop_labelID = "exo:labelID";
    public static final String node_prop_title = "exo:title";
    public static final String node_prop_active = "exo:active";
    public static final String node_prop_managers = "exo:managerslist";
    public static final String node_prop_missions = "exo:missionslist";
    public static final String node_prop_participants = "exo:participantslist";
    public static final String node_prop_missionparticipants = "exo:missionparticipantslist";
    public static final String node_prop_settings = "exo:settings";
    public static final String node_prop_settings_programId = "exo:program_id";
    public static final String node_settings = "exo:program-settings";

    public ProgramDAO(JCRImpl jcrImpl) {
        super(jcrImpl);
    }

    public Node getOrSettingsHome() throws RepositoryException {
        Node extensionHome = this.getJcrImplService().getOrCreateExtensionHome();
        if (null != extensionHome) {
            if (extensionHome.hasNode(node_settings)) {
                return extensionHome.getNode(node_settings);
            }
            Node aNode = extensionHome.addNode(node_settings, "nt:unstructured");
            extensionHome.save();
            return aNode;
        }
        return null;
    }

    public Node getOrCreateManagerHome(Node node) throws RepositoryException {
        return this.getOrCreateNodeCommon(node, node_prop_managers, "brad:managerslist");
    }

    public Node getOrCreateMissionHome(Node node) throws RepositoryException {
        return this.getOrCreateNodeCommon(node, node_prop_missions, "brad:missionslist");
    }

    public Node getOrCreateParticipantHome(Node node) throws RepositoryException {
        return this.getOrCreateNodeCommon(node, node_prop_participants, "brad:participantslist");
    }

    public Node getOrCreateMissionParticipantHome(Node node) throws RepositoryException {
        return this.getOrCreateNodeCommon(node, node_prop_missionparticipants, "brad:missionparticipantslist");
    }

    private void setSettingsPropertiesNode(Node node, Program program) throws RepositoryException {
        node.setProperty(node_prop_settings_programId, program.getId());
        node.setProperty(node_prop_settings, program.getSettings().toString());
    }

    private JSONObject transferNode2SettingsObject(Node node) throws RepositoryException {
        if (node.hasProperty(node_prop_settings)) {
            String settings = node.getProperty(node_prop_settings).getString();
            try {
                if (null != settings && !"".equals(settings)) {
                    return new JSONObject(settings);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void setPropertiesNode(Node node, Program program) throws RepositoryException {
        node.setProperty(node_prop_labelID, program.getLabelID());
        node.setProperty(node_prop_title, program.getTitle());
        node.setProperty(node_prop_active, program.getActive().booleanValue());
    }

    private Program transferNode2Object(Node node) throws RepositoryException {
        Program program = new Program("");
        program.setId(node.getUUID());
        PropertyIterator iter = node.getProperties("exo:*");
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            String name = p.getName();
            if (name.equals(node_prop_labelID)) {
                program.setLabelID(p.getString());
                continue;
            }
            if (name.equals(node_prop_title)) {
                program.setTitle(p.getString());
                continue;
            }
            if (!name.equals(node_prop_active)) continue;
            program.setActive(p.getBoolean());
        }
        try {
            program.checkValid();
            return program;
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)(" ERROR cannot tranfert node to program object " + brade.getMessage()));
            return null;
        }
    }

    private List<Program> transferNodes2Objects(List<Node> nodes) {
        ArrayList<Program> programs = new ArrayList<Program>(nodes.size());
        for (Node node : nodes) {
            Program program = null;
            try {
                program = this.transferNode2Object(node);
                if (null == program) continue;
                programs.add(program);
            }
            catch (RepositoryException e) {
                log.error((Object)"ERROR cannot transfert nodes to program list");
            }
        }
        return programs;
    }

    public Program addProgram(Program program) {
        try {
            program.checkValid();
            Node extensionHome = this.getJcrImplService().getOrCreateExtensionHome();
            if (null != extensionHome) {
                Node node = extensionHome.addNode(program.getLabelID(), "brad:program");
                this.setPropertiesNode(node, program);
                extensionHome.getSession().save();
                return this.transferNode2Object(node);
            }
        }
        catch (RepositoryException re) {
            log.error((Object)("ERROR cannot add program " + re.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR cannot add program " + brade.getMessage()));
        }
        return null;
    }

    public Program updateProgram(Program program) {
        try {
            program.checkValid();
            Node node = this.getNodeById(program.getId());
            this.setPropertiesNode(node, program);
            node.save();
            return this.transferNode2Object(node);
        }
        catch (RepositoryException re) {
            log.error((Object)("ERROR cannot update program " + re.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR cannot update program " + brade.getMessage()));
        }
        return null;
    }

    public Program getProgramById(String id) {
        if (null == id || "".equals(id)) {
            throw new BrandAdvocacyServiceException(8, "cannot get program by invalid id ");
        }
        try {
            Node node = this.getNodeById(id);
            if (null != node) {
                return this.transferNode2Object(node);
            }
        }
        catch (RepositoryException re) {
            log.error((Object)("ERROR cannot get program by id " + id));
        }
        return null;
    }

    public List<Program> getAllPrograms() {
        Node node = this.getJcrImplService().getOrCreateExtensionHome();
        ArrayList<Node> nodePrograms = new ArrayList<Node>();
        try {
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node nodeProgram = nodeIterator.nextNode();
                if (!nodeProgram.isNodeType("brad:program")) continue;
                nodePrograms.add(nodeProgram);
            }
            return this.transferNodes2Objects(nodePrograms);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject saveSettings(Program program) {
        if (null != program.getSettings() && !"".equals(program.getSettings().toString())) {
            try {
                Node settingsHome = this.getOrSettingsHome();
                Node settingsNode = null;
                if (null != settingsHome && null != (settingsNode = !settingsHome.hasNode(program.getId()) ? settingsHome.addNode(program.getId(), "brad:program-settings") : settingsHome.getNode(program.getId()))) {
                    this.setSettingsPropertiesNode(settingsNode, program);
                    settingsHome.save();
                    return this.transferNode2SettingsObject(settingsNode);
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public JSONObject getSettings(String programId) {
        Object programNode = null;
        try {
            Node settingsHome = this.getOrSettingsHome();
            if (settingsHome.hasNode(programId)) {
                return this.transferNode2SettingsObject(settingsHome.getNode(programId));
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return null;
    }
}

