/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.SecurityContext;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.model.MissionParticipant;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.model.Role;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.LoginController;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.MissionParticipantController;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.confirmpopup;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.error;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.index;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.json.JSONObject;

public class JuZBackEndApplication {
    @Inject
    @Path(value="index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="error.gtmpl")
    error errorTpl;
    @Inject
    @Path(value="confirmpopup.gtmpl")
    confirmpopup confirmpopupTpl;
    OrganizationService organizationService;
    IService jcrService;
    @Inject
    LoginController loginController;
    @Inject
    MissionParticipantController missionParticipantController;

    @Inject
    public JuZBackEndApplication(OrganizationService organizationService, IService iService) {
        this.organizationService = organizationService;
        this.jcrService = iService;
    }

    @View
    public Response index(SecurityContext securityContext) {
        if (null == this.loginController.getCurrentProgramId()) {
            List programs = this.jcrService.getAllPrograms();
            Program program = null;
            this.loginController.setCurrentUserName(securityContext.getUserPrincipal().getName());
            if (programs.size() > 0) {
                program = (Program)programs.get(0);
                this.loginController.setCurrentProgramId(program.getId());
            }
            this.generateRights(this.loginController.getCurrentProgramId(), this.loginController.getCurrentUserName());
        }
        if (null != this.loginController.getRights()) {
            MissionParticipant missionParticipant;
            String action = WebuiRequestContext.getCurrentInstance().getRequestParameter("action");
            String id = WebuiRequestContext.getCurrentInstance().getRequestParameter("id");
            String[] menus = new String[]{"program", "mission", "participant", "mp_view", "m_view"};
            if (null != action && !Arrays.asList(menus).contains(action)) {
                action = null;
            }
            if (this.loginController.isAdmin().booleanValue()) {
                if (null == action) {
                    action = "program";
                }
            } else if (null == action || "program".equals(action) || "mission".equals(action) || "m_view".equals(action)) {
                action = "participant";
            }
            String username = "";
            if (null == id) {
                id = "";
            }
            if (action.equals("mp_view") && null != (missionParticipant = this.jcrService.getMissionParticipantById(id))) {
                username = missionParticipant.getParticipant_username();
            }
            return this.indexTpl.with().set("action", (Object)action).set("username", (Object)username).set("id", (Object)id).ok();
        }
        return this.showError("alert-info", "Info", "You have no rights");
    }

    public Response showError(String type, String icon, String msg) {
        return this.errorTpl.with().set("type", (Object)type).set("icon", (Object)icon).set("msg", (Object)msg).ok();
    }

    @View
    public Response showError(String msg) {
        return this.indexTpl.with().set("msg", (Object)msg).ok();
    }

    private void generateRights(String programId, String username) {
        if (null != programId && null != username) {
            Manager manager = this.jcrService.getProgramManagerByUserName(programId, username);
            if (null != manager) {
                this.loginController.setRights(manager.getRole().getLabel());
            }
        } else {
            this.loginController.setRights(Role.Admin.getLabel());
        }
    }

    @Ajax
    @Resource
    public Response loadConfirmPopupContent(String action, String id, String msg) {
        return this.confirmpopupTpl.with().set("action", (Object)action).set("id", (Object)id).set("msg", (Object)msg).ok();
    }

    @Ajax
    @Resource
    public void sendNotifUpdateMissionParticipantEmail(String missionParticipantId, String note) {
        JSONObject settings = this.jcrService.getProgramSettings(this.loginController.getCurrentProgramId());
        this.jcrService.sendNotifMissionParticipantEmail(settings, missionParticipantId, note);
    }
}

