/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.portlet.chat;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="wikiService")
@ApplicationScoped
public class WikiService {
    org.exoplatform.wiki.service.WikiService wikiService_;
    Logger log = Logger.getLogger("WikiService");

    @Inject
    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    protected void createIntranetPage(String title, String content) {
        this.createOrEditPage("Meeting Notes", title, content, false, null);
    }

    protected void createSpacePage(String title, String content, String spaceGroupId) {
        this.createOrEditPage("Meeting Notes", title, content, false, spaceGroupId);
    }

    private void createOrEditPage(String parentTitle, String title, String content, boolean forceNew, String spaceGroupId) {
        String wikiType = PortalConfig.PORTAL_TYPE;
        String wikiOwner = "intranet";
        if (spaceGroupId != null) {
            wikiType = PortalConfig.GROUP_TYPE;
            wikiOwner = spaceGroupId;
        }
        try {
            if (!this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)parentTitle, (boolean)false))) {
                PageImpl ppage = (PageImpl)this.wikiService_.createPage(wikiType, wikiOwner, parentTitle, TitleResolver.getId((String)"Wiki Home", (boolean)false));
                ppage.getContent().setText("= " + parentTitle + " =\n");
                ppage.setSyntax(Syntax.XWIKI_2_0.toIdString());
                ppage.checkin();
                ppage.checkout();
            }
            PageImpl page = this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false)) ? (PageImpl)this.wikiService_.getPageById(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false)) : (PageImpl)this.wikiService_.createPage(wikiType, wikiOwner, title, TitleResolver.getId((String)parentTitle, (boolean)false));
            page.getContent().setText(content);
            page.setSyntax(Syntax.XWIKI_2_0.toIdString());
            page.checkin();
            page.checkout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

