/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.portlet.chat;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="wikiService")
@ApplicationScoped
public class WikiService {
    org.exoplatform.wiki.service.WikiService wikiService_;
    Logger log = Logger.getLogger("WikiService");

    @Inject
    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    protected String createIntranetPage(String title, String content) {
        return this.createOrEditPage("Meeting Notes", title, content, false, null);
    }

    protected String createSpacePage(String title, String content, String spaceGroupId) {
        return this.createOrEditPage("Meeting Notes", title, content, false, spaceGroupId);
    }

    private String createOrEditPage(String parentTitle, String title, String content, boolean forceNew, String spaceGroupId) {
        String wikiType = PortalConfig.PORTAL_TYPE;
        String wikiOwner = "intranet";
        String path = "";
        if (spaceGroupId != null) {
            wikiType = PortalConfig.GROUP_TYPE;
            wikiOwner = spaceGroupId;
        }
        try {
            if (!this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)parentTitle, (boolean)false))) {
                PageImpl ppage = (PageImpl)this.wikiService_.createPage(wikiType, wikiOwner, parentTitle, TitleResolver.getId((String)"Wiki Home", (boolean)false));
                ppage.getContent().setText("= " + parentTitle + " =\n");
                ppage.setSyntax(Syntax.XWIKI_2_0.toIdString());
                ppage.checkin();
                ppage.checkout();
            }
            PageImpl page = this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false)) ? (PageImpl)this.wikiService_.getPageById(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false)) : (PageImpl)this.wikiService_.createPage(wikiType, wikiOwner, title, TitleResolver.getId((String)parentTitle, (boolean)false));
            page.getContent().setText(content);
            page.setSyntax(Syntax.XWIKI_2_0.toIdString());
            page.setMinorEdit(false);
            page.checkin();
            page.checkout();
            if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
                path = "/portal/intranet/wiki/" + wikiType + "/" + wikiOwner + "/" + page.getName();
            } else if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                path = "/portal/intranet/wiki/" + page.getName();
            }
            this.wikiService_.postAddPage(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false), (Page)page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }
}

