/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.chat;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

@Named(value="calendarService")
@ApplicationScoped
public class CalendarService {
    org.exoplatform.calendar.service.CalendarService calendarService_;
    OrganizationService organizationService_;
    private static final Logger LOG = Logger.getLogger("CalendarService");

    @Inject
    public CalendarService(org.exoplatform.calendar.service.CalendarService calendarService, OrganizationService organizationService) {
        this.calendarService_ = calendarService;
        this.organizationService_ = organizationService;
    }

    protected void saveEvent(String user, String calName, String users, String summary, Date from, Date to, String location) throws Exception {
        if (!"".equals(users)) {
            String[] participants;
            for (String participant : participants = users.split(",")) {
                String calId = this.getFirstCalendarsId(participant);
                this.saveEvent(participant, false, participants, calId, calName, summary, from, to, location);
            }
        } else {
            String calId = this.getCalendarId(user, calName);
            this.saveEvent(user, true, null, calId, calName, summary, from, to, location);
        }
    }

    protected void saveEvent(String user, boolean isPublic, String[] participants, String calId, String calName, String summary, Date from, Date to, String location) throws Exception {
        summary = ChatUtils.escapeSpecialCharacters((String)summary);
        location = ChatUtils.escapeSpecialCharacters((String)location);
        if (calId != null) {
            CalendarEvent event = new CalendarEvent();
            event.setCalendarId(calId);
            event.setSummary(summary);
            event.setEventType(CalendarEvent.TYPE_EVENT);
            event.setRepeatType(CalendarEvent.RP_NOREPEAT);
            event.setPrivate(true);
            event.setFromDateTime(from);
            event.setToDateTime(to);
            event.setPriority(CalendarEvent.PRIORITY_NORMAL);
            event.setLocation(location);
            if (isPublic) {
                this.calendarService_.savePublicEvent(calId, event, true);
            } else {
                if (participants != null) {
                    event.setParticipant(participants);
                    String[] participantsStatus = new String[participants.length];
                    for (int i = 0; i < participants.length; ++i) {
                        participantsStatus[i] = participants[i] + ":confirmed";
                    }
                    event.setParticipantStatus(participantsStatus);
                }
                this.calendarService_.saveUserEvent(user, calId, event, true);
            }
        }
    }

    protected void saveTask(String currentUser, String username, String summary, String roomName, String isSpace, Date from, Date to) throws Exception {
        summary = ChatUtils.escapeSpecialCharacters((String)summary);
        CalendarEvent task = new CalendarEvent();
        task.setSummary(summary);
        task.setEventType(CalendarEvent.TYPE_TASK);
        task.setRepeatType(CalendarEvent.RP_NOREPEAT);
        task.setPrivate(true);
        task.setFromDateTime(from);
        task.setToDateTime(to);
        task.setPriority(CalendarEvent.PRIORITY_NORMAL);
        task.setTaskDelegator(username);
        task.setDescription("Created by " + currentUser + " for " + username);
        String calId = null;
        if ("true".equals(isSpace)) {
            calId = this.getCalendarId(currentUser, roomName);
        }
        if (calId != null) {
            task.setCalendarId(calId);
            this.calendarService_.savePublicEvent(calId, task, true);
        } else if (!StringUtils.isEmpty((CharSequence)username)) {
            String[] assignees;
            for (String assignee : assignees = username.split(",")) {
                String assigneeCalId = this.getFirstCalendarsId(assignee);
                task.setCalendarId(assigneeCalId);
                this.calendarService_.saveUserEvent(assignee, assigneeCalId, task, true);
            }
        }
    }

    private String getFirstCalendarsId(String username) {
        StringBuilder sb = new StringBuilder();
        List listUserCalendar = null;
        try {
            listUserCalendar = this.calendarService_.getUserCalendars(username, true);
            if (listUserCalendar.size() > 0) {
                return ((Calendar)listUserCalendar.get(0)).getId();
            }
        }
        catch (Exception e) {
            LOG.info("Error while checking User Calendar :" + e.getMessage());
        }
        return null;
    }

    private String getCalendarId(String username, String space) {
        String id = null;
        StringBuilder sb = new StringBuilder();
        List listgroupCalendar = null;
        try {
            listgroupCalendar = this.calendarService_.getGroupCalendars(this.getUserGroups(username), true, username);
        }
        catch (Exception e) {
            LOG.info("Error while checking User Calendar :" + e.getMessage());
        }
        for (GroupCalendarData g : listgroupCalendar) {
            for (Calendar c : g.getCalendars()) {
                if (!space.equals(c.getName())) continue;
                id = c.getId();
            }
        }
        return id;
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.organizationService_.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }
}

