/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ServerBootstrap {
    private static final Log LOG = ExoLogger.getLogger((String)ServerBootstrap.class.getName());
    private static String serverBase = null;
    private static String serverURL = null;
    private static String serverURI = null;

    public static String getDBName() {
        String dbName = "";
        String prefixDB = PropertyManager.getProperty((String)"dbName");
        ConversationState currentState = ConversationState.getCurrent();
        if (currentState != null) {
            dbName = (String)currentState.getAttribute("currentTenant");
        }
        if (StringUtils.isEmpty((String)dbName)) {
            dbName = prefixDB;
        } else {
            StringBuilder sb = new StringBuilder().append(prefixDB).append("_").append(dbName);
            dbName = sb.toString();
        }
        return dbName;
    }

    public static String getStatus(String username, String token, String targetUser, String dbName) {
        return ServerBootstrap.callServer("getStatus", "user=" + username + "&targetUser=" + targetUser + "&token=" + token + "&dbName=" + dbName);
    }

    public static String getUsers(String username, String token, String room, String dbName) {
        return ServerBootstrap.callServer("users", "user=" + username + "&dbName=" + dbName + "&room=" + room + "&token=" + token);
    }

    public static String getUserFullName(String username, String dbName) {
        return ServerBootstrap.callServer("getUserFullName", "username=" + username + "&dbName=" + dbName);
    }

    public static void addUser(String username, String token, String dbName) {
        ServerBootstrap.postServer("addUser", "username=" + username + "&token=" + token + "&dbName=" + dbName);
    }

    public static void logout(String username, String token, String sessionId, String dbName, boolean uniqueSession) {
        ServerBootstrap.postServer("logout", "username=" + username + "&token=" + token + "&sessionId=" + sessionId + "&dbName=" + dbName + "&uniqueSession=" + uniqueSession);
    }

    public static void setAsAdmin(String username, boolean isAdmin, String dbName) {
        ServerBootstrap.postServer("setAsAdmin", "username=" + username + "&isAdmin=" + isAdmin + "&dbName=" + dbName);
    }

    public static void addUserFullNameAndEmail(String username, String fullname, String email, String dbName) {
        try {
            ServerBootstrap.postServer("addUserFullNameAndEmail", "username=" + username + "&fullname=" + ChatUtils.toString((Serializable)((Object)fullname)) + "&email=" + email + "&dbName=" + dbName);
        }
        catch (IOException e) {
            LOG.error("Error while updating user information for user {} [ {} ]", new Object[]{username, email, e});
        }
    }

    public static String getToken(String username) {
        String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
        String in = username + passphrase;
        String token = MessageDigester.getHash((String)in);
        return token;
    }

    public static void saveSpaces(String username, String dbName) {
        try {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            ListAccess spacesListAccess = spaceService.getAccessibleSpacesWithListAccess(username);
            List<Object> spaces = Arrays.asList(spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                beans.add(spaceBean);
            }
            ServerBootstrap.setSpaces(username, new SpaceBeans(beans), dbName);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while initializing spaces of User '" + username + "'"), (Throwable)e);
        }
    }

    public static void setSpaces(String username, SpaceBeans beans, String dbName) {
        String params = "username=" + username;
        String serSpaces = "";
        try {
            serSpaces = ChatUtils.toString((Serializable)beans);
            serSpaces = URLEncoder.encode(serSpaces, "UTF-8");
        }
        catch (IOException e) {
            LOG.error((Object)"Error encoding spaces", (Throwable)e);
        }
        params = params + "&spaces=" + serSpaces;
        params = params + "&dbName=" + dbName;
        ServerBootstrap.postServer("setSpaces", params);
    }

    private static String callServer(String serviceUri, String params) {
        String serverURLBase = ServerBootstrap.getServerURL() + "/" + serviceUri;
        String serviceUrl = serverURLBase + "?passphrase=" + PropertyManager.getProperty((String)"chatPassPhrase") + "&" + params;
        String body = null;
        try {
            URL url = new URL(serviceUrl);
            URLConnection con = url.openConnection();
            InputStream in = con.getInputStream();
            String encoding = con.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            body = IOUtils.toString((InputStream)in, (String)encoding);
            if ("null".equals(body)) {
                body = null;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Malformed URI " + serverURLBase), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not establish connection to URL " + serverURLBase), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error occurred while sending request to " + serverURLBase), (Throwable)e);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String postServer(String serviceUri, String params) {
        String serviceUrl = ServerBootstrap.getServerURL() + "/" + serviceUri;
        String allParams = "passphrase=" + PropertyManager.getProperty((String)"chatPassPhrase") + "&" + params;
        String body = null;
        OutputStreamWriter writer = null;
        try {
            URL url = new URL(serviceUrl);
            URLConnection con = url.openConnection();
            int timeout = Integer.parseInt(PropertyManager.getProperty((String)"request.timeout"));
            con.setConnectTimeout(timeout);
            con.setReadTimeout(timeout);
            con.setDoOutput(true);
            writer = new OutputStreamWriter(con.getOutputStream());
            writer.write(allParams);
            writer.flush();
            InputStream in = con.getInputStream();
            String encoding = con.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            body = IOUtils.toString((InputStream)in, (String)encoding);
            if ("null".equals(body)) {
                body = null;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Malformed URL " + serviceUrl), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error converting input stream", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error occurred while sending request to " + serviceUrl), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when closing writer", (Throwable)e);
                }
            }
        }
        return body;
    }

    public static String getServerURL() {
        if (StringUtils.isBlank((String)serverURL)) {
            ServerBootstrap.init();
        }
        if (StringUtils.isNotBlank((String)serverURL) && serverURL.startsWith("http")) {
            return serverURL;
        }
        serverURL = ServerBootstrap.getServerBase() + ServerBootstrap.getServerURI();
        return serverURL;
    }

    public static String getServerURI() {
        if (StringUtils.isBlank((String)serverURI)) {
            ServerBootstrap.init();
        }
        return serverURI;
    }

    public static String getServerBase() {
        if (StringUtils.isBlank((String)serverBase)) {
            ServerBootstrap.init();
        }
        return serverBase;
    }

    public static void init(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((String)serverBase)) {
            String scheme = request.getScheme();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            serverBase = scheme + "://" + serverName;
            if (serverPort != 80) {
                serverBase = serverBase + ":" + serverPort;
            }
        }
    }

    public static final void init() {
        serverURL = PropertyManager.getProperty((String)"chatServerUrl");
        serverURI = PropertyManager.getProperty((String)"chatServerUrl");
        serverBase = PropertyManager.getProperty((String)"chatServerBase");
        if (StringUtils.isBlank((String)serverBase)) {
            serverBase = PropertyManager.getProperty((String)"exo.base.url");
        }
    }
}

