/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.service;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;

@Path(value="/chat/api/1.0/file/")
public class DocumentService
implements ResourceContainer {
    public static final String FILE_CREATED_ACTIVITY = "ActivityNotify.event.FileCreated";
    public static final String UPLOAD_LIMIT_PARAMETER = "upload.limit";
    public static final int MB_IN_BYTES = 0x100000;
    private static final Log LOG = ExoLogger.getLogger((String)DocumentService.class.getName());
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private SessionProviderService sessionProviderService_;
    private SpaceService spaceService_;
    private ListenerService listenerService_;
    private UploadService uploadService_;
    private ActivityCommonService activityService_;
    private int uploadLimit = 100;

    public DocumentService(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, UploadService uploadService, SpaceService spaceService, ActivityCommonService activityService, ListenerService listenerService, InitParams params) {
        String uploadLimitString;
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.sessionProviderService_ = sessionProviderService;
        this.spaceService_ = spaceService;
        this.listenerService_ = listenerService;
        this.uploadService_ = uploadService;
        this.activityService_ = activityService;
        if (params.containsKey((Object)UPLOAD_LIMIT_PARAMETER) && StringUtils.isNotBlank((String)(uploadLimitString = params.getValueParam(UPLOAD_LIMIT_PARAMETER).getValue()))) {
            try {
                this.uploadLimit = Integer.parseInt(uploadLimitString);
            }
            catch (Exception e) {
                LOG.warn((Object)"upload.limit parameter should be a number");
            }
        }
    }

    @POST
    @Path(value="persist")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response persistFile(@Context SecurityContext securityContext, @Context HttpServletRequest httpServletRequest, @FormParam(value="uploadId") String uploadId, @FormParam(value="targetRoom") String targetRoom, @FormParam(value="targetFullname") String targetFullname, @FormParam(value="token") String token, @FormParam(value="dbName") String dbName) throws Exception {
        String users;
        String remoteUser = securityContext.getUserPrincipal().getName();
        String room = targetRoom.replace("team-", "").replace("space-", "");
        String string = users = targetRoom.startsWith("team-") ? ServerBootstrap.getUsers(remoteUser, token, room, dbName) : null;
        List<String> usernames = targetRoom.startsWith("team-") ? this.getUsernamesFromJSON(users) : (targetRoom.startsWith("space-") ? Collections.emptyList() : Collections.singletonList(targetRoom));
        UploadResource uploadResource = this.uploadService_.getUploadResource(uploadId);
        if (this.uploadLimit > 0 && (double)this.uploadLimit < uploadResource.getUploadedSize() / 1048576.0) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        Node node = this.storeFile(uploadResource, remoteUser, targetRoom, targetFullname, usernames);
        String workspace = node.getSession().getWorkspace().getName();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String nodePathWithWorkspace = workspace + node.getPath();
        String baseDavPath = "/jcr/" + repository + "/" + nodePathWithWorkspace;
        String publicURL = RestUtils.getBaseRestUrl() + baseDavPath;
        String thumbnailURL = "/" + CommonsUtils.getRestContextName() + "/thumbnailImage/large/" + repository + "/" + nodePathWithWorkspace;
        String restPath = "/" + CommonsUtils.getRestContextName() + baseDavPath;
        String downloadLink = "/" + CommonsUtils.getRestContextName() + "/contents/download/" + nodePathWithWorkspace;
        String filename = this.getFileName(uploadResource);
        JSONObject response = new JSONObject();
        response.put((Object)"status", (Object)"ok");
        response.put((Object)"name", (Object)node.getName());
        response.put((Object)"title", (Object)filename);
        response.put((Object)"size", (Object)uploadResource.getUploadedSize());
        response.put((Object)"owner", (Object)remoteUser);
        response.put((Object)"uuid", (Object)node.getUUID());
        response.put((Object)"path", (Object)node.getPath());
        response.put((Object)"createdDate", (Object)node.getNode("jcr:content").getProperty("jcr:lastModified").getString());
        response.put((Object)"publicUrl", (Object)publicURL);
        response.put((Object)"thumbnailUrl", (Object)restPath);
        response.put((Object)"restPath", (Object)restPath);
        response.put((Object)"downloadLink", (Object)downloadLink);
        response.put((Object)"thumbnailURL", (Object)thumbnailURL);
        response.put((Object)"sizeLabel", (Object)this.calculateFileSize((long)uploadResource.getUploadedSize()));
        return Response.ok((Object)response.toJSONString(), (String)"application/json").build();
    }

    public int getUploadLimitInMB() {
        return this.uploadLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node storeFile(UploadResource uploadResource, String remoteUser, String room, String roomFullName, List<String> usernames) {
        String filename;
        String title = filename = this.getFileName(uploadResource);
        filename = Text.escapeIllegalJcrChars((String)filename);
        boolean isPrivateContext = !room.startsWith("space-");
        SessionProvider sessionProvider = this.sessionProviderService_.getSessionProvider(null);
        Node node = null;
        try {
            Node homeNode;
            if (isPrivateContext) {
                Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, remoteUser);
                homeNode = userNode.getNode("Private");
            } else {
                ManageableRepository currentRepository = this.repositoryService_.getCurrentRepository();
                String workspaceName = currentRepository.getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(workspaceName, currentRepository);
                Space space = this.spaceService_.getSpaceByDisplayName(roomFullName);
                String groupPath = this.nodeHierarchyCreator_.getJcrPath("groupsPath");
                String spaceParentPath = groupPath + space.getGroupId();
                if (!session.itemExists(spaceParentPath)) {
                    throw new IllegalStateException("Root node of space '" + spaceParentPath + "' doesn't exist");
                }
                homeNode = (Node)session.getItem(spaceParentPath);
            }
            Node docNode = homeNode.getNode("Documents");
            int suffix = 1;
            while (docNode.hasNode(filename)) {
                filename = filename.contains(".") ? filename.replace(".", "-" + suffix + ".") : filename + "-" + suffix;
                ++suffix;
            }
            node = docNode.addNode(filename, "nt:file");
            node.setProperty("exo:title", title);
            this.activityService_.setCreating(node, true);
            Node resourceNode = node.addNode("jcr:content", "nt:resource");
            resourceNode.setProperty("jcr:mimeType", uploadResource.getMimeType());
            resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
            String fileDiskLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(fileDiskLocation);
                resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                docNode.save();
                node = docNode.getSession().getNodeByUUID(node.getUUID());
            }
            if (!usernames.isEmpty()) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                for (String user : usernames) {
                    ((NodeImpl)node).setPermission(user, new String[]{"read"});
                }
                node.save();
            }
            this.activityService_.setCreating(node, false);
            if (!isPrivateContext) {
                this.listenerService_.broadcast(FILE_CREATED_ACTIVITY, null, (Object)node);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while persisting file in JCR", (Throwable)e);
        }
        return node;
    }

    private String getFileName(UploadResource uploadResource) {
        String filename = uploadResource.getFileName();
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            LOG.warn((Object)("An error occurred while decoding file " + filename), (Throwable)e1);
        }
        return filename;
    }

    private String calculateFileSize(long fileLengthLong) {
        int fileLengthDigitCount = Long.toString(fileLengthLong).length();
        double fileSizeKB = 0.0;
        String howBig = "";
        if (fileLengthDigitCount < 4) {
            fileSizeKB = fileLengthLong;
            howBig = "Byte(s)";
        } else if (fileLengthDigitCount >= 4 && fileLengthDigitCount <= 6) {
            fileSizeKB = new Double(fileLengthLong) / 1024.0;
            howBig = "KB";
        } else if (fileLengthDigitCount >= 7 && fileLengthDigitCount <= 9) {
            fileSizeKB = new Double(fileLengthLong) / 1048576.0;
            howBig = "MB";
        } else if (fileLengthDigitCount > 9) {
            fileSizeKB = new Double(fileLengthLong) / 1.073741824E9;
            howBig = "GB";
        }
        String finalResult = this.roundTwoDecimals(fileSizeKB);
        return finalResult + " " + howBig;
    }

    private String roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return twoDForm.format(d);
    }

    private List<String> getUsernamesFromJSON(String users) throws JSONException {
        JSONArray usersArray;
        org.json.JSONObject usersObject;
        ArrayList<String> usernames = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)users) && (usersObject = new org.json.JSONObject(users)).has("users") && (usersArray = (JSONArray)usersObject.get("users")) != null && usersArray.length() > 0) {
            for (int i = 0; i < usersArray.length(); ++i) {
                org.json.JSONObject user = usersArray.getJSONObject(i);
                if (user == null || !StringUtils.isNotBlank((String)user.getString("name"))) continue;
                usernames.add(user.getString("name"));
            }
        }
        return usernames;
    }
}

