/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.notification.builder;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.chat.utils.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ChatTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(ChatTemplateBuilder.class);
    private TemplateProvider templateProvider;
    private ExoContainer container;
    private boolean isPushNotification;
    private PluginKey key;

    public ChatTemplateBuilder(TemplateProvider templateProvider, ExoContainer container, PluginKey key, boolean pushNotification) {
        this.templateProvider = templateProvider;
        this.container = container;
        this.isPushNotification = pushNotification;
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            TemplateContext templateContext = NotificationUtils.buildTemplateParameters(this.templateProvider, notification);
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            MessageInfo messageInfo2 = messageInfo.subject(subject).body(body).end();
            return messageInfo2;
        }
        catch (Throwable e) {
            ctx.setException(e);
            this.logException(notification, e);
            MessageInfo messageInfo = null;
            return messageInfo;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
        return false;
    }

    private void logException(NotificationInfo notification, Throwable e) {
        if (e != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Error building notification content: {}", new Object[]{notification, e});
            } else {
                LOG.warn("Error building notification content: {}, error: {}", new Object[]{notification, e.getMessage()});
            }
        }
    }

    public Template getTemplateEngine() {
        String templatePath = null;
        try {
            templatePath = (String)this.templateProvider.getTemplateFilePathConfigs().get(this.key);
            String template = TemplateUtils.loadGroovyTemplate((String)templatePath);
            if (StringUtils.isBlank((String)template)) {
                throw new IllegalStateException("Template with path " + templatePath + " wasn't found");
            }
            return new GStringTemplateEngine().createTemplate(template);
        }
        catch (Exception e) {
            LOG.warn("Error while compiling template {}", new Object[]{templatePath, e});
            try {
                return new GStringTemplateEngine().createTemplate("");
            }
            catch (Exception e1) {
                return null;
            }
        }
    }
}

