/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import juzu.impl.common.CompositeReader;

public class NormalizeJSReader
extends Reader {
    private boolean finished = false;
    private boolean multiComments = false;
    private boolean singleComment = false;
    private Reader sub;

    public NormalizeJSReader(Reader sub) {
        this.sub = sub;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.finished) {
            return this.sub.read(cbuf, off, len);
        }
        char[] buffer = new char[len];
        int relLen = this.sub.read(buffer, 0, len);
        if (relLen == -1) {
            this.finished = true;
            return -1;
        }
        int r = off;
        for (int i = 0; i < relLen; ++i) {
            boolean overflow;
            char c = buffer[i];
            char next = '\u0000';
            boolean skip = false;
            boolean bl = overflow = i + 1 == relLen;
            if (!this.finished) {
                skip = true;
                if (!this.singleComment && c == '/' && (next = this.readNext(buffer, i, overflow)) == '*') {
                    this.multiComments = true;
                    ++i;
                } else if (!this.singleComment && c == '*' && (next = this.readNext(buffer, i, overflow)) == '/') {
                    this.multiComments = false;
                    ++i;
                } else if (!this.multiComments && c == '/' && next == '/') {
                    this.singleComment = true;
                    ++i;
                } else if (c == '\n') {
                    this.singleComment = false;
                } else if (c != ' ') {
                    skip = false;
                }
                if (skip || this.multiComments || this.singleComment) continue;
                if (next != '\u0000' && overflow) {
                    this.sub = new CompositeReader(new StringReader(String.valueOf(c)), this.sub);
                }
                cbuf[r++] = c;
                this.finished = true;
                continue;
            }
            cbuf[r++] = c;
        }
        return r - off;
    }

    private char readNext(char[] buffer, int i, boolean overflow) throws IOException {
        char c = '\u0000';
        if (overflow) {
            int tmp = this.sub.read();
            if (tmp != -1) {
                c = (char)tmp;
            }
        } else {
            c = buffer[i + 1];
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        this.sub.close();
    }
}

