/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import juzu.impl.common.Tools;

public class LiveClassLoader
extends URLClassLoader {
    private final ClassLoader parent;

    public LiveClassLoader(URL[] urls, ClassLoader parent) throws NullPointerException {
        super(urls, parent);
        if (parent == null) {
            throw new NullPointerException("No null parent classloader accpeted");
        }
        this.parent = parent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.findClass(name);
            }
            if (this.loadLocally(clazz)) {
                clazz = this.findClass(name);
            }
            return clazz;
        }
        return clazz;
    }

    private boolean loadLocally(Class<?> clazz) {
        return this.loadLocally(new LinkedList(), clazz);
    }

    private boolean loadLocally(LinkedList<Class<?>> stack, Class<?> clazz) {
        if (clazz.getClassLoader() == this) {
            throw new UnsupportedOperationException("Attempt to determine loading of " + clazz.getName());
        }
        if (clazz.getClassLoader() == this.parent) {
            if (stack.contains(clazz)) {
                return false;
            }
            stack.add(clazz);
            try {
                block15: {
                    String resourceName = clazz.getName().replace('.', '/') + ".class";
                    URL resource = this.findResource(resourceName);
                    if (resource == null) {
                        boolean bl = false;
                        return bl;
                    }
                    URL parentResource = this.parent.getResource(resourceName);
                    if (parentResource == null) {
                        throw new UnsupportedOperationException("Could not find parent resource " + resourceName + " from parent loader");
                    }
                    try {
                        byte[] parentBytes = Tools.bytes(parentResource);
                        byte[] bytes = Tools.bytes(resource);
                        if (!Arrays.equals(parentBytes, bytes)) break block15;
                        Iterator<Class<?>> dependencies = this.getDirectDependencies(clazz);
                        while (dependencies.hasNext()) {
                            Class<?> dependency = dependencies.next();
                            if (!this.loadLocally(stack, dependency)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        stack.add(clazz);
                    }
                    catch (IOException e) {
                        throw new UnsupportedOperationException("handle me gracefully", e);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                stack.remove(clazz);
            }
        }
        return false;
    }

    private Iterator<Class<?>> getDirectDependencies(Class<?> type) {
        HashSet dependencies = new HashSet();
        this.resolveDirectDependencies(type, dependencies);
        return dependencies.iterator();
    }

    /*
     * WARNING - void declaration
     */
    private void resolveDirectDependencies(Class<?> clazz, HashSet<Class<?>> dependencies) {
        void var6_13;
        for (Field field : clazz.getDeclaredFields()) {
            this.resolveGenericDirectDependencies(field.getGenericType(), dependencies);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
            for (Type genericParameterType : ((Constructor)accessibleObject).getGenericParameterTypes()) {
                this.resolveGenericDirectDependencies(genericParameterType, dependencies);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            this.resolveGenericDirectDependencies(((Method)accessibleObject).getGenericReturnType(), dependencies);
            for (Type genericParameterType : ((Method)accessibleObject).getGenericParameterTypes()) {
                this.resolveGenericDirectDependencies(genericParameterType, dependencies);
            }
        }
        Type genericSuperClass = clazz.getGenericSuperclass();
        if (genericSuperClass != null) {
            this.resolveGenericDirectDependencies(genericSuperClass, dependencies);
        }
        Type[] arr$ = clazz.getGenericInterfaces();
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_13 < len$) {
            Type genericInterface = arr$[var6_13];
            this.resolveGenericDirectDependencies(genericInterface, dependencies);
            ++var6_13;
        }
    }

    private void resolveGenericDirectDependencies(Type type, HashSet<Class<?>> dependencies) {
        if (type instanceof Class) {
            dependencies.add((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type typeArg : parameterizedType.getActualTypeArguments()) {
                this.resolveGenericDirectDependencies(typeArg, dependencies);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type upperBound : wildcardType.getUpperBounds()) {
                this.resolveGenericDirectDependencies(upperBound, dependencies);
            }
            for (Type lowerBound : wildcardType.getLowerBounds()) {
                this.resolveGenericDirectDependencies(lowerBound, dependencies);
            }
        } else {
            throw new UnsupportedOperationException("Type " + type + " not yet supported");
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }
}

