/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.impl.template.PathLiteral;
import juzu.template.Template;

public class TemplatesDescriptor
extends ServiceDescriptor {
    private final List<TemplateDescriptor> templates;
    final Name pkg;
    private final ArrayList<BeanDescriptor> beans;

    public TemplatesDescriptor(ApplicationDescriptor application, ClassLoader loader, JSON config) throws Exception {
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        ArrayList<TemplateDescriptor> templates = new ArrayList<TemplateDescriptor>();
        String packageName = config.getString("package");
        Name pkg = Name.parse(packageName);
        for (String fqn : config.getList("templates", String.class)) {
            PathLiteral qualifier;
            Class<?> clazz = loader.loadClass(fqn);
            Field f = clazz.getField("DESCRIPTOR");
            TemplateDescriptor descriptor = (TemplateDescriptor)f.get(null);
            templates.add(descriptor);
            Path.Absolute path = (Path.Absolute)Path.parse(descriptor.getPath());
            if (pkg.isPrefix(path.getName())) {
                Path.Relative relativePath = Path.relative(path.getName().subName(pkg.size()), path.getExt());
                qualifier = new PathLiteral(relativePath.getCanonical());
            } else {
                qualifier = new PathLiteral(path.getCanonical());
            }
            beans.add(BeanDescriptor.createFromImpl(Template.class, null, Arrays.asList(qualifier), descriptor.getType()));
        }
        this.templates = templates;
        this.pkg = pkg;
        this.beans = beans;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        return this.beans;
    }

    public List<TemplateDescriptor> getTemplates() {
        return this.templates;
    }

    public Name getPackage() {
        return this.pkg;
    }

    public TemplateDescriptor getTemplate(String path) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        for (TemplateDescriptor template : this.templates) {
            if (!template.getPath().equals(path)) continue;
            return template;
        }
        return null;
    }
}

