/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.less.impl.lesser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import juzu.plugin.less.impl.lesser.Compilation;
import juzu.plugin.less.impl.lesser.Failure;
import juzu.plugin.less.impl.lesser.JSContext;
import juzu.plugin.less.impl.lesser.LessContext;
import juzu.plugin.less.impl.lesser.LessError;
import juzu.plugin.less.impl.lesser.Result;

public class Lesser {
    private static final ThreadLocal<LessContext> current = new ThreadLocal();
    private static final ThreadLocal<Result> currentResult = new ThreadLocal();
    private final JSContext engine;

    public Lesser(JSContext jsContext) throws Exception {
        InputStream lessIn = this.getClass().getResourceAsStream("less.js");
        ByteArrayOutputStream baos = Lesser.append(lessIn, new ByteArrayOutputStream());
        jsContext.put("bridge", new Bridge());
        jsContext.eval("load = function(name) { return '' + bridge.load(name); }");
        jsContext.eval("failure = function(src, line, column, index, message, type, extract) { bridge.failure(src, line, column, index, message, type, extract); }");
        jsContext.eval("compilation = function(stylesheet) { bridge.compilation(stylesheet); }");
        jsContext.put("window", "{}");
        jsContext.eval(baos.toString());
        this.engine = jsContext;
    }

    public Result compile(LessContext context, String name) throws Exception {
        return this.compile(context, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(LessContext context, String name, boolean compress) throws Exception {
        current.set(context);
        try {
            this.engine.invokeFunction("parse", name, compress);
            Result result = currentResult.get();
            return result;
        }
        finally {
            current.set(null);
            currentResult.set(null);
        }
    }

    static <O extends OutputStream> O append(InputStream in, O out) throws IOException {
        byte[] buffer = new byte[256];
        int l = in.read(buffer);
        while (l != -1) {
            out.write(buffer, 0, l);
            l = in.read(buffer);
        }
        return out;
    }

    public class Bridge {
        public String load(String name) {
            return ((LessContext)current.get()).load(name);
        }

        public void failure(String src, int line, int column, int index, String message, String type, String[] extract) {
            Failure failure = (Failure)currentResult.get();
            if (failure == null) {
                failure = new Failure();
                currentResult.set(failure);
            }
            failure.errors.add(new LessError(src, line, column, index, message, type, extract));
        }

        public void compilation(String result) {
            currentResult.set(new Compilation(result));
        }
    }
}

