/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.location;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;

public class ConstraintLocation {
    private final Member member;
    private final Class<?> declaringClass;
    private final Type typeForValidatorResolution;

    public static ConstraintLocation forClass(Class<?> declaringClass) {
        Class<?> type = declaringClass.getTypeParameters().length == 0 ? declaringClass : TypeHelper.parameterizedType(declaringClass, declaringClass.getTypeParameters());
        return new ConstraintLocation(declaringClass, null, type);
    }

    public static ConstraintLocation forProperty(Member member) {
        return new ConstraintLocation(member.getDeclaringClass(), member, ReflectionHelper.typeOf(member));
    }

    public static ConstraintLocation forReturnValue(ExecutableElement executable) {
        return new ConstraintLocation(executable.getMember().getDeclaringClass(), executable.getMember(), ReflectionHelper.typeOf(executable.getMember()));
    }

    public static ConstraintLocation forCrossParameter(ExecutableElement executable) {
        return new ConstraintLocation(executable.getMember().getDeclaringClass(), executable.getMember(), (Type)((Object)Object[].class));
    }

    public static ConstraintLocation forParameter(ExecutableElement executable, int index) {
        return new ConstraintLocation(executable.getMember().getDeclaringClass(), executable.getMember(), ReflectionHelper.typeOf(executable, index));
    }

    private ConstraintLocation(Class<?> declaringClass, Member member, Type typeOfAnnotatedElement) {
        this.declaringClass = declaringClass;
        this.member = member;
        this.typeForValidatorResolution = typeOfAnnotatedElement instanceof Class && ((Class)typeOfAnnotatedElement).isPrimitive() ? ReflectionHelper.boxedType((Class)typeOfAnnotatedElement) : typeOfAnnotatedElement;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Member getMember() {
        return this.member;
    }

    public Type getTypeForValidatorResolution() {
        return this.typeForValidatorResolution;
    }

    public String toString() {
        return "ConstraintLocation [member=" + this.member + ", declaringClass=" + this.declaringClass + ", typeForValidatorResolution=" + this.typeForValidatorResolution + "]";
    }
}

