/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.spring.SpringInjector;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

abstract class AbstractBean {
    final Class<?> type;
    final List<AutowireCandidateQualifier> qualifiers;
    final String name;

    AbstractBean(Class<?> type, Iterable<Annotation> qualifiers) {
        String name = null;
        ArrayList<AutowireCandidateQualifier> list = null;
        if (qualifiers != null) {
            list = new ArrayList<AutowireCandidateQualifier>();
            for (Annotation annotation : qualifiers) {
                if (annotation instanceof Named) {
                    name = ((Named)annotation).value();
                }
                Class<? extends Annotation> annotationType = annotation.annotationType();
                AutowireCandidateQualifier md = new AutowireCandidateQualifier(annotationType.getName());
                for (Method method : annotationType.getMethods()) {
                    if (method.getParameterTypes().length != 0 || method.getDeclaringClass() == Object.class) continue;
                    try {
                        String attrName = method.getName();
                        Object attrValue = method.invoke((Object)annotation, new Object[0]);
                        md.addMetadataAttribute(new BeanMetadataAttribute(attrName, attrValue));
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException("handle me gracefully", e);
                    }
                }
                list.add(md);
            }
        }
        if (name == null) {
            name = Tools.nextUUID();
        }
        this.type = type;
        this.qualifiers = list;
        this.name = name;
    }

    abstract void configure(String var1, SpringInjector var2, DefaultListableBeanFactory var3);
}

