/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import juzu.impl.common.AbstractParameterParser;
import juzu.impl.common.Name;
import juzu.impl.common.PercentCodec;
import juzu.impl.common.Tools;
import juzu.request.RequestParameter;

public class Lexers {
    static final Pattern NAME_VALIDATOR = Pattern.compile("(?!\\.)[^/]+(?<!\\.)");
    static final int PARSE_CANONICAL = 0;
    static final int PARSE_ANY = 1;

    public static String[] parsePath(int mode, String[] base, int padding, String path, int off) throws IllegalArgumentException {
        return Lexers.parsePath(mode, base, padding, path, off, 0);
    }

    private static String[] parsePath(int mode, String[] base, int padding, String path, int off, int size) throws IllegalArgumentException {
        int len = path.length();
        int at = padding + size;
        if (off < len) {
            int pos = path.indexOf(47, off);
            if (pos == -1) {
                String name = path.substring(off);
                if (!NAME_VALIDATOR.matcher(name).matches()) {
                    throw new IllegalArgumentException("The name " + name + " is not valid");
                }
                int cur = name.indexOf(46);
                String[] ret = new String[padding + size + 2];
                System.arraycopy(base, 0, ret, 0, padding);
                if (cur == 0) {
                    throw new UnsupportedOperationException("Handle me gracefully");
                }
                if (cur == -1) {
                    ret[at] = name;
                    return ret;
                }
                ret[at] = name.substring(0, cur);
                ret[at + 1] = name.substring(cur + 1);
                return ret;
            }
            int diff = pos - off;
            if (diff == 0) {
                return Lexers.parsePath(mode, base, padding, path, off + 1, size);
            }
            if (diff == 1 && path.charAt(off) == '.') {
                switch (mode) {
                    case 0: {
                        throw new IllegalArgumentException("No '.' allowed here");
                    }
                    case 1: {
                        return Lexers.parsePath(mode, base, padding, path, off + 2, size);
                    }
                }
                throw new AssertionError((Object)"Should not be here");
            }
            if (diff == 2 && path.charAt(off) == '.' && path.charAt(off + 1) == '.') {
                switch (mode) {
                    case 0: {
                        throw new IllegalArgumentException("No '..' allowed here");
                    }
                    case 1: {
                        if (size > 0) {
                            return Lexers.parsePath(mode, base, padding, path, off + 3, size - 1);
                        }
                        if (padding > 0) {
                            return Lexers.parsePath(mode, base, padding - 1, path, off + 3, size);
                        }
                        throw new IllegalArgumentException("Invalid path");
                    }
                }
                throw new AssertionError((Object)"Should not be here");
            }
            for (int i = off; i < pos; ++i) {
                if (path.charAt(i) != '.') continue;
                throw new IllegalArgumentException("No '.' allowed here");
            }
            String[] ret = Lexers.parsePath(mode, base, padding, path, pos + 1, size + 1);
            if (ret[at] == null) {
                ret[at] = path.substring(off, pos);
            }
            return ret;
        }
        String[] ret = new String[padding + size + 2];
        System.arraycopy(base, 0, ret, 0, padding);
        ret[at] = "";
        return ret;
    }

    public static String[] parseName(CharSequence s, int from, int end) throws IllegalArgumentException {
        if (from < 0) {
            throw new IllegalArgumentException("From bound " + from + " cannot be negative");
        }
        if (from > end) {
            throw new IllegalArgumentException("From bound " + from + " cannot be greater than the end bound " + end);
        }
        if (from == end) {
            return Name.EMPTY_STRING_ARRAY;
        }
        return Lexers.parseName(0, s, from, end);
    }

    private static String[] parseName(int size, CharSequence s, int from, int end) {
        String[] identifiers;
        int next = Tools.indexOf(s, '.', from, end);
        if (next < 0) {
            if (from == end) {
                throw new IllegalArgumentException("Empty segment");
            }
            identifiers = new String[size + 1];
            identifiers[size] = s.subSequence(from, end).toString();
        } else {
            if (next == from) {
                throw new IllegalArgumentException("Empty segment");
            }
            identifiers = Lexers.parseName(size + 1, s, next + 1, end);
            identifiers[size] = s.subSequence(from, next).toString();
        }
        return identifiers;
    }

    public static Map<String, RequestParameter> parseQuery(String s) {
        return Lexers.parseQuery(s, 0, s.length());
    }

    public static Map<String, RequestParameter> parseQuery(CharSequence s, int from, int to) {
        Map<String, RequestParameter> parameters = Collections.emptyMap();
        Iterator<RequestParameter> parser = Lexers.queryParser(s, from, to);
        while (parser.hasNext()) {
            RequestParameter parameter;
            RequestParameter current = parser.next();
            if (parameters.isEmpty()) {
                parameters = new HashMap<String, RequestParameter>();
            }
            if ((parameter = parameters.get(current.getName())) != null) {
                current = parameter.append(current);
            }
            parameters.put(current.getName(), current);
        }
        return parameters;
    }

    public static Iterator<RequestParameter> queryParser(CharSequence s) {
        return Lexers.queryParser(s, 0, s.length());
    }

    public static Iterator<RequestParameter> queryParser(CharSequence s, int from, int to) {
        return new AbstractParameterParser(s, from, to){

            @Override
            protected String safeDecodeName(String s) {
                return PercentCodec.RFC3986_QUERY_PARAM_NAME.safeDecode(s);
            }

            @Override
            protected String safeDecodeValue(String s) {
                return PercentCodec.RFC3986_QUERY_PARAM_VALUE.safeDecode(s);
            }
        }.iterator();
    }
}

