/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.cometd.annotation.Listener;
import org.cometd.annotation.Service;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Service
public class CometdService {
    private static final Logger LOG = Logger.getLogger(CometdService.class.getName());
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
    RealTimeMessageService realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);

    @Listener(value={"/service/chat"})
    public void onMessageReceived(ServerSession remoteSession, ServerMessage message) {
        block19: {
            LOG.log(Level.FINE, "Cometd message received on {0} : {1}", new Object[]{"/service/chat", message.getJSON()});
            try {
                JSONParser jsonParser = new JSONParser();
                JSONObject jsonMessage = (JSONObject)jsonParser.parse((String)message.getData());
                String sender = (String)jsonMessage.get((Object)"sender");
                String token = (String)jsonMessage.get((Object)"token");
                String dbName = (String)jsonMessage.get((Object)"dbName");
                if (!this.tokenService.hasUserWithToken(sender, token, dbName)) {
                    return;
                }
                RealTimeMessageBean.EventType eventType = RealTimeMessageBean.EventType.get((String)((String)jsonMessage.get((Object)"event")));
                ChatService chatService = (ChatService)GuiceManager.getInstance().getInstance(ChatService.class);
                if (eventType.equals((Object)RealTimeMessageBean.EventType.USER_STATUS_CHANGED)) {
                    RealTimeMessageBean realTimeMessageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.USER_STATUS_CHANGED, (String)jsonMessage.get((Object)"room"), (String)jsonMessage.get((Object)"sender"), new Date(), (Map)jsonMessage.get((Object)"data"));
                    this.realTimeMessageService.sendMessageToAll(realTimeMessageBean);
                    this.userService.setStatus((String)jsonMessage.get((Object)"sender"), (String)((JSONObject)jsonMessage.get((Object)"data")).get((Object)"status"), (String)jsonMessage.get((Object)"dbName"));
                    break block19;
                }
                if (eventType.equals((Object)RealTimeMessageBean.EventType.MESSAGE_READ)) {
                    String room = (String)jsonMessage.get((Object)"room");
                    String category = "room";
                    if (StringUtils.isBlank((CharSequence)room)) {
                        room = null;
                        category = null;
                    }
                    this.notificationService.setNotificationsAsRead(sender, "chat", category, room, dbName);
                    if (this.userService.isAdmin(sender, dbName)) {
                        this.notificationService.setNotificationsAsRead("__support_", "chat", category, room, dbName);
                    }
                    RealTimeMessageBean realTimeMessageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.MESSAGE_READ, room, sender, new Date(), null);
                    this.realTimeMessageService.sendMessage(realTimeMessageBean, sender);
                    break block19;
                }
                if (eventType.equals((Object)RealTimeMessageBean.EventType.MESSAGE_SENT)) {
                    JSONObject data = (JSONObject)jsonMessage.get((Object)"data");
                    String room = data.get((Object)"room").toString();
                    String clientId = data.get((Object)"clientId").toString();
                    String msg = data.get((Object)"msg") != null ? data.get((Object)"msg").toString() : "";
                    String isSystem = data.get((Object)"isSystem") == null ? "false" : data.get((Object)"isSystem").toString();
                    String options2 = data.get((Object)"options") != null ? data.get((Object)"options").toString() : null;
                    try {
                        chatService.write(clientId, msg, sender, room, isSystem, options2, dbName);
                    }
                    catch (ChatException chatException) {}
                    break block19;
                }
                if (eventType.equals((Object)RealTimeMessageBean.EventType.MESSAGE_UPDATED)) {
                    String messageId;
                    String room = jsonMessage.get((Object)"room").toString();
                    MessageBean currentMessage = chatService.getMessage(room, messageId = ((JSONObject)jsonMessage.get((Object)"data")).get((Object)"msgId").toString(), dbName);
                    if (currentMessage == null || !currentMessage.getUser().equals(sender)) {
                        return;
                    }
                    String msg = ((JSONObject)jsonMessage.get((Object)"data")).get((Object)"msg").toString();
                    chatService.edit(room, sender, messageId, msg, dbName);
                    break block19;
                }
                if (eventType.equals((Object)RealTimeMessageBean.EventType.MESSAGE_DELETED)) {
                    String messageId;
                    String room = jsonMessage.get((Object)"room").toString();
                    MessageBean currentMessage = chatService.getMessage(room, messageId = ((JSONObject)jsonMessage.get((Object)"data")).get((Object)"msgId").toString(), dbName);
                    if (currentMessage == null || !currentMessage.getUser().equals(sender)) {
                        return;
                    }
                    chatService.delete(room, sender, messageId, dbName);
                    break block19;
                }
                if (eventType.equals((Object)RealTimeMessageBean.EventType.ROOM_DELETED)) {
                    String room = jsonMessage.get((Object)"room").toString();
                    chatService.deleteTeamRoom(room, sender, dbName);
                    break block19;
                }
                if (!eventType.equals((Object)RealTimeMessageBean.EventType.ROOM_MEMBER_LEAVE_REQUESTED)) break block19;
                String room = jsonMessage.get((Object)"room").toString();
                String clientId = jsonMessage.get((Object)"clientId").toString();
                String msg = "";
                String isSystem = "true";
                JSONObject options = jsonMessage.get((Object)"options") != null ? (JSONObject)jsonMessage.get((Object)"options") : new JSONObject();
                options.put((Object)"type", (Object)RealTimeMessageBean.EventType.ROOM_MEMBER_LEFT.toString());
                try {
                    chatService.write(clientId, msg, sender, room, isSystem, options.toString(), dbName);
                }
                catch (ChatException options2) {
                    // empty catch block
                }
                this.userService.removeTeamUsers(room, Collections.singletonList(sender), dbName);
                List<String> usersToBeNotified = this.userService.getUsersFilterBy(sender, room, "team-", dbName);
                if (usersToBeNotified == null) {
                    usersToBeNotified = Collections.singletonList(sender);
                } else {
                    usersToBeNotified.add(sender);
                }
                RealTimeMessageBean leaveRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_MEMBER_LEFT, room, sender, new Date(), (Map)options);
                this.realTimeMessageService.sendMessage(leaveRoomMessage, usersToBeNotified);
                this.notificationService.setNotificationsAsRead(sender, "chat", "room", room, dbName);
            }
            catch (ParseException e) {
                LOG.log(Level.SEVERE, "Error while processing Cometd message : " + e.getMessage(), e);
            }
        }
    }
}

