/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.services.UserService;
import org.json.JSONException;
import org.json.simple.JSONObject;

@Named(value="userService")
@ApplicationScoped
@Singleton
public class UserServiceImpl
implements UserService {
    private static final Logger LOG = Logger.getLogger(UserServiceImpl.class.getName());
    @Inject
    private UserDataStorage userStorage;
    @Inject
    private RealTimeMessageService realTimeMessageService;

    public void toggleFavorite(String user, String targetUser, String dbName) {
        if (this.isFavorite(user, targetUser, dbName)) {
            this.removeFavorite(user, targetUser, dbName);
        } else {
            this.addFavorite(user, targetUser, dbName);
        }
    }

    public void addFavorite(String user, String room, String dbname) {
        this.userStorage.addFavorite(user, room, dbname);
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.FAVORITE_ADDED, room, user, new Date(), null);
        this.realTimeMessageService.sendMessage(messageBean, user);
    }

    public void removeFavorite(String user, String room, String dbName) {
        this.userStorage.removeFavorite(user, room, dbName);
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.FAVORITE_REMOVED, room, user, new Date(), null);
        this.realTimeMessageService.sendMessage(messageBean, user);
    }

    public void setPreferredNotification(String user, String notifManner, String dbName) throws Exception {
        this.userStorage.setPreferredNotification(user, notifManner, dbName);
    }

    public void setNotificationTrigger(String user, String notifCond, String dbName) throws Exception {
        this.userStorage.setNotificationTrigger(user, notifCond, dbName);
    }

    public void setRoomNotificationTrigger(String user, String room, String notifCondition, String notifConditionType, String dbName, long time) throws Exception {
        this.userStorage.setRoomNotificationTrigger(user, room, notifCondition, notifConditionType, dbName, time);
    }

    public NotificationSettingsBean getUserDesktopNotificationSettings(String user, String dbName) throws JSONException {
        return this.userStorage.getUserDesktopNotificationSettings(user, dbName);
    }

    public boolean isFavorite(String user, String targetUser, String dbName) {
        return this.userStorage.isFavorite(user, targetUser, dbName);
    }

    public void addUserFullName(String user, String fullname, String dbName) {
        this.userStorage.addUserFullName(user, fullname, dbName);
    }

    public void addUserEmail(String user, String email, String dbName) {
        this.userStorage.addUserEmail(user, email, dbName);
    }

    public void setSpaces(String user, List<SpaceBean> spaces, String dbName) {
        this.userStorage.setSpaces(user, spaces, dbName);
    }

    public void addTeamRoom(String user, String teamRoomId, String dbName) {
        this.userStorage.addTeamRoom(user, teamRoomId, dbName);
        JSONObject data = this.getRoom(user, teamRoomId, dbName).toJSONObject();
        RealTimeMessageBean joinRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_MEMBER_JOIN, teamRoomId, user, new Date(), (Map)data);
        this.realTimeMessageService.sendMessage(joinRoomMessage, user);
    }

    public void addTeamUsers(String teamRoomId, List<String> users, String dbName) {
        for (String user : users) {
            this.addTeamRoom(user, teamRoomId, dbName);
        }
    }

    public void removeTeamUsers(String teamRoomId, List<String> users, String dbName) {
        this.userStorage.removeTeamUsers(teamRoomId, users, dbName);
    }

    public List<RoomBean> getTeams(String user, String dbName) {
        return this.userStorage.getTeams(user, dbName);
    }

    public RoomBean getRoom(String user, String roomId, String dbName) {
        return this.userStorage.getRoom(user, roomId, dbName);
    }

    public List<SpaceBean> getSpaces(String user, String dbName) {
        return this.userStorage.getSpaces(user, dbName);
    }

    public List<UserBean> getUsersInRoomChatOneToOne(String roomId, String dbName) {
        return this.userStorage.getUsersInRoomChatOneToOne(roomId, dbName);
    }

    public List<UserBean> getUsers(String roomId, String dbName) {
        return this.userStorage.getUsers(roomId, null, 0, dbName);
    }

    public List<UserBean> getUsers(String filter, boolean fullBean, String dbName) {
        return this.userStorage.getUsers(null, filter, 0, dbName);
    }

    public List<UserBean> getUsers(String roomId, String filter, int limit, String dbName) {
        return this.userStorage.getUsers(roomId, filter, limit, dbName);
    }

    public String setStatus(String user, String status, String dbName) {
        return this.userStorage.setStatus(user, status, dbName);
    }

    public void setAsAdmin(String user, boolean isAdmin, String dbName) {
        this.userStorage.setAsAdmin(user, isAdmin, dbName);
    }

    public boolean isAdmin(String user, String dbName) {
        return this.userStorage.isAdmin(user, dbName);
    }

    public String getStatus(String user, String dbName) {
        return this.userStorage.getStatus(user, dbName);
    }

    public String getUserFullName(String user, String dbName) {
        return this.userStorage.getUserFullName(user, dbName);
    }

    public UserBean getUser(String user, String dbName) {
        return this.getUser(user, false, dbName);
    }

    public UserBean getUser(String user, boolean withFavorites, String dbName) {
        return this.userStorage.getUser(user, withFavorites, dbName);
    }

    public List<String> getUsersFilterBy(String user, String room, String type, String dbName) {
        return this.userStorage.getUsersFilterBy(user, room, type, dbName);
    }

    public int getNumberOfUsers(String dbName) {
        return this.userStorage.getNumberOfUsers(dbName);
    }
}

