/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatDataStorage;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Named(value="chatStorage")
@ApplicationScoped
@Singleton
public class ChatMongoDataStorage
implements ChatDataStorage {
    private static final Logger LOG = Logger.getLogger("ChatMongoDataStorage");
    public static final String M_ROOM_PREFIX = "messages_room_";
    public static final String M_ROOMS_COLLECTION = "rooms";
    private int readTotalJson;
    private int readTotalTxt;
    @Inject
    private UserDataStorage userDataStorage;
    private SimpleDateFormat formatterDate = new SimpleDateFormat("dd/MM/yyyy hh:mm aaa");

    public ChatMongoDataStorage() {
        this.readTotalJson = Integer.parseInt(PropertyManager.getProperty((String)"chatReadTotalJson"));
        this.readTotalTxt = Integer.parseInt(PropertyManager.getProperty((String)"chatReadTotalTxt"));
    }

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public void write(String message, String user, String room, String isSystem) {
        this.write(message, user, room, isSystem, null);
    }

    @Override
    public void write(String message, String user, String room, String isSystem, String options) {
        this.save(message, user, room, isSystem, options);
    }

    @Override
    public String save(String message, String user, String room, String isSystem, String options) {
        String roomType = this.getTypeRoomChat(room);
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        message = message.replaceAll("\t", "  ");
        BasicDBObject doc = new BasicDBObject();
        doc.put((Object)"user", (Object)user);
        doc.put((Object)"message", (Object)message);
        doc.put((Object)"timestamp", (Object)System.currentTimeMillis());
        doc.put((Object)"isSystem", (Object)isSystem);
        doc.put((Object)"roomId", (Object)room);
        if (options != null) {
            options = options.replaceAll("<", "&lt;");
            options = options.replaceAll(">", "&gt;");
            doc.put((Object)"options", (Object)options);
        }
        coll.insert(new DBObject[]{doc});
        this.updateRoomTimestamp(room);
        return doc.get("_id").toString();
    }

    @Override
    public void delete(String room, String user, String messageId) {
        String roomType = this.getTypeRoomChat(room);
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(messageId));
        query.put((Object)"user", (Object)user);
        query.put((Object)"roomId", (Object)room);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("message", (Object)"DELETED");
            dbo.put("type", (Object)"DELETED");
            dbo.put("lastUpdatedTimestamp", (Object)System.currentTimeMillis());
            coll.save(dbo, WriteConcern.UNACKNOWLEDGED);
        }
    }

    @Override
    public List<RoomBean> getTeamRoomByName(String teamName) {
        if (StringUtils.isBlank((CharSequence)teamName)) {
            return null;
        }
        DBCollection cRooms = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject qRoom = new BasicDBObject();
        qRoom.put((Object)"team", (Object)teamName);
        qRoom.put((Object)"type", (Object)"t");
        ArrayList<RoomBean> roomBeans = new ArrayList<RoomBean>();
        DBCursor roomsCursor = cRooms.find((DBObject)qRoom);
        while (roomsCursor.hasNext()) {
            DBObject dbRoom = roomsCursor.next();
            RoomBean room = new RoomBean();
            room.setRoom((String)dbRoom.get("_id"));
            room.setFullName((String)dbRoom.get("team"));
            room.setUser((String)dbRoom.get("user"));
            room.setType((String)dbRoom.get("type"));
            if (StringUtils.isNotBlank((CharSequence)room.getUser())) {
                room.setAdmins(new String[]{room.getUser()});
            }
            if (dbRoom.containsField("timestamp")) {
                room.setTimestamp(((Long)dbRoom.get("timestamp")).longValue());
            }
            roomBeans.add(room);
        }
        return roomBeans;
    }

    @Override
    public RoomBean getTeamRoomById(String roomId) {
        if (roomId == null || roomId.isEmpty()) {
            return null;
        }
        DBCollection cRooms = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject qRoom = new BasicDBObject();
        qRoom.put((Object)"_id", (Object)roomId);
        qRoom.put((Object)"type", (Object)"t");
        DBObject dbRoom = cRooms.findOne((DBObject)qRoom);
        if (dbRoom == null) {
            return null;
        }
        RoomBean room = new RoomBean();
        room.setRoom((String)dbRoom.get("_id"));
        room.setFullName((String)dbRoom.get("team"));
        room.setUser((String)dbRoom.get("user"));
        room.setType((String)dbRoom.get("type"));
        if (StringUtils.isNotBlank((CharSequence)room.getUser())) {
            room.setAdmins(new String[]{room.getUser()});
        }
        if (dbRoom.containsField("timestamp")) {
            room.setTimestamp(((Long)dbRoom.get("timestamp")).longValue());
        }
        return room;
    }

    @Override
    public void deleteTeamRoom(String roomId, String user) {
        RoomBean room = this.getTeamRoomById(roomId);
        if (room == null) {
            LOG.warning("No room with id [" + roomId + "] available to delete");
            return;
        }
        if (!room.getType().equals("t")) {
            LOG.warning("The room with id [" + roomId + "] is not a Team Room so it won't be deleted.");
            return;
        }
        LOG.info("Deleting Team Chat Room [" + room.getFullName() + "] (id:" + room.getRoom() + ")");
        if (user == null || !room.getUser().equals(user)) {
            LOG.warning("The user [" + user + "] is not the owner of the room with id [" + roomId + "] so this room won't be deleted.");
            return;
        }
        DBCollection cMessages = this.db().getCollection("messages_room_t");
        BasicDBObject qMessages = new BasicDBObject();
        qMessages.put((Object)"roomId", (Object)roomId);
        cMessages.remove((DBObject)qMessages, WriteConcern.ACKNOWLEDGED);
        LOG.info("Messages of room [" + roomId + "] deleted");
        List<String> users = this.userDataStorage.getUsersFilterBy(null, roomId, "t");
        this.userDataStorage.removeTeamUsers(roomId, users);
        LOG.info("All users removed from the team room [" + roomId + "]");
        DBCollection cRooms = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject qRoom = new BasicDBObject();
        qRoom.put((Object)"_id", (Object)roomId);
        cRooms.remove((DBObject)qRoom, WriteConcern.ACKNOWLEDGED);
        LOG.info("Team room [" + roomId + "] deleted");
    }

    @Override
    public void edit(String room, String user, String messageId, String message) {
        String roomType = this.getTypeRoomChat(room);
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(messageId));
        query.put((Object)"user", (Object)user);
        query.put((Object)"roomId", (Object)room);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("message", (Object)message);
            dbo.put("type", (Object)"EDITED");
            dbo.put("lastUpdatedTimestamp", (Object)System.currentTimeMillis());
            coll.save(dbo, WriteConcern.UNACKNOWLEDGED);
        }
    }

    @Override
    public String read(String room) {
        return this.read(room, false, null, null, 0);
    }

    @Override
    public String read(String room, boolean isTextOnly, Long fromTimestamp) {
        return this.read(room, isTextOnly, fromTimestamp, null, 0);
    }

    @Override
    public String read(String room, boolean isTextOnly, Long fromTimestamp, Long toTimestamp, int limitToLoad) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        String roomType = this.getTypeRoomChat(room);
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"roomId", (Object)room);
        BasicDBObject duration = null;
        if (fromTimestamp != null) {
            duration = new BasicDBObject("$gt", (Object)fromTimestamp);
        }
        if (toTimestamp != null) {
            if (duration == null) {
                duration = new BasicDBObject("$lt", (Object)toTimestamp);
            } else {
                duration.append("$lt", (Object)toTimestamp);
            }
        }
        if (duration != null) {
            BasicDBObject ts = new BasicDBObject("timestamp", (Object)duration);
            BasicDBObject updts = new BasicDBObject("lastUpdatedTimestamp", (Object)duration);
            query.put((Object)"$or", (Object)new BasicDBObject[]{ts, updts});
        }
        BasicDBObject sort = new BasicDBObject();
        sort.put((Object)"timestamp", (Object)-1);
        int limit = limitToLoad > 0 ? limitToLoad : (isTextOnly ? this.readTotalTxt : this.readTotalJson);
        DBCursor cursor = coll.find((DBObject)query).sort((DBObject)sort).limit(limit);
        StringBuilder sb = new StringBuilder();
        if (!cursor.hasNext()) {
            if (isTextOnly) {
                sb.append("no messages");
            } else {
                sb.append("{\"room\": \"").append(room).append("\",\"messages\": []}");
            }
        } else {
            HashMap<String, UserBean> users = new HashMap<String, UserBean>();
            boolean first = true;
            JSONObject data = new JSONObject();
            while (cursor.hasNext()) {
                String user;
                UserBean userBean;
                DBObject dbo = cursor.next();
                String timestamp = dbo.get("timestamp").toString();
                if (first && !isTextOnly) {
                    data.put((Object)"room", (Object)room);
                    data.put((Object)"timestamp", (Object)timestamp);
                    data.put((Object)"messages", (Object)new JSONArray());
                }
                if ((userBean = (UserBean)users.get(user = dbo.get("user").toString())) == null) {
                    userBean = this.userDataStorage.getUser(user);
                    users.put(user, userBean);
                }
                String fullName = userBean.getFullname();
                if (isTextOnly) {
                    String date = "";
                    try {
                        Date date1 = new Date(Long.parseLong(timestamp));
                        date = this.formatterDate.format(date1);
                    }
                    catch (Exception e) {
                        LOG.info("Message Date Format Error : " + e.getMessage());
                    }
                    StringBuilder line = new StringBuilder();
                    line.append("[").append(date).append("] ");
                    String message = dbo.get("message").toString();
                    if ("DELETED".equals(message)) {
                        message = "DELETED";
                    }
                    if ("true".equals(dbo.get("isSystem"))) {
                        line.append("System Message: ");
                        if (message.endsWith("<br/>")) {
                            message = message.substring(0, message.length() - 5);
                        }
                        line.append(message).append("\n");
                    } else {
                        line.append(fullName).append(": ");
                        message = message.replaceAll("<br/>", "\n");
                        line.append(message).append("\n");
                    }
                    sb.insert(0, line);
                } else {
                    MessageBean msg = this.toMessageBean(dbo);
                    msg.setFullName(fullName);
                    ((JSONArray)data.get((Object)"messages")).add((Object)msg.toJSONObject());
                }
                first = false;
            }
            if (!isTextOnly) {
                sb.append(data.toJSONString());
            }
        }
        return sb.toString();
    }

    @Override
    public MessageBean getMessage(String roomId, String messageId) {
        String roomType = this.getTypeRoomChat(roomId);
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"roomId", (Object)roomId);
        query.put((Object)"_id", (Object)new ObjectId(messageId));
        DBObject object = coll.findOne((DBObject)query);
        if (object != null) {
            return this.toMessageBean(object);
        }
        return null;
    }

    private void updateRoomTimestamp(String room) {
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("timestamp", (Object)System.currentTimeMillis());
            coll.save(dbo, WriteConcern.UNACKNOWLEDGED);
        }
    }

    private void ensureIndexInRoom(String type) {
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + type);
        BasicDBObject doc = new BasicDBObject();
        doc.put((Object)"timestamp", (Object)System.currentTimeMillis());
        coll.insert(new DBObject[]{doc});
        ConnectionManager.getInstance().ensureIndexesInRoom(type);
        coll.remove((DBObject)doc);
    }

    @Override
    public String getSpaceRoom(String space) {
        String room = ChatUtils.getRoomId((String)space);
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put((Object)"space", (Object)space);
                basicDBObject.put((Object)"type", (Object)"s");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom("s");
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getSpaceRoomByName(String name) {
        String room = null;
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"shortName", (Object)name);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            room = doc.get("_id").toString();
        }
        return room;
    }

    @Override
    public String getTeamRoom(String team, String user) {
        String room = ChatUtils.getRoomId((String)team, (String)user);
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put((Object)"team", (Object)team);
                basicDBObject.put((Object)"user", (Object)user);
                basicDBObject.put((Object)"type", (Object)"t");
                basicDBObject.put((Object)"timestamp", (Object)System.currentTimeMillis());
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom("t");
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getExternalRoom(String identifier) {
        String room = ChatUtils.getExternalRoomId((String)identifier);
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put((Object)"identifier", (Object)identifier);
                basicDBObject.put((Object)"type", (Object)"e");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom("e");
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getTeamCreator(String room) {
        if (room.indexOf("team-") == 0) {
            room = room.substring("team-".length());
        }
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        String creator = "";
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            try {
                DBObject dbo = cursor.next();
                creator = dbo.get("user").toString();
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return creator;
    }

    @Override
    public void setRoomName(String room, String name) {
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("team", (Object)name);
            coll.save(dbo, WriteConcern.UNACKNOWLEDGED);
        }
    }

    @Override
    public String getRoom(List<String> users) {
        Collections.sort(users);
        String room = ChatUtils.getRoomId(users);
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put((Object)"users", users);
                basicDBObject.put((Object)"type", (Object)"u");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom("u");
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getTypeRoomChat(String roomId) {
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        Object roomType = null;
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            roomType = doc.get("type");
        }
        return roomType == null ? "" : roomType.toString();
    }

    @Override
    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        String roomId = null;
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"users", (Object)user);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            roomId = dbo.get("_id").toString();
            long timestamp = -1L;
            if (dbo.containsField("timestamp")) {
                timestamp = (Long)dbo.get("timestamp");
            }
            List users = (List)dbo.get("users");
            users.remove(user);
            if (users.size() <= 0 || user.equals(users.get(0))) continue;
            String targetUser = (String)users.get(0);
            boolean isDemoUser = tokenService.isDemoUser(targetUser);
            if (isAdmin && (!isAdmin || (withPublic || isDemoUser) && (!withPublic || !isDemoUser))) continue;
            RoomBean roomBean = new RoomBean();
            roomBean.setRoom(roomId);
            roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", roomId));
            roomBean.setUser((String)users.get(0));
            roomBean.setTimestamp(timestamp);
            roomBean.setType((String)dbo.get("type"));
            String creator = (String)dbo.get("user");
            if (StringUtils.isNotBlank((CharSequence)creator)) {
                roomBean.setAdmins(new String[]{creator});
            }
            rooms.add(roomBean);
        }
        return rooms;
    }

    @Override
    public RoomsBean getRooms(String user, List<String> onlineUsers, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, int limit, NotificationService notificationService, TokenService tokenService) {
        List<Object> rooms;
        UserBean userBean = this.userDataStorage.getUser(user, true);
        int unreadOffline = 0;
        int unreadOnline = 0;
        boolean totalRooms = false;
        if (withUsers) {
            rooms = this.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService);
            if (isAdmin) {
                rooms.addAll(this.getExistingRooms("__support_", withPublic, isAdmin, notificationService, tokenService));
            }
            Map availableUsers = tokenService.getActiveUsersFilterBy(user, onlineUsers, withUsers, withPublic, isAdmin, limit);
            ArrayList<RoomBean> roomsOffline = new ArrayList<RoomBean>();
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getUser();
                roomBean.setFavorite(userBean.isFavorite(roomBean.getRoom()));
                if (availableUsers.containsKey(targetUser)) {
                    UserBean userBean2 = (UserBean)availableUsers.remove(targetUser);
                    roomBean.setFullName(userBean2.getFullname());
                    roomBean.setStatus(userBean2.getStatus());
                    roomBean.setAvailableUser(true);
                    if (roomBean.getUnreadTotal() <= 0) continue;
                    unreadOnline += roomBean.getUnreadTotal();
                    continue;
                }
                UserBean userBean3 = this.userDataStorage.getUser(targetUser);
                roomBean.setFullName(userBean3.getFullname());
                roomBean.setAvailableUser(false);
                if (!withOffline) {
                    roomsOffline.add(roomBean);
                }
                if (roomBean.getUnreadTotal() <= 0) continue;
                unreadOffline += roomBean.getUnreadTotal();
            }
            if (!withOffline) {
                for (RoomBean roomBean : roomsOffline) {
                    rooms.remove(roomBean);
                }
            }
            for (UserBean userBean4 : availableUsers.values()) {
                String status = userBean4.getStatus();
                if (!withOffline && (withOffline || "invisible".equals(status) || "offline".equals(status))) continue;
                RoomBean roomBean = new RoomBean();
                roomBean.setUser(userBean4.getName());
                roomBean.setFullName(userBean4.getFullname());
                roomBean.setStatus(userBean4.getStatus());
                roomBean.setAvailableUser(true);
                roomBean.setType("u");
                rooms.add(roomBean);
            }
        } else {
            rooms = new ArrayList();
        }
        int unreadSpaces = 0;
        List<SpaceBean> spaces = this.userDataStorage.getSpaces(user);
        for (SpaceBean spaceBean : spaces) {
            RoomBean room = new RoomBean();
            room.setUser("space-" + spaceBean.getRoom());
            room.setRoom(spaceBean.getRoom());
            room.setFullName(spaceBean.getDisplayName());
            room.setStatus("space");
            room.setTimestamp(spaceBean.getTimestamp());
            room.setAvailableUser(true);
            room.setType("s");
            room.setPrettyName(spaceBean.getPrettyName());
            room.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", this.getSpaceRoom("space-" + spaceBean.getRoom())));
            if (room.getUnreadTotal() > 0) {
                unreadSpaces += room.getUnreadTotal();
            }
            room.setFavorite(userBean.isFavorite(room.getRoom()));
            if (!withSpaces) continue;
            rooms.add(room);
        }
        int unreadTeams = 0;
        List<RoomBean> list = this.userDataStorage.getTeams(user);
        for (RoomBean roomBean : list) {
            RoomBean roomBean2 = new RoomBean();
            roomBean2.setUser("team-" + roomBean.getRoom());
            roomBean2.setRoom(roomBean.getRoom());
            roomBean2.setFullName(roomBean.getFullName());
            roomBean2.setStatus("team");
            roomBean2.setTimestamp(roomBean.getTimestamp());
            roomBean2.setAvailableUser(true);
            roomBean2.setType(roomBean.getType());
            roomBean2.setAdmins(roomBean.getAdmins());
            roomBean2.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", roomBean.getRoom()));
            if (roomBean2.getUnreadTotal() > 0) {
                unreadTeams += roomBean2.getUnreadTotal();
            }
            roomBean2.setFavorite(userBean.isFavorite(roomBean2.getRoom()));
            if (!withSpaces) continue;
            rooms.add(roomBean2);
        }
        List<Object> finalRooms = new ArrayList();
        if (filter != null) {
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getFullName();
                if (!this.filter(targetUser, filter)) continue;
                finalRooms.add(roomBean);
            }
        } else {
            finalRooms = rooms;
        }
        RoomsBean roomsBean = new RoomsBean();
        roomsBean.setRooms(finalRooms);
        roomsBean.setUnreadOffline(unreadOffline);
        roomsBean.setUnreadOnline(unreadOnline);
        roomsBean.setUnreadSpaces(unreadSpaces);
        roomsBean.setUnreadTeams(unreadTeams);
        return roomsBean;
    }

    private boolean filter(String user, String filter) {
        if (user == null || filter == null || "".equals(filter)) {
            return true;
        }
        String[] args = filter.toLowerCase().split(" ");
        String s = user.toLowerCase();
        for (String arg : args) {
            int ind = s.indexOf(arg);
            if (ind == -1) {
                return false;
            }
            s = s.substring(ind);
        }
        return true;
    }

    @Override
    public int getNumberOfRooms() {
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    @Override
    public int getNumberOfMessages() {
        String[] roomTypes;
        int nb = 0;
        for (String type : roomTypes = new String[]{"u", "s", "t", "e"}) {
            DBCollection collr = this.db().getCollection(M_ROOM_PREFIX + type);
            BasicDBObject queryr = new BasicDBObject();
            DBCursor cursorr = collr.find((DBObject)queryr);
            nb += cursorr.count();
        }
        return nb;
    }

    private MessageBean toMessageBean(DBObject dbo) {
        MessageBean msg = new MessageBean();
        msg.setId(dbo.get("_id").toString());
        msg.setUser(dbo.get("user").toString());
        msg.setMessage(dbo.get("message").toString());
        msg.setTimestamp(Long.parseLong(dbo.get("timestamp").toString()));
        if (dbo.containsField("lastUpdatedTimestamp")) {
            msg.setLastUpdatedTimestamp(Long.parseLong(dbo.get("lastUpdatedTimestamp").toString()));
        }
        msg.setSystem(Boolean.parseBoolean(dbo.get("isSystem").toString()));
        if (dbo.containsField("options")) {
            msg.setOptions(dbo.get("options").toString());
        }
        if (dbo.containsField("type")) {
            msg.setType(dbo.get("type").toString());
        }
        return msg;
    }
}

