/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.upgrade;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.regex.Pattern;
import org.exoplatform.chat.services.mongodb.MongoBootstrap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MigrateService {
    private static final Log LOG = ExoLogger.getLogger(MigrateService.class);
    private DB db = new MongoBootstrap().getDB();

    public void migrate() {
        DBCollection namespacesCol = this.db.getCollection("system.namespaces");
        BasicDBObject getRoomNamespaces = new BasicDBObject();
        Pattern regex = Pattern.compile("^" + this.db.getName() + ".room_");
        getRoomNamespaces.append("name", (Object)regex);
        DBCursor roomNamespaces = namespacesCol.find((DBObject)getRoomNamespaces);
        if (roomNamespaces.count() > 0) {
            String[] roomTypes;
            for (String type : roomTypes = new String[]{"u", "s", "t", "e"}) {
                this.migrateRoom(type);
            }
            if (this.db.collectionExists("room_rooms")) {
                DBCollection roomsCol = this.db.getCollection("room_rooms");
                if (!this.db.collectionExists("rooms")) {
                    roomsCol.rename("rooms");
                } else {
                    DBCollection newRoomsCol = this.db.getCollection("rooms");
                    DBCursor rooms = roomsCol.find();
                    while (rooms.hasNext()) {
                        DBObject room = rooms.next();
                        newRoomsCol.insert(new DBObject[]{room});
                    }
                    roomsCol.drop();
                }
                LOG.info((Object)"Finished to migrate room_rooms collection");
            }
        }
    }

    private void migrateRoom(String roomType) {
        if (!this.db.collectionExists("messages_room_" + roomType)) {
            this.db.createCollection("messages_room_" + roomType, null);
        }
        DBCollection roomsCol = this.db.getCollection("room_rooms");
        BasicDBObject findRoomsByType = new BasicDBObject();
        findRoomsByType.put((Object)"type", (Object)roomType);
        DBCursor cursor = roomsCol.find((DBObject)findRoomsByType);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            String roomId = dbo.get("_id").toString();
            String roomName = "room_" + roomId;
            if (!this.db.collectionExists(roomName)) continue;
            DBCollection roomCol = this.db.getCollection(roomName);
            BasicDBObject addRoomIdToMessages = new BasicDBObject();
            addRoomIdToMessages.append("$set", (Object)new BasicDBObject().append("roomId", (Object)roomId));
            roomCol.updateMulti((DBObject)new BasicDBObject(), (DBObject)addRoomIdToMessages);
            DBCursor allMessages = roomCol.find();
            DBCollection newRoomCol = this.db.getCollection("messages_room_" + roomType);
            while (allMessages.hasNext()) {
                DBObject message = allMessages.next();
                message.removeField("time");
                newRoomCol.insert(new DBObject[]{message});
            }
            roomCol.drop();
        }
        LOG.info("Finished to migrate rooms with type : {}", new Object[]{roomType});
    }
}

