/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.utils.ChatUtils;
import org.json.JSONException;

@Named(value="userStorage")
@ApplicationScoped
@Singleton
public class UserMongoDataStorage
implements UserDataStorage {
    private static final Logger LOG = Logger.getLogger(UserMongoDataStorage.class.getName());
    public static final String M_USERS_COLLECTION = "users";
    public static final String M_ROOMS_COLLECTION = "rooms";
    public static final String DEFAULT_ENABLED_CHANNELS = "[ \"desktop\" , \"on-site\" , \"bip\"]";
    public static final String FAVORITES = "favorites";
    public static final String USER = "user";
    public static final String FULLNAME = "fullname";
    public static final String IS_ENABLED = "isEnabled";
    public static final String IS_DELETED = "isDeleted";
    public static final String ID = "_id";
    public static final String EMAIL = "email";
    public static final String IS_EXTERNAL = "isExternal";
    public static final String SPACE_ID = "space_id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String GROUP_ID = "groupId";
    public static final String SHORT_NAME = "shortName";
    public static final String PRETTY_NAME = "prettyName";
    public static final String TYPE = "type";
    public static final String SPACES = "spaces";
    public static final String MEETING_STARTED = "meetingStarted";
    public static final String START_TIME = "startTime";
    public static final String TIMESTAMP = "timestamp";
    public static final String USERS = "users";
    public static final String TEAMS = "teams";
    public static final String STATUS = "status";
    public static final String TRUE = "true";
    public static final String EMPTY_STRING = "";
    public static final String FALSE = "false";
    public static final String IS_SUPPORT_ADMIN = "isSupportAdmin";

    private MongoDatabase db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public void addFavorite(String user, String targetUser) {
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            List<String> favorites = new ArrayList();
            if (doc.containsKey((Object)FAVORITES)) {
                favorites = (List)doc.get((Object)FAVORITES);
            }
            if (!favorites.contains(targetUser)) {
                favorites.add(targetUser);
                Bson update = Updates.set((String)FAVORITES, favorites);
                coll.updateOne((Bson)query, update);
            }
        }
    }

    @Override
    public void removeFavorite(String user, String targetUser) {
        List favorites;
        Document doc;
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext() && (doc = (Document)cursor.next()).containsKey((Object)FAVORITES) && (favorites = (List)doc.get((Object)FAVORITES)).contains(targetUser)) {
            favorites.remove(targetUser);
            Bson update = Updates.set((String)FAVORITES, (Object)favorites);
            coll.updateOne((Bson)query, update);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPreferredNotification(String user, String notifManner) throws Exception {
        Bson query;
        MongoCollection usersCollection = this.db().getCollection("users");
        MongoCursor cursor = usersCollection.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (!cursor.hasNext()) throw new Exception("Doc not found, operation not done");
        Document doc = (Document)cursor.next();
        if (!"bip".equals(notifManner) && !"desktop".equals(notifManner) && !"on-site".equals(notifManner)) throw new Exception("Wrong Params, operation not done");
        Document settings = (Document)doc.get((Object)"notificationsSettings");
        Object prefNotif = null;
        Object prefTriger = null;
        Object existingRoomNotif = null;
        if (settings != null) {
            prefNotif = settings.get((Object)"preferredNotification");
            prefTriger = settings.get((Object)"preferredNotificationTrigger");
            existingRoomNotif = settings.get((Object)"preferredRoomNotificationTrigger");
        } else {
            settings = new Document();
        }
        ArrayList<String> existingPrefNotif = null;
        if (prefNotif == null) {
            existingPrefNotif = new ArrayList<String>();
            existingPrefNotif.add("on-site");
            existingPrefNotif.add("desktop");
            existingPrefNotif.add("bip");
        } else {
            existingPrefNotif = (ArrayList<String>)prefNotif;
        }
        if (existingPrefNotif.contains(notifManner)) {
            existingPrefNotif.remove(notifManner);
        } else {
            existingPrefNotif.add(notifManner);
        }
        settings.put("preferredNotification", existingPrefNotif);
        if (prefTriger != null) {
            settings.put("preferredNotificationTrigger", prefTriger);
        }
        if (existingRoomNotif != null) {
            settings.put("preferredRoomNotificationTrigger", existingRoomNotif);
        }
        Bson update = Updates.set((String)"notificationsSettings", (Object)settings);
        usersCollection.updateOne(query, update);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNotificationTrigger(String user, String notifCond) throws Exception {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (!cursor.hasNext()) throw new Exception("Doc not found, operation not done");
        Document doc = (Document)cursor.next();
        if (!"notify-even-not-disturb".equals(notifCond) && !"notify-when-mention".equals(notifCond)) throw new Exception("Wrong Params, operation not done");
        Document settings = (Document)doc.get((Object)"notificationsSettings");
        Object prefNotif = null;
        Object prefTriger = null;
        Object existingRoomNotif = null;
        if (settings != null) {
            prefNotif = settings.get((Object)"preferredNotificationTrigger");
            prefTriger = settings.get((Object)"preferredNotification");
            existingRoomNotif = settings.get((Object)"preferredRoomNotificationTrigger");
        } else {
            settings = new Document();
        }
        ArrayList<String> existingPrefNotif = prefNotif == null ? new ArrayList<String>() : (ArrayList<String>)prefNotif;
        if (existingPrefNotif.contains(notifCond)) {
            existingPrefNotif.remove(notifCond);
        } else {
            existingPrefNotif.add(notifCond);
        }
        settings.put("preferredNotificationTrigger", existingPrefNotif);
        if (prefTriger != null) {
            settings.put("preferredNotification", prefTriger);
        }
        if (existingRoomNotif != null) {
            settings.put("preferredRoomNotificationTrigger", existingRoomNotif);
        }
        Bson update = Updates.set((String)"notificationsSettings", (Object)settings);
        coll.updateOne(query, update);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRoomNotificationTrigger(String user, String room, String notifCond, String notifConditionType, long time) throws Exception {
        Document notifData;
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (!cursor.hasNext()) throw new Exception("Doc not found, operation not done");
        Document doc = (Document)cursor.next();
        if (!"normal".equals(notifConditionType) && !"silence".equals(notifConditionType) && !notifConditionType.startsWith("keywords")) throw new Exception("Wrong Params, operation not done");
        Document settings = (Document)doc.get((Object)"notificationsSettings");
        Object prefNotif = null;
        Object prefTriger = null;
        Document existingRoomNotif = null;
        if (settings != null) {
            prefTriger = settings.get((Object)"preferredNotificationTrigger");
            prefNotif = settings.get((Object)"preferredNotification");
            existingRoomNotif = (Document)settings.get((Object)"preferredRoomNotificationTrigger");
        } else {
            settings = new Document();
        }
        if (existingRoomNotif == null) {
            existingRoomNotif = new Document();
        }
        if ((notifData = (Document)existingRoomNotif.get((Object)room)) == null) {
            notifData = new Document();
        }
        if (notifData.get((Object)"time") == null || (Long)notifData.get((Object)"time") < time) {
            notifData.put("notifCond", (Object)notifConditionType);
            notifData.put("time", (Object)time);
            if ("keywords".equals(notifConditionType)) {
                notifData.put("keywords", (Object)notifCond);
            }
        }
        if (prefTriger != null) {
            settings.put("preferredNotificationTrigger", prefTriger);
        }
        if (prefNotif != null) {
            settings.put("preferredNotification", prefNotif);
        }
        if (existingRoomNotif != null) {
            existingRoomNotif.put(room, (Object)notifData);
            settings.put("preferredRoomNotificationTrigger", (Object)existingRoomNotif);
        }
        coll.updateOne(query, Updates.set((String)"notificationsSettings", (Object)settings));
    }

    @Override
    public NotificationSettingsBean getUserDesktopNotificationSettings(String user) throws JSONException {
        NotificationSettingsBean settings = new NotificationSettingsBean();
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            Document wrapperDoc = (Document)doc.get((Object)"notificationsSettings");
            if (wrapperDoc == null) {
                wrapperDoc = new Document();
            }
            if (wrapperDoc.get((Object)"preferredNotification") != null) {
                settings.setEnabledChannels(wrapperDoc.get((Object)"preferredNotification").toString());
            } else {
                settings.setEnabledChannels(DEFAULT_ENABLED_CHANNELS);
            }
            if (wrapperDoc.get((Object)"preferredNotificationTrigger") != null) {
                settings.setEnabledTriggers(wrapperDoc.get((Object)"preferredNotificationTrigger").toString());
            }
            if (wrapperDoc.get((Object)"preferredRoomNotificationTrigger") != null) {
                Document preferredRoomNotificationTrigger = (Document)wrapperDoc.get((Object)"preferredRoomNotificationTrigger");
                settings.setEnabledRoomTriggers(preferredRoomNotificationTrigger.toJson());
            }
        }
        return settings;
    }

    @Override
    public boolean isFavorite(String user, String targetUser) {
        List favorites;
        Document doc;
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        return cursor.hasNext() && (doc = (Document)cursor.next()).containsKey((Object)FAVORITES) && (favorites = (List)doc.get((Object)FAVORITES)).contains(targetUser);
    }

    @Override
    public void addUserFullName(String user, String fullName) {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (!cursor.hasNext()) {
            Document doc = new Document();
            doc.put(ID, (Object)user);
            doc.put(USER, (Object)user);
            doc.put(FULLNAME, (Object)fullName);
            doc.put(IS_ENABLED, (Object)Boolean.TRUE.toString());
            doc.put(IS_DELETED, (Object)Boolean.FALSE.toString());
            coll.insertOne((Object)doc);
        } else {
            Bson update = Updates.set((String)FULLNAME, (Object)fullName);
            coll.updateOne(query, update);
        }
    }

    @Override
    public void addUserEmail(String user, String email) {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (!cursor.hasNext()) {
            Document doc = new Document();
            doc.put(ID, (Object)user);
            doc.put(USER, (Object)user);
            doc.put(EMAIL, (Object)email);
            doc.put(IS_ENABLED, (Object)Boolean.TRUE.toString());
            doc.put(IS_DELETED, (Object)Boolean.FALSE.toString());
            coll.insertOne((Object)doc);
        } else {
            Bson update = Updates.set((String)EMAIL, (Object)email);
            coll.updateOne(query, update);
        }
    }

    @Override
    public void deleteUser(String user) {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (cursor.hasNext()) {
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)IS_DELETED, (Object)Boolean.TRUE.toString()), Updates.set((String)IS_ENABLED, (Object)Boolean.FALSE.toString())});
            coll.updateOne(query, update);
        }
    }

    @Override
    public void setEnabledUser(String user, Boolean isEnabled) {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (cursor.hasNext()) {
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)IS_DELETED, (Object)Boolean.FALSE.toString()), Updates.set((String)IS_ENABLED, (Object)isEnabled.toString())});
            coll.updateOne(query, update);
        }
    }

    @Override
    public void setExternalUser(String user, String isExternal) {
        MongoCollection coll = this.db().getCollection("users");
        Bson query = Filters.eq((String)USER, (Object)user);
        Bson update = Updates.set((String)IS_EXTERNAL, (Object)isExternal);
        coll.updateOne(query, update);
    }

    @Override
    public void setSpaces(String user, List<SpaceBean> spaces) {
        Bson query;
        ArrayList<String> spaceIds = new ArrayList<String>();
        MongoCollection roomsCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        for (SpaceBean bean : spaces) {
            Document doc;
            String room = ChatUtils.getRoomId((String)bean.getId());
            spaceIds.add(room);
            Bson query2 = Filters.eq((String)ID, (Object)room);
            MongoCursor cursor = roomsCollection.find(query2).cursor();
            if (!cursor.hasNext()) {
                doc = new Document();
                doc.put(ID, (Object)room);
                doc.put(SPACE_ID, (Object)bean.getId());
                doc.put(DISPLAY_NAME, (Object)bean.getDisplayName());
                doc.put(GROUP_ID, (Object)bean.getGroupId());
                doc.put(SHORT_NAME, (Object)bean.getShortName());
                doc.put(PRETTY_NAME, (Object)bean.getPrettyName());
                doc.put(TYPE, (Object)"s");
                doc.put(IS_ENABLED, (Object)true);
                roomsCollection.insertOne((Object)doc);
                continue;
            }
            doc = (Document)cursor.next();
            String displayName = doc.get((Object)DISPLAY_NAME).toString();
            Object prettyName = doc.get((Object)PRETTY_NAME);
            if (bean.getDisplayName().equals(displayName) && prettyName != null && bean.getPrettyName().equals(prettyName.toString())) continue;
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)ID, (Object)room), Updates.set((String)DISPLAY_NAME, (Object)bean.getDisplayName()), Updates.set((String)GROUP_ID, (Object)bean.getGroupId()), Updates.set((String)SHORT_NAME, (Object)bean.getShortName()), Updates.set((String)PRETTY_NAME, (Object)bean.getPrettyName()), Updates.set((String)IS_ENABLED, (Object)true)});
            roomsCollection.updateOne(query2, update);
        }
        MongoCollection usersCollection = this.db().getCollection("users");
        MongoCursor cursor = usersCollection.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (cursor.hasNext()) {
            doc = Updates.set((String)SPACES, spaceIds);
            usersCollection.updateOne(query, doc);
        } else {
            doc = new Document();
            doc.append(ID, (Object)user);
            doc.append(USER, (Object)user);
            doc.append(SPACES, spaceIds);
            doc.append(IS_ENABLED, (Object)Boolean.toString(true));
            doc.append(IS_DELETED, (Object)Boolean.toString(false));
            usersCollection.insertOne((Object)doc);
        }
    }

    @Override
    public void addTeamRoom(String user, String teamRoomId) {
        ArrayList<String> teamIds = new ArrayList<String>();
        teamIds.add(teamRoomId);
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Bson updateDoc;
            Document doc = (Document)cursor.next();
            if (doc.containsKey((Object)TEAMS)) {
                List existingTeams = (List)doc.get((Object)TEAMS);
                if (!existingTeams.contains(teamRoomId)) {
                    existingTeams.add(teamRoomId);
                }
                updateDoc = Updates.set((String)TEAMS, (Object)existingTeams);
            } else {
                updateDoc = Updates.set((String)TEAMS, teamIds);
            }
            coll.updateOne((Bson)query, updateDoc);
        } else {
            Document doc = new Document();
            doc.put(ID, (Object)user);
            doc.put(USER, (Object)user);
            doc.put(TEAMS, teamIds);
            coll.insertOne((Object)doc);
        }
    }

    @Override
    public void removeTeamUsers(String teamRoomId, List<String> users) {
        MongoCollection coll = this.db().getCollection("users");
        for (String user : users) {
            List teams;
            Document doc;
            BasicDBObject query = new BasicDBObject();
            query.put((Object)USER, (Object)user);
            MongoCursor cursor = coll.find((Bson)query).cursor();
            if (!cursor.hasNext() || !(doc = (Document)cursor.next()).containsKey((Object)TEAMS) || !(teams = (List)doc.get((Object)TEAMS)).contains(teamRoomId)) continue;
            teams.remove(teamRoomId);
            doc.put(TEAMS, (Object)teams);
            coll.replaceOne((Bson)query, (Object)doc);
        }
    }

    private RoomBean getTeam(String teamId) {
        RoomBean roomBean = null;
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)ID, (Object)teamId);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            roomBean = new RoomBean();
            roomBean.setRoom(teamId);
            roomBean.setUser(doc.get((Object)USER).toString());
            roomBean.setFullName(doc.get((Object)"team").toString());
            roomBean.setType(doc.get((Object)TYPE).toString());
            if (doc.containsKey((Object)IS_ENABLED)) {
                roomBean.setEnabledRoom(StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE));
            }
            if (doc.containsKey((Object)MEETING_STARTED)) {
                roomBean.setMeetingStarted(((Boolean)doc.get((Object)MEETING_STARTED)).booleanValue());
            }
            if (doc.containsKey((Object)START_TIME)) {
                roomBean.setStartTime((String)doc.get((Object)START_TIME));
            }
            if (doc.containsKey((Object)TIMESTAMP)) {
                roomBean.setTimestamp(((Long)doc.get((Object)TIMESTAMP)).longValue());
            }
            if (StringUtils.isNotBlank((CharSequence)roomBean.getUser())) {
                roomBean.setAdmins(new String[]{roomBean.getUser()});
            }
        }
        return roomBean;
    }

    @Override
    public List<RoomBean> getTeams(String user) {
        Document doc;
        List listrooms;
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext() && (listrooms = (List)(doc = (Document)cursor.next()).get((Object)TEAMS)) != null) {
            for (String room : listrooms) {
                rooms.add(this.getTeam(room));
            }
        }
        return rooms;
    }

    @Override
    public RoomBean getRoom(String user, String roomId) {
        RoomBean roomBean = null;
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)ID, (Object)roomId);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            roomBean = new RoomBean();
            roomBean.setRoom(roomId);
            Document doc = (Document)cursor.next();
            if (doc.containsKey((Object)TIMESTAMP)) {
                roomBean.setTimestamp(((Long)doc.get((Object)TIMESTAMP)).longValue());
            }
            String type = doc.get((Object)TYPE).toString();
            roomBean.setType(type);
            if (doc.containsKey((Object)IS_ENABLED)) {
                roomBean.setEnabledRoom(StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE));
            }
            if ("s".equals(type)) {
                roomBean.setPrettyName(doc.get((Object)PRETTY_NAME).toString());
                roomBean.setUser("space-" + roomId);
                roomBean.setFullName(doc.get((Object)DISPLAY_NAME).toString());
                if (doc.containsKey((Object)MEETING_STARTED)) {
                    roomBean.setMeetingStarted(((Boolean)doc.get((Object)MEETING_STARTED)).booleanValue());
                }
                if (doc.containsKey((Object)START_TIME)) {
                    roomBean.setStartTime((String)doc.get((Object)START_TIME));
                }
            } else if ("t".equals(type)) {
                roomBean.setUser("team-" + roomId);
                roomBean.setFullName(doc.get((Object)"team").toString());
                String creator = (String)doc.get((Object)USER);
                roomBean.setAdmins(new String[]{creator});
                if (doc.containsKey((Object)MEETING_STARTED)) {
                    roomBean.setMeetingStarted(((Boolean)doc.get((Object)MEETING_STARTED)).booleanValue());
                }
                if (doc.containsKey((Object)START_TIME)) {
                    roomBean.setStartTime((String)doc.get((Object)START_TIME));
                }
            } else if ("u".equals(type)) {
                List users = (List)doc.get((Object)"users");
                users.remove(user);
                String targetUser = (String)users.get(0);
                roomBean.setUser(targetUser);
                roomBean.setFullName(this.getUserFullName(targetUser));
                roomBean.setExternal(this.getExternalValue(targetUser));
            } else if ("e".equals(type)) {
                roomBean.setUser("external-" + roomId);
                roomBean.setFullName(doc.get((Object)"identifier").toString());
            }
        }
        return roomBean;
    }

    private SpaceBean getSpace(String roomId) {
        Bson query;
        SpaceBean spaceBean = null;
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        MongoCursor cursor = coll.find(query = Filters.eq((String)ID, (Object)roomId)).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            spaceBean = new SpaceBean();
            spaceBean.setRoom(roomId);
            spaceBean.setId(doc.get((Object)SPACE_ID).toString());
            spaceBean.setDisplayName(doc.get((Object)DISPLAY_NAME).toString());
            spaceBean.setGroupId(doc.get((Object)GROUP_ID).toString());
            spaceBean.setShortName(doc.get((Object)SHORT_NAME).toString());
            if (doc.containsKey((Object)PRETTY_NAME)) {
                spaceBean.setPrettyName(doc.get((Object)PRETTY_NAME).toString());
            }
            if (doc.containsKey((Object)MEETING_STARTED)) {
                spaceBean.setMeetingStarted(((Boolean)doc.get((Object)MEETING_STARTED)).booleanValue());
            }
            if (doc.containsKey((Object)START_TIME)) {
                spaceBean.setStartTime((String)doc.get((Object)START_TIME));
            }
            if (doc.containsKey((Object)TIMESTAMP)) {
                spaceBean.setTimestamp(((Long)doc.get((Object)TIMESTAMP)).longValue());
            }
        }
        return spaceBean;
    }

    @Override
    public List<SpaceBean> getSpaces(String user) {
        Document doc;
        List listspaces;
        Bson query;
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (cursor.hasNext() && (listspaces = (List)(doc = (Document)cursor.next()).get((Object)SPACES)) != null) {
            for (String space : listspaces) {
                spaces.add(this.getSpace(space));
            }
        }
        return spaces;
    }

    @Override
    public List<UserBean> getUsersInRoomChatOneToOne(String roomId) {
        ArrayList<UserBean> users = new ArrayList<UserBean>();
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson query = Filters.eq((String)ID, (Object)roomId);
        MongoCursor cursor = coll.find(query).cursor();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            Object objectUsers = doc.get((Object)"users");
            ArrayList myArrayList = (ArrayList)objectUsers;
            for (Object o : myArrayList) {
                users.add(this.getUser(o.toString()));
            }
        }
        return users;
    }

    @Override
    public List<UserBean> getUsers(String roomId, String filter, int limit) {
        return this.getUsers(roomId, null, filter, limit, false);
    }

    @Override
    public List<UserBean> getUsers(String roomId, List<String> onlineUsers, String filter, int limit, boolean onlyOnlineUsers) {
        Object prop;
        UserBean userBean;
        Document doc;
        MongoCursor cursor;
        MongoCollection coll;
        Bson query;
        if (roomId == null && filter == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Bson> andList = new ArrayList<Bson>();
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            if (roomId.indexOf("space-") == 0) {
                roomId = roomId.substring("space-".length());
            } else if (roomId.indexOf("team-") == 0) {
                roomId = roomId.substring("team-".length());
            }
            ArrayList<Bson> orList = new ArrayList<Bson>();
            orList.add(Filters.eq((String)SPACES, (Object)roomId));
            orList.add(Filters.eq((String)TEAMS, (Object)roomId));
            andList.add(Filters.or(orList));
        }
        if (filter != null) {
            filter = filter.replace(" ", ".*");
            Pattern regex = Pattern.compile(filter, 2);
            ArrayList<Bson> orList = new ArrayList<Bson>();
            orList.add(Filters.eq((String)USER, (Object)regex));
            orList.add(Filters.eq((String)FULLNAME, (Object)regex));
            andList.add(Filters.or(orList));
        }
        List<Object> users = null;
        if (onlineUsers != null && !onlineUsers.isEmpty()) {
            Bson fetchOnlineUsers = Filters.in((String)USER, onlineUsers);
            ArrayList<Bson> clonedAndList = new ArrayList<Bson>(andList);
            clonedAndList.add(fetchOnlineUsers);
            query = Filters.and(clonedAndList);
            coll = this.db().getCollection("users");
            cursor = coll.find(query).limit(limit).cursor();
            users = new ArrayList();
            while (cursor.hasNext()) {
                doc = (Document)cursor.next();
                userBean = new UserBean();
                userBean.setName(doc.get((Object)USER).toString());
                prop = doc.get((Object)FULLNAME);
                userBean.setFullname(prop != null ? prop.toString() : EMPTY_STRING);
                prop = doc.get((Object)EMAIL);
                userBean.setEmail(prop != null ? prop.toString() : EMPTY_STRING);
                prop = doc.get((Object)STATUS);
                userBean.setStatus(prop != null ? prop.toString() : EMPTY_STRING);
                if (doc.get((Object)IS_ENABLED) != null) {
                    userBean.setEnabled(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE)));
                }
                if (doc.get((Object)IS_DELETED) != null) {
                    userBean.setDeleted(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_DELETED).toString(), (CharSequence)TRUE)));
                }
                if (doc.get((Object)IS_EXTERNAL) != null) {
                    userBean.setExternal(doc.get((Object)IS_EXTERNAL).toString());
                }
                users.add(userBean);
            }
        }
        List<Object> list = users = users == null ? new ArrayList() : users;
        if (!onlyOnlineUsers) {
            int usersLeft;
            int n = usersLeft = limit > 0 ? limit - users.size() : -1;
            if (usersLeft > 0 || limit >= 0 && users.isEmpty()) {
                int n2 = usersLeft = usersLeft > 0 ? usersLeft : limit;
                if (onlineUsers != null && !onlineUsers.isEmpty()) {
                    Bson escapeOnlineUsers = Filters.nin((String)USER, onlineUsers);
                    andList.add(escapeOnlineUsers);
                }
                query = Filters.and(andList);
                coll = this.db().getCollection("users");
                cursor = coll.find(query).limit(usersLeft).cursor();
                while (cursor.hasNext()) {
                    doc = (Document)cursor.next();
                    userBean = new UserBean();
                    userBean.setName(doc.get((Object)USER).toString());
                    prop = doc.get((Object)FULLNAME);
                    userBean.setFullname(prop != null ? prop.toString() : EMPTY_STRING);
                    prop = doc.get((Object)EMAIL);
                    userBean.setEmail(prop != null ? prop.toString() : EMPTY_STRING);
                    prop = doc.get((Object)STATUS);
                    userBean.setStatus(prop != null ? prop.toString() : EMPTY_STRING);
                    if (doc.get((Object)IS_ENABLED) != null) {
                        userBean.setEnabled(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE)));
                    }
                    if (doc.get((Object)IS_DELETED) != null) {
                        userBean.setDeleted(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_DELETED).toString(), (CharSequence)TRUE)));
                    }
                    if (doc.get((Object)IS_EXTERNAL) != null) {
                        userBean.setExternal(doc.get((Object)IS_EXTERNAL).toString());
                    }
                    users.add(userBean);
                }
            }
        }
        users = users.stream().filter(UserBean::isEnabledUser).collect(Collectors.toList());
        return users;
    }

    @Override
    public Long getUsersCount(String roomId, String filter) {
        return this.getUsersCount(roomId, filter, false);
    }

    @Override
    public Long getUsersCount(String roomId, String filter, boolean activeUsers) {
        ArrayList<Bson> orList;
        if (roomId == null && filter == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Bson> andList = new ArrayList<Bson>();
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            if (roomId.indexOf("space-") == 0) {
                roomId = roomId.substring("space-".length());
            } else if (roomId.indexOf("team-") == 0) {
                roomId = roomId.substring("team-".length());
            }
            orList = new ArrayList<Bson>();
            orList.add(Filters.eq((String)SPACES, (Object)roomId));
            orList.add(Filters.eq((String)TEAMS, (Object)roomId));
            andList.add(Filters.or(orList));
        }
        if (filter != null) {
            filter = filter.replace(" ", ".*");
            Pattern regex = Pattern.compile(filter, 2);
            ArrayList<Bson> orList2 = new ArrayList<Bson>();
            orList2.add(Filters.eq((String)USER, (Object)regex));
            orList2.add(Filters.eq((String)FULLNAME, (Object)regex));
            andList.add(Filters.or(orList2));
        }
        andList.add(Filters.eq((String)IS_DELETED, (Object)FALSE));
        if (activeUsers) {
            andList.add(Filters.eq((String)STATUS, (Object)"available"));
        }
        orList = new ArrayList();
        orList.add(Filters.eq((String)IS_ENABLED, (Object)TRUE));
        orList.add(Filters.eq((String)IS_ENABLED, (Object)true));
        andList.add(Filters.or(orList));
        Bson query = Filters.and(andList);
        MongoCollection coll = this.db().getCollection("users");
        return coll.find(query).cursor().available();
    }

    @Override
    public String setStatus(String user, String status) {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            doc.put(STATUS, (Object)status);
            coll.replaceOne(query, (Object)doc);
        } else {
            Document doc = new Document();
            doc.put(ID, (Object)user);
            doc.put(USER, (Object)user);
            doc.put(STATUS, (Object)status);
            coll.insertOne((Object)doc);
        }
        return status;
    }

    @Override
    public void setAsAdmin(String user, boolean isAdmin) {
        Bson query;
        MongoCollection coll = this.db().getCollection("users");
        MongoCursor cursor = coll.find(query = Filters.eq((String)USER, (Object)user)).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            doc.put(IS_SUPPORT_ADMIN, (Object)isAdmin);
            coll.replaceOne(query, (Object)doc);
        } else {
            Document doc = new Document();
            doc.put(ID, (Object)user);
            doc.put(USER, (Object)user);
            doc.put(IS_SUPPORT_ADMIN, (Object)isAdmin);
            coll.insertOne((Object)doc);
        }
    }

    @Override
    public boolean isAdmin(String user) {
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            Object isAdmin = doc.get((Object)IS_SUPPORT_ADMIN);
            return isAdmin != null && TRUE.equals(isAdmin.toString());
        }
        return false;
    }

    @Override
    public String getStatus(String user) {
        Document doc;
        String status = "none";
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        status = cursor.hasNext() ? ((doc = (Document)cursor.next()).containsKey((Object)STATUS) ? doc.get((Object)STATUS).toString() : this.setStatus(user, "available")) : this.setStatus(user, "available");
        return status;
    }

    @Override
    public String getUserFullName(String user) {
        Document doc;
        String fullname = null;
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext() && (doc = (Document)cursor.next()).get((Object)FULLNAME) != null) {
            fullname = doc.get((Object)FULLNAME).toString();
        }
        return fullname;
    }

    @Override
    public String getExternalValue(String user) {
        Document doc;
        String isExternal = null;
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext() && (doc = (Document)cursor.next()).get((Object)IS_EXTERNAL) != null) {
            isExternal = doc.get((Object)IS_EXTERNAL).toString();
        }
        return isExternal;
    }

    @Override
    public UserBean getUser(String user) {
        return this.getUser(user, false);
    }

    @Override
    public UserBean getUser(String user, boolean withFavorites) {
        UserBean userBean = new UserBean();
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)USER, (Object)user);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            userBean.setName(user);
            if (doc.get((Object)FULLNAME) != null) {
                userBean.setFullname(doc.get((Object)FULLNAME).toString());
            }
            if (doc.get((Object)EMAIL) != null) {
                userBean.setEmail(doc.get((Object)EMAIL).toString());
            }
            if (doc.get((Object)STATUS) != null) {
                userBean.setStatus(doc.get((Object)STATUS).toString());
            }
            if (doc.get((Object)IS_ENABLED) != null) {
                userBean.setEnabled(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE)));
            }
            if (doc.get((Object)IS_DELETED) != null) {
                userBean.setDeleted(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_DELETED).toString(), (CharSequence)TRUE)));
            }
            if (doc.get((Object)IS_EXTERNAL) != null) {
                userBean.setExternal(doc.get((Object)IS_EXTERNAL).toString());
            }
            if (withFavorites && doc.containsKey((Object)FAVORITES)) {
                userBean.setFavorites((List)doc.get((Object)FAVORITES));
            }
        }
        return userBean;
    }

    @Override
    public List<String> getUsersFilterBy(String user, String room, String type) {
        ArrayList<String> users = new ArrayList<String>();
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        if ("s".equals(type)) {
            query.put((Object)SPACES, (Object)room);
        } else {
            query.put((Object)TEAMS, (Object)room);
        }
        MongoCursor cursor = coll.find((Bson)query).cursor();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            String target = doc.get((Object)USER).toString();
            if (user != null && user.equals(target)) continue;
            users.add(target);
        }
        return users;
    }

    @Override
    public int getNumberOfUsers() {
        MongoCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        MongoCursor cursor = coll.find((Bson)query).cursor();
        return cursor.available();
    }
}

