/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.upgrade;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.SettingDataStorage;
import org.exoplatform.chat.services.mongodb.MongoBootstrap;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Named(value="favoritesMigrationService")
@ApplicationScoped
@Singleton
public class FavoritesMigrationService {
    private static final Log LOG = ExoLogger.getLogger(FavoritesMigrationService.class);
    private static final String SETTING_MIGRATION_STATUS = "upgrade-favorites";
    public static final String ID = "_id";
    public static final String FAVORITES = "favorites";
    public static final String USER = "user";
    @Inject
    private SettingDataStorage settingDataStorage;

    public void processMigration() {
        MongoBootstrap mongoBootstrap = ConnectionManager.getInstance();
        MongoDatabase db = mongoBootstrap.getDB();
        FavoritesMigrationStatus migrationStatus = this.getMigrationStatus();
        if (migrationStatus == null) {
            this.setMigrationStatus(FavoritesMigrationStatus.RUNNING);
            LOG.info((Object)"== Chat users favorites migration starting ==");
            MongoCollection usersCol = db.getCollection("users");
            long totalNbOfUsers = usersCol.countDocuments();
            LOG.info((Object)("  Chat users favorites migration - Nb of users to migrate : " + totalNbOfUsers));
            MongoCursor usersCursor = usersCol.find().cursor();
            int nbOfUsersProcessed = 0;
            while (usersCursor.hasNext()) {
                Document user = (Document)usersCursor.next();
                try {
                    this.migrateUserFavorites((MongoCollection<Document>)usersCol, user);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while migrating Chat favorites of user " + user.get((Object)USER) + " : " + e.getMessage()), (Throwable)e);
                }
                if (++nbOfUsersProcessed % 100 != 0 && (long)nbOfUsersProcessed != totalNbOfUsers) continue;
                LOG.info((Object)("  Chat users favorites migration - Progress : " + nbOfUsersProcessed + "/" + totalNbOfUsers));
            }
            this.setMigrationStatus(FavoritesMigrationStatus.DONE);
            LOG.info((Object)"== Chat users favorites migration done ==");
        }
    }

    public FavoritesMigrationStatus getMigrationStatus() {
        String status = this.settingDataStorage.getSetting(SETTING_MIGRATION_STATUS);
        if (status != null) {
            return FavoritesMigrationStatus.valueOf(status);
        }
        return null;
    }

    public void setMigrationStatus(FavoritesMigrationStatus status) {
        this.settingDataStorage.setSetting(SETTING_MIGRATION_STATUS, status.toString());
    }

    private void migrateUserFavorites(MongoCollection<Document> usersCol, Document user) {
        List favorites;
        if (user != null && (favorites = (List)user.get((Object)FAVORITES)) != null) {
            List<String> newFavorites = favorites.stream().filter(Objects::nonNull).map(oldFavorite -> {
                if (oldFavorite.startsWith("team-")) {
                    return oldFavorite.substring("team-".length());
                }
                if (oldFavorite.startsWith("space-")) {
                    return oldFavorite.substring("space-".length());
                }
                return ChatUtils.getRoomId(Arrays.asList((String)user.get((Object)USER), oldFavorite));
            }).toList();
            Bson searchQuery = Filters.eq((String)ID, (Object)user.get((Object)ID));
            Bson updateDocument = Updates.set((String)FAVORITES, newFavorites);
            usersCol.updateMany(searchQuery, updateDocument);
        }
    }

    static enum FavoritesMigrationStatus {
        RUNNING,
        DONE;

    }
}

