/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.exoplatform.chat.services.mongodb.utils.ConnectionHelper;
import org.exoplatform.chat.utils.PropertyManager;

public class MongoBootstrap {
    private MongoClient m;
    private MongoDatabase db;
    private static final Logger LOG = Logger.getLogger("MongoBootstrap");

    private MongoClient mongo() {
        if (this.m == null) {
            try {
                StringBuilder connectionString = new StringBuilder().append(ConnectionHelper.getMongoServerAdresses().stream().map(s -> s.getHost() + ":" + s.getPort()).collect(Collectors.joining(","))).append("/?").append("maxPoolSize=200").append("&").append("minPoolSize=10").append("&").append("connectTimeoutMS=60000").append("&").append("w=majority");
                boolean authenticate = "true".equals(PropertyManager.getProperty((String)"dbAuthentication")) && PropertyManager.getProperty((String)"dbPassword") != null && !PropertyManager.getProperty((String)"dbPassword").isEmpty();
                connectionString = authenticate ? new StringBuilder("mongodb://").append(PropertyManager.getProperty((String)"dbUser")).append(":").append(URLEncoder.encode(PropertyManager.getProperty((String)"dbPassword"), StandardCharsets.UTF_8)).append("@").append((CharSequence)connectionString).append("&authSource=").append(PropertyManager.getProperty((String)"adminDatabase")) : new StringBuilder("mongodb://").append((CharSequence)connectionString);
                if ("embed".equals(PropertyManager.getProperty((String)"dbServerType"))) {
                    LOG.warning("WE WILL NOW USE MONGODB IN EMBED MODE...");
                    LOG.warning("BE AWARE...");
                    LOG.warning("EMBED MODE SHOULD NEVER BE USED IN PRODUCTION!");
                }
                this.m = MongoClients.create((String)connectionString.toString());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error occur when get MongoDB server addresses .", e);
            }
        }
        return this.m;
    }

    public MongoDatabase getDB() {
        return this.getDB(null);
    }

    public MongoDatabase getDB(String dbName) {
        if (this.db == null || dbName != null) {
            this.db = dbName != null ? this.mongo().getDatabase(dbName) : this.mongo().getDatabase(PropertyManager.getProperty((String)"dbName"));
            this.initCollection("notifications");
            this.initCollection("rooms");
            this.initCollection("users");
            this.dropTokenCollectionIfExists();
        }
        return this.db;
    }

    public void initCappedCollection(String name, int size) {
        this.initCollection(name, true, size);
    }

    private void initCollection(String name) {
        this.initCollection(name, false, 0);
    }

    private void initCollection(String name, boolean isCapped, int size) {
        try {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"capped", (Object)isCapped);
            if (isCapped) {
                doc.put((Object)"size", (Object)size);
            }
            this.getDB().createCollection(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dropTokenCollectionIfExists() {
        this.getDB().getCollection("tokens").drop();
    }

    public void ensureIndexesInRoom(String type) {
        IndexOptions notUnique = new IndexOptions();
        notUnique.unique(false);
        notUnique.background(true);
        notUnique.name("roomId_1_timestamp_-1");
        MongoCollection roomsCollection = this.getDB().getCollection("messages_room_" + type);
        roomsCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"roomId"}), Indexes.descending((String[])new String[]{"timestamp"})}), notUnique);
        LOG.info("##### room index in messages_room_" + type);
    }

    public void ensureIndexes() {
        String[] roomTypes;
        String dbName = this.getDB().getName();
        LOG.info("### ensureIndexes in " + dbName);
        IndexOptions unique = new IndexOptions();
        unique.unique(true);
        unique.background(true);
        IndexOptions notUnique = new IndexOptions();
        notUnique.unique(false);
        notUnique.background(true);
        MongoCollection notifications = this.getDB().getCollection("notifications");
        notifications.dropIndexes();
        notifications.createIndex(Indexes.ascending((String[])new String[]{"user"}), notUnique.name("user_1"));
        notifications.createIndex(Indexes.ascending((String[])new String[]{"isRead"}), notUnique.name("isRead_1"));
        BasicDBObject index2 = new BasicDBObject();
        index2.put((Object)"user", (Object)1);
        index2.put((Object)"categoryId", (Object)1);
        index2.put((Object)"category", (Object)1);
        index2.put((Object)"type", (Object)1);
        notifications.createIndex((Bson)index2, notUnique.name("user_1_type_1_category_1_categoryId_1"));
        LOG.info("### notifications indexes in " + this.getDB().getName());
        MongoCollection rooms = this.getDB().getCollection("rooms");
        rooms.dropIndexes();
        rooms.createIndex(Indexes.ascending((String[])new String[]{"space"}), notUnique.name("space_1"));
        rooms.createIndex(Indexes.ascending((String[])new String[]{"users"}), notUnique.name("users_1"));
        rooms.createIndex(Indexes.ascending((String[])new String[]{"shortName"}), notUnique.name("shortName_1"));
        LOG.info("### rooms indexes in " + this.getDB().getName());
        for (String type : roomTypes = new String[]{"u", "s", "t", "e"}) {
            MongoCollection roomCollection = this.getDB().getCollection("messages_room_" + type);
            roomCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"roomId"}), Indexes.descending((String[])new String[]{"timestamp"})}), notUnique.name("roomId_1_timestamp_-1"));
            LOG.info("##### room index in " + type);
        }
        MongoCollection users = this.getDB().getCollection("users");
        users.dropIndexes();
        users.createIndex(Indexes.ascending((String[])new String[]{"token"}), notUnique.name("token_1"));
        users.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"user"}), Indexes.ascending((String[])new String[]{"token"})}), unique.name("user_1_token_1"));
        index2 = new BasicDBObject();
        index2.put((Object)"user", (Object)1);
        index2.put((Object)"validity", (Object)-1);
        users.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"user"}), Indexes.descending((String[])new String[]{"validity"})}), unique.name("user_1_validity_m1"));
        users.createIndex(Indexes.ascending((String[])new String[]{"user"}), unique.name("user_1"));
        users.createIndex(Indexes.ascending((String[])new String[]{"spaces"}), notUnique.name("spaces_1"));
        LOG.info("### users indexes in " + this.getDB().getName());
        LOG.info("### Indexes creation completed in " + this.getDB().getName());
    }
}

