/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.services.TokenService;

public class ChatAuthenticationFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(ChatAuthenticationFilter.class.getName());
    @Inject
    private TokenService tokenService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
            ChatHttpServletRequestWrapper wrappedRequest = new ChatHttpServletRequestWrapper(request, authorizationHeader.substring("Bearer ".length()));
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    public class ChatHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private String PARAM_NAME_TOKEN;
        private String token;

        public ChatHttpServletRequestWrapper(HttpServletRequest request, String token) {
            super(request);
            this.PARAM_NAME_TOKEN = "token";
            this.token = token;
        }

        public String getParameter(String name) {
            if ("token".equals(name)) {
                return this.token;
            }
            return super.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(super.getParameterMap());
            parameterMap.put(this.PARAM_NAME_TOKEN, new String[]{this.token});
            return parameterMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getParameterMap().keySet());
        }

        public String getQueryString() {
            Object queryString = super.getQueryString();
            queryString = StringUtils.isNotEmpty((CharSequence)queryString) ? (String)queryString + "&" + this.PARAM_NAME_TOKEN + "=" + this.token : this.PARAM_NAME_TOKEN + "=" + this.token;
            return queryString;
        }
    }
}

