/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.services.ChatDataStorage;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChatTestCase
extends AbstractChatTestCase {
    @Before
    public void setUp() {
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = ServiceBootstrap.getChatService().getRoom(users);
        String roomType = ServiceBootstrap.getChatService().getTypeRoomChat(roomId);
        ConnectionManager.getInstance().getDB().getCollection("messages_room_" + roomType).drop();
        users = new ArrayList();
        users.add("benjamin");
        users.add("mary");
        roomId = ServiceBootstrap.getChatService().getRoom(users);
        roomType = ServiceBootstrap.getChatService().getTypeRoomChat(roomId);
        ConnectionManager.getInstance().getDB().getCollection("messages_room_" + roomType).drop();
        ConnectionManager.getInstance().getDB().getCollection("rooms").drop();
        ConnectionManager.getInstance().getDB().getCollection("users").drop();
        UserService userService = ServiceBootstrap.getUserService();
        userService.addUserFullName("benjamin", "Benjamin Paillereau");
        userService.addUserEmail("benjamin", "bpaillereau@exoplatform.com");
        userService.addUserFullName("john", "John Smith");
        userService.addUserEmail("john", "john@exoplatform.com");
        userService.addUserFullName("mary", "Mary Williams");
        userService.addUserEmail("mary", "mary@exoplatform.com");
        userService.addUserFullName("james", "James Potter");
        userService.addUserEmail("james", "james@exoplatform.com");
    }

    @Test
    public void testGetRoom() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = chatService.getRoom(users);
        users = new ArrayList();
        users.add("john");
        users.add("benjamin");
        String roomId2 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("mary");
        String roomId3 = chatService.getRoom(users);
        String roomId4 = chatService.getSpaceRoom("test-space");
        Assert.assertEquals((Object)roomId, (Object)roomId2);
        Assert.assertNotEquals((Object)roomId, (Object)roomId3);
        Assert.assertNotEquals((Object)roomId, (Object)roomId4);
    }

    @Test
    public void testGetRoomTeamById() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        String user = "Benjamin";
        String teamRoomName = "my team Room";
        String teamRoomId = chatService.getTeamRoom(teamRoomName, user);
        RoomBean teamRoom = chatService.getTeamRoomById(teamRoomId);
        Assert.assertEquals((String)"The room id should be the same", (Object)teamRoomId, (Object)teamRoom.getRoom());
        Assert.assertEquals((String)"The room name should be the same", (Object)teamRoomName, (Object)teamRoom.getFullName());
        Assert.assertEquals((String)"The room owner should be the same", (Object)user, (Object)teamRoom.getUser());
        Assert.assertTrue((String)"The room should be a team room", (boolean)teamRoom.getType().equals("t"));
        Assert.assertFalse((String)"The room should not be a space room", (boolean)teamRoom.getType().equals("s"));
    }

    @Test
    public void testTextFormatRead() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = chatService.getRoom(users);
        String resp = chatService.read("john", roomId, false, null);
        String json = "{\"room\": \"" + roomId + "\",\"messages\": []}";
        Assert.assertEquals((Object)json, (Object)resp);
        resp = chatService.read("john", roomId, true, null);
        String text = "no messages";
        Assert.assertEquals((Object)text, (Object)resp);
    }

    @Test
    public void testWriteText() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = chatService.getRoom(users);
        chatService.write("foo", "benjamin", roomId, "false");
        String resp = chatService.read("john", roomId, true, null);
        Assert.assertEquals((long)47L, (long)resp.length());
        Assert.assertTrue((boolean)resp.endsWith("] Benjamin Paillereau: foo\n"));
        chatService.write("bar", "john", roomId, "false");
        resp = chatService.read("benjamin", roomId, true, null);
        Assert.assertEquals((long)85L, (long)resp.length());
        Assert.assertTrue((boolean)resp.endsWith("] John Smith: bar\n"));
    }

    @Test
    public void testWriteTextInNonExistingRoom() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        String roomId = "nonexistingroomid";
        try {
            chatService.write("foo", "john", roomId, "false");
            Assert.fail((String)"Sending a message in a non existing room should fail");
        }
        catch (ChatException e) {
            Assert.assertEquals((long)403L, (long)e.getStatus());
        }
    }

    @Test
    public void testWriteJson() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = chatService.getRoom(users);
        chatService.write("foo", "benjamin", roomId, "false");
        String resp = chatService.read("john", roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)resp);
        String room = (String)jsonObject.get((Object)"room");
        Assert.assertEquals((Object)roomId, (Object)room);
        String timestamp = (String)jsonObject.get((Object)"timestamp");
        Assert.assertNotNull((Object)timestamp);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"messages");
        Assert.assertEquals((long)1L, (long)messages.size());
        chatService.write("bar", "john", roomId, "false");
        resp = chatService.read("benjamin", roomId);
        jsonObject = (JSONObject)JSONValue.parse((String)resp);
        messages = (JSONArray)jsonObject.get((Object)"messages");
        Assert.assertEquals((long)2L, (long)messages.size());
        String message = (String)((JSONObject)messages.get(0)).get((Object)"msg");
        Assert.assertEquals((Object)"bar", (Object)message);
        message = (String)((JSONObject)messages.get(1)).get((Object)"msg");
        Assert.assertEquals((Object)"foo", (Object)message);
        JSONObject msgJson = (JSONObject)messages.get(0);
        Assert.assertNotNull((Object)msgJson.get((Object)"msgId"));
        Assert.assertNotNull((Object)msgJson.get((Object)"timestamp"));
        Assert.assertNotNull((Object)msgJson.get((Object)"user"));
        Assert.assertNotNull((Object)msgJson.get((Object)"fullname"));
        Assert.assertNull((Object)msgJson.get((Object)"type"));
        Assert.assertNotNull((Object)msgJson.get((Object)"isSystem"));
    }

    @Test
    public void testEdit() throws Exception {
        ChatDataStorage chatDataStorage = ServiceBootstrap.getChatDataStorage();
        UserService userService = ServiceBootstrap.getUserService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = chatDataStorage.getRoom(users);
        chatDataStorage.write("foo", "benjamin", roomId, "false");
        String resp = chatDataStorage.read(roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)resp);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"messages");
        Assert.assertEquals((long)1L, (long)messages.size());
        String message = (String)((JSONObject)messages.get(0)).get((Object)"msg");
        String id = (String)((JSONObject)messages.get(0)).get((Object)"msgId");
        Assert.assertEquals((Object)"foo", (Object)message);
        chatDataStorage.edit(roomId, "benjamin", id, "bar");
        resp = chatDataStorage.read(roomId);
        jsonObject = (JSONObject)JSONValue.parse((String)resp);
        messages = (JSONArray)jsonObject.get((Object)"messages");
        Assert.assertEquals((long)1L, (long)messages.size());
        JSONObject msgJson = (JSONObject)messages.get(0);
        Assert.assertEquals((Object)id, (Object)msgJson.get((Object)"msgId"));
        Assert.assertEquals((Object)"bar", (Object)msgJson.get((Object)"msg"));
        Assert.assertEquals((Object)"EDITED", (Object)msgJson.get((Object)"type"));
    }

    @Test
    public void testDelete() throws Exception {
        ChatDataStorage chatDataStorage = ServiceBootstrap.getChatDataStorage();
        UserService userService = ServiceBootstrap.getUserService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId = chatDataStorage.getRoom(users);
        chatDataStorage.write("foo", "benjamin", roomId, "false");
        chatDataStorage.write("bar", "benjamin", roomId, "false");
        String resp = chatDataStorage.read(roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)resp);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"messages");
        Assert.assertEquals((long)2L, (long)messages.size());
        String id = (String)((JSONObject)messages.get(0)).get((Object)"msgId");
        chatDataStorage.delete(roomId, "benjamin", id);
        resp = chatDataStorage.read(roomId);
        jsonObject = (JSONObject)JSONValue.parse((String)resp);
        messages = (JSONArray)jsonObject.get((Object)"messages");
        Assert.assertEquals((long)2L, (long)messages.size());
        String id3 = (String)((JSONObject)messages.get(0)).get((Object)"msgId");
        String type3 = (String)((JSONObject)messages.get(0)).get((Object)"type");
        Assert.assertEquals((Object)id, (Object)id3);
        Assert.assertEquals((Object)"DELETED", (Object)type3);
    }

    @Test
    public void testGetExistingRooms() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        NotificationService notificationService = ServiceBootstrap.getNotificationService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId1 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("mary");
        chatService.getRoom(users);
        chatService.write("foo", "benjamin", roomId1, "false");
        List rooms = chatService.getExistingRooms("benjamin", false, false, notificationService, tokenService);
        Assert.assertEquals((long)2L, (long)rooms.size());
        rooms = chatService.getExistingRooms("john", false, false, notificationService, tokenService);
        Assert.assertEquals((long)1L, (long)rooms.size());
        rooms = chatService.getExistingRooms("mary", false, false, notificationService, tokenService);
        Assert.assertEquals((long)1L, (long)rooms.size());
        rooms = chatService.getExistingRooms("james", false, false, notificationService, tokenService);
        Assert.assertEquals((long)0L, (long)rooms.size());
    }

    @Test
    public void testGetUserRooms() throws Exception {
        String user = "benjamin";
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        NotificationService notificationService = ServiceBootstrap.getNotificationService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId1 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("mary");
        String roomId2 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("james");
        String roomId3 = chatService.getRoom(users);
        List spaces = ServiceBootstrap.getUserService().getSpaces("benjamin");
        SpaceBean space = new SpaceBean();
        space.setDisplayName("Test Space");
        space.setGroupId("test_space");
        space.setId("test_space");
        space.setShortName("Test Space");
        space.setPrettyName("test space");
        space.setTimestamp(System.currentTimeMillis());
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces("john", spaces);
        SpaceBean space2 = new SpaceBean();
        space2.setDisplayName("Test Space 2");
        space2.setGroupId("test_space_2");
        space2.setId("test_space_2");
        space2.setShortName("Test Space 2");
        space2.setPrettyName("Test space 2");
        space2.setTimestamp(System.currentTimeMillis());
        spaces.add(space2);
        ServiceBootstrap.getUserService().setSpaces(user, spaces);
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user);
        String room2 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team 1", user);
        String room3 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team 2", user);
        ServiceBootstrap.getUserService().addTeamRoom(user, room1);
        ServiceBootstrap.getUserService().addTeamRoom(user, room2);
        ServiceBootstrap.getUserService().addTeamRoom(user, room3);
        RoomsBean roomsBean = ServiceBootstrap.getChatDataStorage().getUserRooms("benjamin", new ArrayList(), null, 0, 20, notificationService, tokenService);
        Assert.assertEquals((String)"Should have 8 rooms", (long)8L, (long)roomsBean.getRooms().size());
        int teamsRooms = 0;
        int spacesRooms = 0;
        int usersRooms = 0;
        for (RoomBean room : roomsBean.getRooms()) {
            if ("t".equals(room.getType())) {
                ++teamsRooms;
                continue;
            }
            if ("s".equals(room.getType())) {
                ++spacesRooms;
                continue;
            }
            ++usersRooms;
        }
        Assert.assertEquals((long)spacesRooms, (long)2L);
        Assert.assertEquals((long)teamsRooms, (long)3L);
        Assert.assertEquals((long)usersRooms, (long)3L);
        roomsBean = ServiceBootstrap.getChatDataStorage().getUserRooms("benjamin", new ArrayList(), null, 0, 3, notificationService, tokenService);
        Assert.assertEquals((long)3L, (long)roomsBean.getRooms().size());
        roomsBean = ServiceBootstrap.getChatDataStorage().getUserRooms("benjamin", new ArrayList(), null, 3, 3, notificationService, tokenService);
        Assert.assertEquals((long)3L, (long)roomsBean.getRooms().size());
        roomsBean = ServiceBootstrap.getChatDataStorage().getUserRooms("benjamin", new ArrayList(), null, 6, 3, notificationService, tokenService);
        Assert.assertEquals((long)2L, (long)roomsBean.getRooms().size());
    }

    @Test
    public void testGetRooms() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        NotificationService notificationService = ServiceBootstrap.getNotificationService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId1 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("mary");
        String roomId2 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("james");
        String roomId3 = chatService.getRoom(users);
        chatService.write("foo", "benjamin", roomId1, "false");
        chatService.write("bar", "john", roomId1, "false");
        chatService.write("foo", "benjamin", roomId2, "false");
        chatService.write("bar", "mary", roomId2, "false");
        chatService.write("foo", "benjamin", roomId3, "false");
        chatService.write("bar", "james", roomId3, "false");
        List spaces = ServiceBootstrap.getUserService().getSpaces("benjamin");
        SpaceBean space = new SpaceBean();
        space.setDisplayName("Test Space");
        space.setGroupId("test_space");
        space.setId("test_space");
        space.setShortName("Test Space");
        space.setPrettyName("test space");
        space.setTimestamp(System.currentTimeMillis());
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces("john", spaces);
        SpaceBean space2 = new SpaceBean();
        space2.setDisplayName("Test Space 2");
        space2.setGroupId("test_space_2");
        space2.setId("test_space_2");
        space2.setShortName("Test Space 2");
        space2.setPrettyName("Test space 2");
        space2.setTimestamp(System.currentTimeMillis());
        spaces.add(space2);
        ServiceBootstrap.getUserService().setSpaces("benjamin", spaces);
        String spaceId1 = chatService.getSpaceRoom("test_space");
        chatService.write("foo", "benjamin", spaceId1, "false");
        String spaceId2 = chatService.getSpaceRoom("test_space_2");
        chatService.write("foo", "benjamin", spaceId2, "false");
        RoomsBean roomsBenAll = chatService.getRooms("benjamin", null, true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsMaryAll = chatService.getRooms("mary", null, true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenUsers = chatService.getRooms("benjamin", null, true, false, false, true, false, notificationService, tokenService);
        RoomsBean roomsMaryUsers = chatService.getRooms("mary", null, true, false, false, true, false, notificationService, tokenService);
        RoomsBean roomsMarySpaces = chatService.getRooms("mary", null, false, true, false, false, false, notificationService, tokenService);
        Thread.sleep(110L);
        RoomsBean roomsBenOffline = chatService.getRooms("benjamin", null, true, false, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenOnline = chatService.getRooms("benjamin", null, true, false, false, false, false, notificationService, tokenService);
        Assert.assertEquals((long)5L, (long)roomsBenAll.getRooms().size());
        Assert.assertEquals((long)3L, (long)roomsBenUsers.getRooms().size());
        Assert.assertEquals((long)3L, (long)roomsBenOffline.getRooms().size());
        Assert.assertEquals((long)0L, (long)roomsBenOnline.getRooms().size());
        Assert.assertEquals((long)1L, (long)roomsMaryAll.getRooms().size());
        Assert.assertEquals((long)0L, (long)roomsMarySpaces.getRooms().size());
        Assert.assertEquals((long)1L, (long)roomsMaryUsers.getRooms().size());
    }

    @Test
    public void testGetRoomsFiltered() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        NotificationService notificationService = ServiceBootstrap.getNotificationService();
        ArrayList<String> users = new ArrayList<String>();
        users.add("benjamin");
        users.add("john");
        String roomId1 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("mary");
        String roomId2 = chatService.getRoom(users);
        users = new ArrayList();
        users.add("benjamin");
        users.add("james");
        String roomId3 = chatService.getRoom(users);
        chatService.write("foo", "benjamin", roomId1, "false");
        chatService.write("bar", "john", roomId1, "false");
        chatService.write("foo", "benjamin", roomId2, "false");
        chatService.write("bar", "mary", roomId2, "false");
        chatService.write("foo", "benjamin", roomId3, "false");
        chatService.write("bar", "james", roomId3, "false");
        List spaces = ServiceBootstrap.getUserService().getSpaces("benjamin");
        SpaceBean space = new SpaceBean();
        space.setDisplayName("Test Space");
        space.setGroupId("test_space");
        space.setId("test_space");
        space.setShortName("Test Space");
        space.setPrettyName("Test Space");
        space.setTimestamp(System.currentTimeMillis());
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces("john", spaces);
        SpaceBean space2 = new SpaceBean();
        space2.setDisplayName("Test Space 2");
        space2.setGroupId("test_space_2");
        space2.setId("test_space_2");
        space2.setShortName("Test Space 2");
        space2.setPrettyName("Test Space 2");
        space2.setTimestamp(System.currentTimeMillis());
        spaces.add(space2);
        ServiceBootstrap.getUserService().setSpaces("benjamin", spaces);
        String spaceId1 = chatService.getSpaceRoom("test_space");
        chatService.write("foo", "benjamin", spaceId1, "false");
        String spaceId2 = chatService.getSpaceRoom("test_space_2");
        chatService.write("foo", "benjamin", spaceId2, "false");
        RoomsBean roomsBenAll = chatService.getRooms("benjamin", null, true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenTest = chatService.getRooms("benjamin", "Test", true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenTeSp = chatService.getRooms("benjamin", "Te Sp", true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenTeSpe = chatService.getRooms("benjamin", "Te Spe", true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenJohn = chatService.getRooms("benjamin", "john", true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenJo = chatService.getRooms("benjamin", "Jo", true, true, false, true, false, notificationService, tokenService);
        RoomsBean roomsBenMaWi = chatService.getRooms("benjamin", "Ma Wi", true, true, false, true, false, notificationService, tokenService);
        Thread.sleep(110L);
        Assert.assertEquals((long)5L, (long)roomsBenAll.getRooms().size());
        Assert.assertEquals((long)2L, (long)roomsBenTest.getRooms().size());
        Assert.assertEquals((long)2L, (long)roomsBenTeSp.getRooms().size());
        Assert.assertEquals((long)0L, (long)roomsBenTeSpe.getRooms().size());
        Assert.assertEquals((long)1L, (long)roomsBenJohn.getRooms().size());
        Assert.assertEquals((long)1L, (long)roomsBenJo.getRooms().size());
        Assert.assertEquals((long)1L, (long)roomsBenMaWi.getRooms().size());
    }

    @Test
    public void testSetRoomNotificationTrigger() throws Exception {
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        NotificationService notificationService = ServiceBootstrap.getNotificationService();
        ArrayList<String> users = new ArrayList<String>();
        String benjamin = "benjamin";
        String john = "john";
        String normal = "normal";
        users.add(benjamin);
        users.add(john);
        String roomId1 = chatService.getRoom(users);
        userService.setRoomNotificationTrigger(benjamin, roomId1, "", normal, 1000L);
        userService.setRoomNotificationTrigger(benjamin, roomId1, "", "silence", 500L);
        NotificationSettingsBean userDNS = userService.getUserDesktopNotificationSettings(benjamin);
        Assert.assertNotNull((Object)userDNS);
        Assert.assertTrue((boolean)(userDNS instanceof NotificationSettingsBean));
    }
}

