/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.client.MongoDatabase;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TokenMongoServiceTest
extends AbstractChatTestCase {
    private MongoDatabase db;
    private UserService userService;
    private ChatService chatService;
    private TokenService tokenService;

    @Before
    public void setUp() {
        this.db = ConnectionManager.getInstance().getDB();
        this.db.getCollection("users").drop();
        this.db.getCollection("settings").drop();
    }

    @Test
    public void testGetActiveUsersFilterBy() {
        this.userService = ServiceBootstrap.getUserService();
        this.chatService = ServiceBootstrap.getChatService();
        this.tokenService = ServiceBootstrap.getTokenService();
        this.userService.addUserFullName("john", "jhon");
        ArrayList<CallSite> onlineUsers = new ArrayList<CallSite>();
        for (int i = 1; i <= 35; ++i) {
            String userId = "john" + i;
            this.userService.addUserFullName(userId, userId);
            this.userService.setStatus(userId, "available");
            String tokenId = this.tokenService.getToken(userId);
            this.tokenService.addUser(userId, tokenId);
            onlineUsers.add((CallSite)((Object)userId));
            ArrayList<Object> users = new ArrayList<Object>();
            users.add("john");
            users.add(userId);
            String roomId = this.chatService.getRoom(users);
            this.chatService.write("foo", userId, roomId, "false");
        }
        Map availableUsers = this.tokenService.getActiveUsersFilterBy("john", onlineUsers, true, true, false, 30);
        Assert.assertEquals((String)"should be 30", (long)30L, (long)availableUsers.size());
    }
}

