/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.PropertyManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserTestCase
extends AbstractChatTestCase {
    String username = "benjamin";

    @Before
    public void setUp() {
        ConnectionManager.getInstance().getDB().getCollection("users").drop();
    }

    @Test
    public void testIsEmbed() throws Exception {
        log.info("UserTestCase.testIsEmbed");
        String connexion = "embed";
        String serverType = PropertyManager.getProperty((String)"dbServerType");
        Assert.assertTrue((boolean)serverType.equals(connexion));
    }

    @Test
    public void testToken() throws Exception {
        log.info("UserTestCase.testToken");
        String token = ServiceBootstrap.getTokenService().getToken(this.username);
        boolean hasToken = ServiceBootstrap.getTokenService().hasUserWithToken(this.username, token);
        Assert.assertFalse((boolean)hasToken);
        ServiceBootstrap.getTokenService().addUser(this.username, token);
        Assert.assertTrue((boolean)ServiceBootstrap.getTokenService().hasUserWithToken(this.username, token));
    }

    @Test
    public void testUserCreation() throws Exception {
        log.info("UserTestCase.testUserCreation");
        String fullname = ServiceBootstrap.getUserService().getUserFullName(this.username);
        Assert.assertNull((Object)fullname);
        ServiceBootstrap.getUserService().addUserFullName(this.username, "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserEmail(this.username, "bpaillereau@exoplatform.com");
        UserBean user = ServiceBootstrap.getUserService().getUser(this.username);
        Assert.assertEquals((Object)"Benjamin Paillereau", (Object)user.getFullname());
        Assert.assertEquals((Object)"bpaillereau@exoplatform.com", (Object)user.getEmail());
        ServiceBootstrap.getUserService().setAsAdmin(this.username, false);
        Assert.assertFalse((boolean)ServiceBootstrap.getUserService().isAdmin(this.username));
        Assert.assertEquals((long)1L, (long)ServiceBootstrap.getUserService().getNumberOfUsers());
        String token = ServiceBootstrap.getTokenService().getToken("john");
        ServiceBootstrap.getTokenService().addUser("john", token);
        ServiceBootstrap.getUserService().addUserFullName("john", "John Smith");
        token = ServiceBootstrap.getTokenService().getToken("mary");
        ServiceBootstrap.getTokenService().addUser("mary", token);
        ServiceBootstrap.getUserService().addUserFullName("mary", "Mary Williams");
        token = ServiceBootstrap.getTokenService().getToken("james");
        ServiceBootstrap.getTokenService().addUser("james", token);
        ServiceBootstrap.getUserService().addUserFullName("james", "James Potter");
        Assert.assertEquals((long)4L, (long)ServiceBootstrap.getUserService().getNumberOfUsers());
    }

    @Test
    public void testDeleteAndSetEnabledUser() throws Exception {
        log.info("UserTestCase.testGetUsersWithDeletedAndDisabledUsers");
        String fullname = ServiceBootstrap.getUserService().getUserFullName(this.username);
        Assert.assertNull((Object)fullname);
        ServiceBootstrap.getUserService().addUserFullName(this.username, "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserEmail(this.username, "bpaillereau@exoplatform.com");
        String token = ServiceBootstrap.getTokenService().getToken("test1");
        ServiceBootstrap.getTokenService().addUser("test1", token);
        ServiceBootstrap.getUserService().addUserFullName("test1", "Test A");
        token = ServiceBootstrap.getTokenService().getToken("test2");
        ServiceBootstrap.getTokenService().addUser("test2", token);
        ServiceBootstrap.getUserService().addUserFullName("test2", "Test B");
        token = ServiceBootstrap.getTokenService().getToken("test3");
        ServiceBootstrap.getTokenService().addUser("test3", token);
        ServiceBootstrap.getUserService().addUserFullName("test3", "Test C");
        int nbUsers = ServiceBootstrap.getUserService().getUsers("", false).size();
        Assert.assertEquals((long)4L, (long)nbUsers);
        UserBean userBean = ServiceBootstrap.getUserService().getUser("test1");
        Assert.assertTrue((boolean)userBean.isEnabled());
        Assert.assertTrue((userBean.isDeleted() == false ? 1 : 0) != 0);
        userBean = ServiceBootstrap.getUserService().getUser("test2");
        Assert.assertTrue((boolean)userBean.isEnabled());
        Assert.assertTrue((userBean.isDeleted() == false ? 1 : 0) != 0);
        userBean = ServiceBootstrap.getUserService().getUser("test3");
        Assert.assertTrue((boolean)userBean.isEnabled());
        Assert.assertTrue((userBean.isDeleted() == false ? 1 : 0) != 0);
        ServiceBootstrap.getUserService().deleteUser("test3");
        userBean = ServiceBootstrap.getUserService().getUser("test3");
        Assert.assertTrue((userBean.isEnabled() == false ? 1 : 0) != 0);
        Assert.assertTrue((boolean)userBean.isDeleted());
        ServiceBootstrap.getUserService().setEnabledUser("test2", Boolean.valueOf(false));
        userBean = ServiceBootstrap.getUserService().getUser("test2");
        Assert.assertTrue((userBean.isEnabled() == false ? 1 : 0) != 0);
        Assert.assertTrue((userBean.isDeleted() == false ? 1 : 0) != 0);
        ServiceBootstrap.getUserService().setEnabledUser("test2", Boolean.valueOf(true));
        userBean = ServiceBootstrap.getUserService().getUser("test2");
        Assert.assertTrue((boolean)userBean.isEnabled());
        Assert.assertTrue((userBean.isDeleted() == false ? 1 : 0) != 0);
    }

    @Test
    public void testGetUsers() throws Exception {
        log.info("UserTestCase.testGetUsers");
        String fullname = ServiceBootstrap.getUserService().getUserFullName(this.username);
        Assert.assertNull((Object)fullname);
        ServiceBootstrap.getUserService().addUserFullName(this.username, "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserEmail(this.username, "bpaillereau@exoplatform.com");
        String token = ServiceBootstrap.getTokenService().getToken("john");
        ServiceBootstrap.getTokenService().addUser("john", token);
        ServiceBootstrap.getUserService().addUserFullName("john", "John Smith");
        token = ServiceBootstrap.getTokenService().getToken("mary");
        ServiceBootstrap.getTokenService().addUser("mary", token);
        ServiceBootstrap.getUserService().addUserFullName("mary", "Mary Williams");
        token = ServiceBootstrap.getTokenService().getToken("james");
        ServiceBootstrap.getTokenService().addUser("james", token);
        ServiceBootstrap.getUserService().addUserFullName("james", "James Potter");
        int nbUsers = ServiceBootstrap.getUserService().getUsers("", false).size();
        Assert.assertEquals((long)4L, (long)nbUsers);
        int nbJ = ServiceBootstrap.getUserService().getUsers("j", false).size();
        Assert.assertEquals((long)3L, (long)nbJ);
        int nbJame = ServiceBootstrap.getUserService().getUsers("jame", false).size();
        Assert.assertEquals((long)1L, (long)nbJame);
        int nbBePa = ServiceBootstrap.getUserService().getUsers("be pa", false).size();
        Assert.assertEquals((long)1L, (long)nbBePa);
        int nbBePaUC = ServiceBootstrap.getUserService().getUsers("BE PA", false).size();
        Assert.assertEquals((long)1L, (long)nbBePaUC);
    }

    @Test
    public void testGetUsersWithDeletedAndDisabledUsers() throws Exception {
        log.info("UserTestCase.testGetUsersWithDeletedAndDisabledUsers");
        String fullname = ServiceBootstrap.getUserService().getUserFullName(this.username);
        Assert.assertNull((Object)fullname);
        ServiceBootstrap.getUserService().addUserFullName(this.username, "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserEmail(this.username, "bpaillereau@exoplatform.com");
        ServiceBootstrap.getUserService().setEnabledUser(this.username, Boolean.valueOf(true));
        String token = ServiceBootstrap.getTokenService().getToken("test1");
        ServiceBootstrap.getTokenService().addUser("test1", token);
        ServiceBootstrap.getUserService().addUserFullName("test1", "Test A");
        token = ServiceBootstrap.getTokenService().getToken("test2");
        ServiceBootstrap.getTokenService().addUser("test2", token);
        ServiceBootstrap.getUserService().addUserFullName("test2", "Test B");
        token = ServiceBootstrap.getTokenService().getToken("test3");
        ServiceBootstrap.getTokenService().addUser("test3", token);
        ServiceBootstrap.getUserService().addUserFullName("test3", "Test C");
        token = ServiceBootstrap.getTokenService().getToken("test4");
        ServiceBootstrap.getTokenService().addUser("test4", token);
        ServiceBootstrap.getUserService().addUserFullName("test4", "Test D");
        int nbUsers = ServiceBootstrap.getUserService().getUsers("", false).size();
        Assert.assertEquals((long)5L, (long)nbUsers);
        List userBeans = ServiceBootstrap.getUserService().getUsers(null, "te", 20);
        Assert.assertEquals((long)4L, (long)userBeans.size());
        long usersCount = ServiceBootstrap.getUserService().getUsersCount(null, "te");
        Assert.assertEquals((long)4L, (long)usersCount);
        ServiceBootstrap.getUserService().deleteUser("test3");
        userBeans = ServiceBootstrap.getUserService().getUsers(null, "te", 20);
        ArrayList userNames = new ArrayList();
        userBeans.forEach(userBean -> userNames.add(userBean.getName()));
        Assert.assertEquals((long)3L, (long)userNames.size());
        usersCount = ServiceBootstrap.getUserService().getUsersCount(null, "te");
        Assert.assertEquals((long)3L, (long)usersCount);
        Assert.assertFalse((boolean)userNames.contains("test3"));
        ServiceBootstrap.getUserService().setEnabledUser("test4", Boolean.valueOf(false));
        userBeans = ServiceBootstrap.getUserService().getUsers(null, "te", 20);
        userNames.clear();
        userBeans.forEach(userBean -> userNames.add(userBean.getName()));
        Assert.assertEquals((long)2L, (long)userNames.size());
        usersCount = ServiceBootstrap.getUserService().getUsersCount(null, "te");
        Assert.assertEquals((long)2L, (long)usersCount);
        Assert.assertFalse((boolean)userNames.contains("test4"));
    }

    @Test
    public void testDemoUser() throws Exception {
        log.info("UserTestCase.testDemoUser");
        ServiceBootstrap.getUserService().addUserFullName(this.username, "Benjamin Paillereau");
        Assert.assertFalse((boolean)ServiceBootstrap.getTokenService().isDemoUser(this.username));
    }

    @Test
    public void testFavorites() throws Exception {
        log.info("UserTestCase.testFavorites");
        ServiceBootstrap.getUserService().addUserFullName(this.username, "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserFullName("john", "John Smith");
        ServiceBootstrap.getUserService().addUserFullName("mary", "Mary Williams");
        Assert.assertFalse((boolean)ServiceBootstrap.getUserService().isFavorite(this.username, "john"));
        ServiceBootstrap.getUserService().toggleFavorite(this.username, "john");
        Assert.assertTrue((boolean)ServiceBootstrap.getUserService().isFavorite(this.username, "john"));
        Assert.assertFalse((boolean)ServiceBootstrap.getUserService().isFavorite(this.username, "mary"));
        ServiceBootstrap.getUserService().toggleFavorite(this.username, "john");
        Assert.assertFalse((boolean)ServiceBootstrap.getUserService().isFavorite(this.username, "john"));
        Assert.assertFalse((boolean)ServiceBootstrap.getUserService().isFavorite(this.username, "mary"));
        ServiceBootstrap.getUserService().toggleFavorite(this.username, "john");
        ServiceBootstrap.getUserService().toggleFavorite(this.username, "mary");
        UserBean user = ServiceBootstrap.getUserService().getUser(this.username);
        Assert.assertNull((Object)user.getFavorites());
        user = ServiceBootstrap.getUserService().getUser(this.username, true);
        Assert.assertEquals((long)2L, (long)user.getFavorites().size());
    }

    @Test
    public void testStatus() {
        log.info("UserTestCase.testStatus");
        UserService userService = ServiceBootstrap.getUserService();
        userService.addUserFullName(this.username, "Benjamin Paillereau");
        userService.addUserFullName("john", "John Smith");
        Assert.assertEquals((Object)"available", (Object)userService.getStatus(this.username));
        userService.setStatus(this.username, "donotdisturb");
        Assert.assertEquals((Object)"donotdisturb", (Object)userService.getStatus(this.username));
        Assert.assertEquals((Object)"available", (Object)userService.getStatus("john"));
        userService.setStatus(this.username, "away");
        Assert.assertEquals((Object)"away", (Object)userService.getStatus(this.username));
        userService.setStatus(this.username, "invisible");
        Assert.assertEquals((Object)"invisible", (Object)userService.getStatus(this.username));
    }

    @Test
    public void testAdmin() {
        log.info("UserTestCase.testAdmin");
        UserService userService = ServiceBootstrap.getUserService();
        userService.addUserFullName(this.username, "Benjamin Paillereau");
        userService.addUserFullName("john", "John Smith");
        Assert.assertFalse((boolean)userService.isAdmin(this.username));
        userService.setAsAdmin(this.username, true);
        Assert.assertTrue((boolean)userService.isAdmin(this.username));
    }
}

