/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb.utils;

import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.chat.services.mongodb.utils.ConnectionHelper;
import org.exoplatform.chat.utils.PropertyManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectionHelperTest {
    @Before
    public void before() {
        PropertyManager.forceReload();
    }

    @After
    public void after() {
        PropertyManager.forceReload();
        System.clearProperty("exo.dbServerHost");
        System.clearProperty("chat.dbServerPort");
        System.clearProperty("exo.dbServerHosts");
        System.clearProperty("chat.dbServerHosts");
    }

    @Test
    public void testDefaultProperties() throws Exception {
        List actual = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals((long)27017L, (long)((ServerAddress)actual.get(0)).getPort());
        Assert.assertEquals((Object)"localhost", (Object)((ServerAddress)actual.get(0)).getHost());
    }

    @Test
    public void testServerHostSystemProperties() throws Exception {
        System.setProperty("exo.dbServerHost", "127.0.0.1");
        System.setProperty("chat.dbServerPort", "27776");
        List actual = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals((long)27776L, (long)((ServerAddress)actual.get(0)).getPort());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((ServerAddress)actual.get(0)).getHost());
    }

    @Test
    public void testServerHostsExoSystemProperties() throws Exception {
        System.setProperty("exo.dbServerHosts", "localhost:4445,localhost:4449");
        ArrayList<ServerAddress> expectedReplicatSet = new ArrayList<ServerAddress>();
        expectedReplicatSet.add(new ServerAddress("localhost", 4445));
        expectedReplicatSet.add(new ServerAddress("localhost", 4449));
        List actualReplicatSet = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)expectedReplicatSet.size(), (long)actualReplicatSet.size());
        Assert.assertEquals(expectedReplicatSet, (Object)actualReplicatSet);
    }

    @Test
    public void testServerHostsSystemProperties() throws Exception {
        System.setProperty("chat.dbServerHosts", "127.0.0.1:4442,127.0.0.1:4443");
        ArrayList<ServerAddress> expectedReplicatSet = new ArrayList<ServerAddress>();
        expectedReplicatSet.add(new ServerAddress("127.0.0.1", 4442));
        expectedReplicatSet.add(new ServerAddress("127.0.0.1", 4443));
        List actualReplicatSet = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)expectedReplicatSet.size(), (long)actualReplicatSet.size());
        Assert.assertEquals(expectedReplicatSet, (Object)actualReplicatSet);
    }

    @Test
    public void dbServerHostTest() throws Exception {
        PropertyManager.overrideProperty((String)"dbServerPort", (String)"27775");
        PropertyManager.overrideProperty((String)"dbServerHost", (String)"localhost");
        PropertyManager.overrideProperty((String)"dbServerHosts", (String)"");
        List actual = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals((long)27775L, (long)((ServerAddress)actual.get(0)).getPort());
        Assert.assertEquals((Object)"localhost", (Object)((ServerAddress)actual.get(0)).getHost());
    }

    @Test
    public void dbServerHostsTest() throws Exception {
        PropertyManager.overrideProperty((String)"dbServerHosts", (String)"localhost:4445,localhost:4449");
        ArrayList<ServerAddress> expectedReplicatSet = new ArrayList<ServerAddress>();
        expectedReplicatSet.add(new ServerAddress("localhost", 4445));
        expectedReplicatSet.add(new ServerAddress("localhost", 4449));
        List actualReplicatSet = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)expectedReplicatSet.size(), (long)actualReplicatSet.size());
        Assert.assertEquals(expectedReplicatSet, (Object)actualReplicatSet);
    }

    public void dbServerHostsWithIP() throws Exception {
        PropertyManager.overrideProperty((String)"dbServerPort", (String)"2700");
        PropertyManager.overrideProperty((String)"dbServerHost", (String)"localhost");
        PropertyManager.overrideProperty((String)"dbServerHosts", (String)"localhost:4445,localhost:4449,192.172.168.10:27010");
        ArrayList<ServerAddress> expectedReplicatSet = new ArrayList<ServerAddress>();
        expectedReplicatSet.add(new ServerAddress("localhost", 4445));
        expectedReplicatSet.add(new ServerAddress("localhost", 4449));
        expectedReplicatSet.add(new ServerAddress("192.172.168.10", 27010));
        List actualReplicatSet = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)expectedReplicatSet.size(), (long)actualReplicatSet.size());
        Assert.assertEquals(expectedReplicatSet, (Object)actualReplicatSet);
    }

    @Test(expected=UnknownHostException.class)
    public void dbServerHostsWithIPFail() throws Exception {
        PropertyManager.overrideProperty((String)"dbServerHosts", (String)"localhost:4445,localhost:4449192.172.168.10:27010");
        ArrayList<ServerAddress> expectedReplicatSet = new ArrayList<ServerAddress>();
        expectedReplicatSet.add(new ServerAddress("localhost", 4445));
        expectedReplicatSet.add(new ServerAddress("localhost", 4449));
        expectedReplicatSet.add(new ServerAddress("192.172.168.10", 27010));
        List actualReplicatSet = ConnectionHelper.getMongoServerAdresses();
        Assert.assertEquals((long)expectedReplicatSet.size(), (long)actualReplicatSet.size());
    }

    @Test(expected=UnknownHostException.class)
    public void dbServerHostTestFail() throws Exception {
        PropertyManager.overrideProperty((String)"dbServerPort", (String)"27xxx");
        PropertyManager.overrideProperty((String)"dbServerHost", (String)"localhost");
        PropertyManager.overrideProperty((String)"dbServerHosts", (String)"");
        ConnectionHelper.getMongoServerAdresses();
    }
}

