/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.server.ChatServer;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@Ignore
@RunWith(value=MockitoJUnitRunner.class)
public class ChatServerTest
extends AbstractChatTestCase {
    private static final String SPACE_GROUP_ID = "/spaces/myspace";
    private static final String SPACE_NAME = "My Space";
    private static final String SPACE_ROOM_ID = "myspace";
    private static final String JOHN_SMITH = "John Smith";
    private static final String MESSAGE = "my message";
    private static final String MODIFIED_MESSAGE = "my new message";
    private static final String MY_TEAM_ROOM = "myteam";
    private static final String MARY = "mary";
    private static final String JOHN = "john";
    private static final String JAMES = "james";
    private static final String FALSE_STRING = "false";
    @Mock
    HttpServletRequest request;
    @Mock
    HttpServletResponse response;
    @Mock
    ServletOutputStream responseOutputStream;
    String content;

    @Before
    public void setup() {
        this.content = null;
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.responseOutputStream);
        ((ServletOutputStream)Mockito.doAnswer(invocation -> {
            byte[] bytes = (byte[])invocation.getArgument(0);
            this.content = new String(bytes);
            return null;
        }).when((Object)this.responseOutputStream)).write((byte[])ArgumentMatchers.any());
    }

    @Test
    public void testReadMessageWhenMemberOfTheUserRoom() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(MARY);
        users.add(JOHN);
        String roomId = chatService.getRoom(users);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("fromTimestamp")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("toTimestamp")).thenReturn(null);
        chatServer.read(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void testReadMessageWhenNotMemberOfTheUserRoom() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(MARY);
        users.add(JOHN);
        String roomId = chatService.getRoom(users);
        String token = tokenService.getToken(JAMES);
        tokenService.addUser(JAMES, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JAMES);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("fromTimestamp")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("toTimestamp")).thenReturn(null);
        chatServer.read(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(401);
    }

    @Test
    public void testReadMessageWhenMemberOfTheTeamRoom() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(JOHN);
        users.add(MARY);
        String roomId = chatService.getTeamRoom(MY_TEAM_ROOM, JOHN);
        userService.addTeamUsers(roomId, users);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("fromTimestamp")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("toTimestamp")).thenReturn(null);
        chatServer.read(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void testReadMessageWhenNotMemberOfTheTeamRoom() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(JOHN);
        users.add(MARY);
        String roomId = chatService.getTeamRoom(MY_TEAM_ROOM, JOHN);
        userService.addTeamUsers(roomId, users);
        String token = tokenService.getToken(JAMES);
        tokenService.addUser(JAMES, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JAMES);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("fromTimestamp")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("toTimestamp")).thenReturn(null);
        chatServer.read(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(401);
    }

    @Test
    public void testReadMessageWhenMemberOfTheSpaceRoom() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        SpaceBean mySpace = new SpaceBean();
        mySpace.setId(SPACE_ROOM_ID);
        mySpace.setGroupId(SPACE_GROUP_ID);
        mySpace.setDisplayName(SPACE_NAME);
        mySpace.setRoom(SPACE_ROOM_ID);
        userService.setSpaces(JOHN, Collections.singletonList(mySpace));
        userService.setSpaces(MARY, Collections.singletonList(mySpace));
        String roomId = chatService.getSpaceRoom(SPACE_ROOM_ID);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("fromTimestamp")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("toTimestamp")).thenReturn(null);
        chatServer.read(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void testReadMessageWhenNotMemberOfTheSpaceRoom() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        SpaceBean mySpace = new SpaceBean();
        mySpace.setId(SPACE_ROOM_ID);
        mySpace.setGroupId(SPACE_GROUP_ID);
        mySpace.setDisplayName(SPACE_NAME);
        mySpace.setRoom(SPACE_ROOM_ID);
        userService.setSpaces(JOHN, Collections.singletonList(mySpace));
        userService.setSpaces(MARY, Collections.singletonList(mySpace));
        String roomId = chatService.getSpaceRoom(SPACE_ROOM_ID);
        String token = tokenService.getToken(JAMES);
        tokenService.addUser(JAMES, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JAMES);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("fromTimestamp")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("toTimestamp")).thenReturn(null);
        chatServer.read(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(401);
    }

    @Test
    public void testEditMessageWhenAuthorOfTheMessage() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(MARY);
        users.add(JOHN);
        String roomId = chatService.getRoom(users);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        chatService.write(MESSAGE, JOHN, roomId, FALSE_STRING);
        String jsonMessages = chatService.read(MARY, roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)jsonMessages);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"message");
        JSONObject message = (JSONObject)messages.get(0);
        String messageId = (String)message.get((Object)"id");
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("messageId")).thenReturn((Object)messageId);
        Mockito.when((Object)this.request.getParameter("message")).thenReturn((Object)MODIFIED_MESSAGE);
        chatServer.edit(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
        MessageBean messageBean = chatService.getMessage(roomId, messageId);
        Assert.assertNotNull((Object)messageBean);
        Assert.assertEquals((Object)MODIFIED_MESSAGE, (Object)messageBean.getMessage());
    }

    @Test
    public void testEditMessageWhenNotAuthorOfTheMessage() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(MARY);
        users.add(JOHN);
        String roomId = chatService.getRoom(users);
        String tokenJohn = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, tokenJohn);
        String tokenJames = tokenService.getToken(JAMES);
        tokenService.addUser(JAMES, tokenJames);
        chatService.write(MESSAGE, JOHN, roomId, FALSE_STRING);
        String jsonMessages = chatService.read(MARY, roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)jsonMessages);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"messages");
        JSONObject message = (JSONObject)messages.get(0);
        String messageId = (String)message.get((Object)"id");
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JAMES);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)tokenJames);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("messageId")).thenReturn((Object)messageId);
        Mockito.when((Object)this.request.getParameter("message")).thenReturn((Object)MODIFIED_MESSAGE);
        chatServer.edit(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(404);
        MessageBean messageBean = chatService.getMessage(roomId, messageId);
        Assert.assertNotNull((Object)messageBean);
        Assert.assertEquals((Object)MESSAGE, (Object)messageBean.getMessage());
    }

    @Test
    public void testDeleteMessageWhenAuthorOfTheMessage() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(MARY);
        users.add(JOHN);
        String roomId = chatService.getRoom(users);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        chatService.write(MESSAGE, JOHN, roomId, FALSE_STRING);
        String jsonMessages = chatService.read(MARY, roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)jsonMessages);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"messages");
        JSONObject message = (JSONObject)messages.get(0);
        String messageId = (String)message.get((Object)"id");
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("messageId")).thenReturn((Object)messageId);
        chatServer.delete(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
        MessageBean messageBean = chatService.getMessage(roomId, messageId);
        Assert.assertNotNull((Object)messageBean);
        Assert.assertEquals((Object)"DELETED", (Object)messageBean.getMessage());
    }

    @Test
    public void testDeleteMessageWhenNotAuthorOfTheMessage() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ArrayList<String> users = new ArrayList<String>();
        users.add(MARY);
        users.add(JOHN);
        String roomId = chatService.getRoom(users);
        String tokenJohn = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, tokenJohn);
        String tokenJames = tokenService.getToken(JAMES);
        tokenService.addUser(JAMES, tokenJames);
        chatService.write(MESSAGE, JOHN, roomId, FALSE_STRING);
        String jsonMessages = chatService.read(MARY, roomId);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)jsonMessages);
        JSONArray messages = (JSONArray)jsonObject.get((Object)"messages");
        JSONObject message = (JSONObject)messages.get(0);
        String messageId = (String)message.get((Object)"id");
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JAMES);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)tokenJames);
        Mockito.when((Object)this.request.getParameter("room")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("messageId")).thenReturn((Object)messageId);
        chatServer.delete(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(404);
        MessageBean messageBean = chatService.getMessage(roomId, messageId);
        Assert.assertNotNull((Object)messageBean);
        Assert.assertEquals((Object)MESSAGE, (Object)messageBean.getMessage());
    }

    @Test
    public void testIsFavorite() {
        ChatServer chatServer = new ChatServer();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        UserService userService = ServiceBootstrap.getUserService();
        String benjamin = "benjamin";
        String john = JOHN;
        userService.addUserFullName(benjamin, "Benjamin Paillereau");
        userService.addUserFullName(john, JOHN_SMITH);
        userService.addFavorite(benjamin, john);
        String tokenBen = tokenService.getToken(benjamin);
        tokenService.addUser(benjamin, tokenBen);
        String tokenJohn = tokenService.getToken(john);
        tokenService.addUser(john, tokenJohn);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)benjamin);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)tokenBen);
        Mockito.when((Object)this.request.getParameter("targetUser")).thenReturn((Object)john);
        chatServer.isFavorite(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
        Assert.assertEquals((Object)FALSE_STRING, (Object)this.content);
        this.content = null;
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)benjamin);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)tokenJohn);
        Mockito.when((Object)this.request.getParameter("targetUser")).thenReturn((Object)john);
        chatServer.isFavorite(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(404);
        Assert.assertNull((Object)this.content);
    }

    @Test
    public void testGetUsersCount() {
        ChatServer chatServer = new ChatServer();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        SpaceBean mySpace = new SpaceBean();
        mySpace.setId(SPACE_ROOM_ID);
        mySpace.setGroupId(SPACE_GROUP_ID);
        mySpace.setDisplayName(SPACE_NAME);
        mySpace.setRoom(SPACE_ROOM_ID);
        userService.setSpaces(JOHN, Collections.singletonList(mySpace));
        userService.setSpaces(MARY, Collections.singletonList(mySpace));
        userService.setSpaces("ali", Collections.singletonList(mySpace));
        userService.setSpaces("shahin", Collections.singletonList(mySpace));
        String roomId = chatService.getSpaceRoom(SPACE_ROOM_ID);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("roomId")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("filter")).thenReturn((Object)"");
        chatServer.usersCount(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
        Assert.assertTrue((String)"Users count should be 4", (boolean)this.content.contains("4"));
    }

    @Test
    public void testDeleteRoomWhenCreator() {
        ChatServer chatServer = new ChatServer();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        userService.addUserFullName(JOHN, JOHN_SMITH);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        String roomId = chatService.getTeamRoom(MY_TEAM_ROOM, JOHN);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("roomId")).thenReturn((Object)roomId);
        chatServer.deleteTeamRoom(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void testDeleteRoomWhenNotCreator() {
        ChatServer chatServer = new ChatServer();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        userService.addUserFullName(JOHN, JOHN_SMITH);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        String roomId = chatService.getTeamRoom(MY_TEAM_ROOM, MARY);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("roomId")).thenReturn((Object)roomId);
        chatServer.deleteTeamRoom(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(404);
    }

    @Test
    public void testUpdateRoomMeetingWhenMember() {
        ChatServer chatServer = new ChatServer();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        String john = JOHN;
        userService.addUserFullName(john, JOHN_SMITH);
        String token = tokenService.getToken(john);
        tokenService.addUser(john, token);
        String roomId = chatService.getTeamRoom(MY_TEAM_ROOM, JOHN);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("roomId")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("start")).thenReturn((Object)"true");
        Mockito.when((Object)this.request.getParameter("startTime")).thenReturn((Object)"123456789");
        chatServer.updateRoomMeetingStatus(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void testUpdateRoomMeetingWhenNotMember() {
        ChatServer chatServer = new ChatServer();
        TokenService tokenService = ServiceBootstrap.getTokenService();
        ChatService chatService = ServiceBootstrap.getChatService();
        UserService userService = ServiceBootstrap.getUserService();
        userService.addUserFullName(JOHN, JOHN_SMITH);
        String token = tokenService.getToken(JOHN);
        tokenService.addUser(JOHN, token);
        String roomId = chatService.getTeamRoom(MY_TEAM_ROOM, MARY);
        Mockito.when((Object)this.request.getParameter("user")).thenReturn((Object)JOHN);
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)token);
        Mockito.when((Object)this.request.getParameter("roomId")).thenReturn((Object)roomId);
        Mockito.when((Object)this.request.getParameter("start")).thenReturn((Object)"true");
        Mockito.when((Object)this.request.getParameter("startTime")).thenReturn((Object)"123456789");
        chatServer.updateRoomMeetingStatus(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }
}

