/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;

@Named(value="tokenStorage")
@ApplicationScoped
@Singleton
public class TokenMongoService
implements TokenStorage {
    public static final String M_USERS_COLLECTION = "users";
    public static final String IS_DEMO_USER = "isDemoUser";
    public static final String TOKEN = "token";
    public static final String USER = "user";
    public static final String ID = "_id";
    public static final String FULLNAME = "fullname";
    public static final String STATUS = "status";
    public static final String IS_ENABLED = "isEnabled";
    public static final String IS_DELETED = "isDeleted";
    public static final String IS_EXTERNAL = "isExternal";
    public static final String TRUE = "true";

    private MongoDatabase db() {
        return ConnectionManager.getInstance().getDB();
    }

    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
        String in = user + passphrase;
        return MessageDigester.getHash((String)in);
    }

    @Override
    public boolean hasUserWithToken(String user, String token) {
        MongoCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)USER, (Object)user), Filters.eq((String)TOKEN, (Object)token)});
        return coll.find(query).cursor().hasNext();
    }

    @Override
    public void addUser(String user, String token) {
        if (!this.hasUserWithToken(user, token)) {
            MongoCollection coll = this.db().getCollection(M_USERS_COLLECTION);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)USER, (Object)user);
            try (MongoCursor cursor = coll.find((Bson)query).cursor();){
                if (cursor.hasNext()) {
                    Bson updateDocument = Updates.combine((Bson[])new Bson[]{Updates.set((String)TOKEN, (Object)token), Updates.set((String)IS_DEMO_USER, (Object)user.startsWith("__anonim_"))});
                    coll.updateOne((Bson)query, updateDocument);
                } else {
                    Document doc = new Document();
                    doc.put(ID, (Object)user);
                    doc.put(USER, (Object)user);
                    doc.put(TOKEN, (Object)token);
                    doc.put(IS_DEMO_USER, (Object)user.startsWith("__anonim_"));
                    doc.put(IS_ENABLED, (Object)Boolean.TRUE.toString());
                    doc.put(IS_DELETED, (Object)Boolean.FALSE.toString());
                    coll.insertOne((Object)doc);
                }
            }
        }
    }

    @Override
    public void removeUserToken(String user, String token) {
        MongoCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)USER, (Object)user), Filters.eq((String)TOKEN, (Object)token)});
        Document tokenUpdate = new Document().append(TOKEN, (Object)"");
        coll.updateOne(query, (Bson)tokenUpdate);
    }

    @Override
    public Map<String, UserBean> getActiveUsersFilterBy(String user, List<String> limitedFilter, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        Document query = new Document();
        if (isAdmin) {
            if (withPublic && !withUsers) {
                query = Filters.eq((String)IS_DEMO_USER, (Object)true);
            } else if (!withPublic && withUsers) {
                query = Filters.eq((String)IS_DEMO_USER, (Object)false);
            }
        } else {
            query = Filters.eq((String)IS_DEMO_USER, (Object)user.startsWith("__anonim_"));
        }
        query = Filters.and((Bson[])new Bson[]{query, Filters.in((String)USER, limitedFilter)});
        if (limit < 0) {
            limit = 0;
        }
        HashMap<String, UserBean> users = new HashMap<String, UserBean>();
        MongoCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        try (MongoCursor cursor = coll.find((Bson)query).limit(limit).cursor();){
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                String target = doc.get((Object)USER).toString();
                if (user.equals(target)) continue;
                UserBean userBean = new UserBean();
                userBean.setName(target);
                if (doc.get((Object)FULLNAME) != null) {
                    userBean.setFullname(doc.get((Object)FULLNAME).toString());
                }
                if (doc.get((Object)STATUS) != null) {
                    userBean.setStatus(doc.get((Object)STATUS).toString());
                }
                if (doc.get((Object)IS_ENABLED) != null) {
                    userBean.setEnabled(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE)));
                }
                if (doc.get((Object)IS_DELETED) != null) {
                    userBean.setDeleted(Boolean.valueOf(StringUtils.equals((CharSequence)doc.get((Object)IS_DELETED).toString(), (CharSequence)TRUE)));
                }
                if (doc.get((Object)IS_EXTERNAL) != null) {
                    userBean.setExternal(doc.get((Object)IS_EXTERNAL).toString());
                }
                if (!Boolean.TRUE.equals(userBean.isEnabled())) continue;
                users.put(target, userBean);
            }
        }
        return users;
    }
}

