/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.ReportBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.model.UsersBean;
import org.exoplatform.chat.server.ChatTools;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ChatServer
extends ChatTools {
    private static final long serialVersionUID = 5214457021130598730L;
    private static final Logger LOG = Logger.getLogger("ChatServer");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestUri;
        switch (requestUri = req.getRequestURI().replace(req.getContextPath(), "")) {
            case "": 
            case "/": {
                this.index(resp);
                break;
            }
            case "/filterOutSilentUsers": {
                this.getFilteredList(req, resp);
                break;
            }
            case "/userRooms": {
                this.getUserRooms(req, resp);
                break;
            }
            case "/whoIsOnline": {
                this.whoIsOnline(req, resp);
                break;
            }
            case "/updateUser": {
                this.updateUser(req, resp);
                break;
            }
            case "/setExternal": {
                this.setExternal(req, resp);
                break;
            }
            case "/read": {
                this.read(req, resp);
                break;
            }
            case "/setRoomNotificationTrigger": {
                this.setRoomNotificationTrigger(req, resp);
                break;
            }
            case "/getMeetingNotes": {
                this.getMeetingNotes(req, resp);
                break;
            }
            case "/toggleFavorite": {
                this.toggleFavorite(req, resp);
                break;
            }
            case "/isFavorite": {
                this.isFavorite(req, resp);
                break;
            }
            case "/getUserDesktopNotificationSettings": {
                this.getUserDesktopNotificationSettings(req, resp);
                break;
            }
            case "/setPreferredNotification": {
                this.setPreferredNotification(req, resp);
                break;
            }
            case "/setNotificationSettings": {
                this.setNotificationSettings(req, resp);
                break;
            }
            case "/setNotificationTrigger": {
                this.setNotificationTrigger(req, resp);
                break;
            }
            case "/getRoom": {
                this.getRoom(req, resp);
                break;
            }
            case "/isRoomEnabled": {
                this.isRoomEnabled(req, resp);
                break;
            }
            case "/updateRoomEnabled": {
                this.setRoomEnabled(req, resp);
                break;
            }
            case "/updateUnreadMessages": {
                this.updateUnreadMessages(req, resp);
                break;
            }
            case "/notification": {
                this.notification(req, resp);
                break;
            }
            case "/setStatus": {
                this.setStatus(req, resp);
                break;
            }
            case "/getCreator": {
                this.getCreator(req, resp);
                break;
            }
            case "/users": {
                this.users(req, resp);
                break;
            }
            case "/getUserFullName": {
                this.getUserFullName(req, resp);
                break;
            }
            case "/shouldUpdate": {
                this.shouldUpdate(req, resp);
                break;
            }
            case "/usersCount": {
                this.usersCount(req, resp);
                break;
            }
            case "/statistics": {
                this.statistics(resp);
                break;
            }
            case "/getStatus": {
                this.getStatus(req, resp);
                break;
            }
            default: {
                this.writeTextResponse(resp, null, 404);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestUri;
        switch (requestUri = req.getRequestURI().replace(req.getContextPath(), "")) {
            case "/edit": {
                this.edit(req, resp);
                break;
            }
            case "/send": {
                this.send(req, resp);
                break;
            }
            case "/sendMeetingNotes": {
                this.sendMeetingNotes(req, resp);
                break;
            }
            case "/saveTeamRoom": {
                this.saveTeamRoom(req, resp);
                break;
            }
            case "/updateRoomMeetingStatus": {
                this.updateRoomMeetingStatus(req, resp);
                break;
            }
            case "/addUser": {
                this.addUser(req, resp);
                break;
            }
            case "/logout": {
                this.logout(req, resp);
                break;
            }
            case "/setAsAdmin": {
                this.setAsAdmin(req, resp);
                break;
            }
            case "/addUserFullNameAndEmail": {
                this.addUserFullNameAndEmail(req, resp);
                break;
            }
            case "/deleteUser": {
                this.deleteUser(req, resp);
                break;
            }
            case "/setEnabledUser": {
                this.setEnabledUser(req, resp);
                break;
            }
            case "/setExternalUser": {
                this.setExternalUser(req, resp);
                break;
            }
            case "/setSpaces": {
                this.setSpaces(req, resp);
                break;
            }
            case "/removeUserFromSpace": {
                this.removeUserFromSpace(req, resp);
                break;
            }
            case "/delete": {
                this.delete(req, resp);
                break;
            }
            case "/deleteTeamRoom": {
                this.deleteTeamRoom(req, resp);
                break;
            }
            case "/updateRoomEnabled": {
                this.setRoomEnabled(req, resp);
                break;
            }
            default: {
                this.writeTextResponse(resp, null, 404);
            }
        }
    }

    protected void index(HttpServletResponse resp) {
        resp.setStatus(200);
    }

    protected void getFilteredList(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String roomId = request.getParameter("roomId");
        String token = request.getParameter("token");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        ArrayList<String> receivers = new ArrayList<String>();
        List roomParticipants = this.userService.getUsers(roomId);
        if (roomParticipants.isEmpty()) {
            roomParticipants = this.userService.getUsersInRoomChatOneToOne(roomId);
        }
        for (UserBean roomUser : roomParticipants) {
            if (roomUser.getName().equals(user) || this.notificationService.isRoomSilentForUser(roomUser.getName(), roomId)) continue;
            receivers.add(roomUser.getName());
        }
        this.writeJsonResponse(response, JSONArray.toJSONString(receivers));
    }

    protected void getUserRooms(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String onlineUsers = request.getParameter("onlineUsers");
        String token = request.getParameter("token");
        String filter = request.getParameter("filter");
        String offset = request.getParameter("offset");
        String limit = request.getParameter("limit");
        String roomType = request.getParameter("roomType");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        int limitValue = StringUtils.isNumeric((CharSequence)limit) ? Integer.parseInt(limit) : 20;
        int offsetValue = StringUtils.isNumeric((CharSequence)offset) ? Integer.parseInt(offset) : 0;
        List<String> limitUsers = Arrays.asList(onlineUsers.split(","));
        RoomsBean roomsBean = this.chatService.getUserRooms(user, limitUsers, filter, offsetValue, limitValue, this.notificationService, this.tokenService, roomType);
        this.writeJsonResponse(response, roomsBean.roomsToJSON());
    }

    protected void whoIsOnline(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String onlineUsers = request.getParameter("onlineUsers");
        String token = request.getParameter("token");
        String filter = request.getParameter("filter");
        String limit = request.getParameter("limit");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        int ilimit = StringUtils.isNumeric((CharSequence)limit) ? Integer.parseInt(limit) : 20;
        List<String> limitUsers = Arrays.asList(onlineUsers.split(","));
        RoomsBean roomsBean = this.chatService.getRooms(user, limitUsers, filter, true, true, true, true, false, ilimit, this.notificationService, this.tokenService);
        this.writeJsonResponse(response, roomsBean.roomsToJSON());
    }

    protected void updateUser(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String targetUser = request.getParameter("targetUser");
        String isDeleted = request.getParameter("isDeleted");
        String isEnabled = request.getParameter("isEnabled");
        String isExternal = request.getParameter("isExternal");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        this.userService.setExternalUser(targetUser, isExternal);
        if (StringUtils.equalsIgnoreCase((CharSequence)isDeleted, (CharSequence)"true")) {
            this.userService.deleteUser(targetUser);
        } else {
            this.userService.setEnabledUser(targetUser, Boolean.valueOf(StringUtils.equalsIgnoreCase((CharSequence)isEnabled, (CharSequence)"true")));
        }
        this.writeTextResponse(response, "Updated!");
    }

    protected void setExternal(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String targetUser = request.getParameter("targetUser");
        String isExternal = request.getParameter("isExternal");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        this.userService.setExternalUser(targetUser, isExternal);
        this.writeTextResponse(response, "Updated!");
    }

    protected void send(HttpServletRequest request, HttpServletResponse response) {
        String sender = request.getParameter("sender");
        String token = request.getParameter("token");
        String message = request.getParameter("message");
        String room = request.getParameter("room");
        String isSystem = request.getParameter("isSystem");
        String options = request.getParameter("options");
        this.send(response, sender, token, message, room, isSystem, options);
    }

    protected void read(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String fromTimestamp = request.getParameter("fromTimestamp");
        String toTimestamp = request.getParameter("toTimestamp");
        String isTextOnly = request.getParameter("isTextOnly");
        String limit = request.getParameter("limit");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        Long from = StringUtils.isNumeric((CharSequence)fromTimestamp) ? Long.valueOf(Long.parseLong(fromTimestamp)) : null;
        Long to = StringUtils.isNumeric((CharSequence)toTimestamp) ? Long.valueOf(Long.parseLong(toTimestamp)) : null;
        int ilimit = StringUtils.isNumeric((CharSequence)limit) ? Integer.parseInt(limit) : 20;
        try {
            String data = this.chatService.read(user, room, "true".equals(isTextOnly), from, to, ilimit);
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
            this.writeJsonResponse(response, data);
        }
        catch (ChatException e) {
            this.writeErrorResponse(response, e);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void sendMeetingNotes(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String fromTimestamp = request.getParameter("fromTimestamp");
        String toTimestamp = request.getParameter("toTimestamp");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        Long from = StringUtils.isNumeric((CharSequence)fromTimestamp) ? Long.valueOf(Long.parseLong(fromTimestamp)) : null;
        Long to = StringUtils.isNumeric((CharSequence)toTimestamp) ? Long.valueOf(Long.parseLong(toTimestamp)) : null;
        String data = this.chatService.read(user, room, false, from, to, 0);
        BasicDBObject datao = BasicDBObject.parse((String)data);
        String roomType = this.chatService.getTypeRoomChat(room);
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        String date = formatter.format(new GregorianCalendar().getTime());
        Object title = "";
        String roomName = "";
        Locale locale = request.getLocale();
        ResourceBundle res = this.resolveBundle(request, locale);
        if (datao.containsField("messages")) {
            List<UserBean> users;
            if ("u".equalsIgnoreCase(roomType)) {
                users = this.userService.getUsersInRoomChatOneToOne(room).stream().filter(UserBean::isEnabledUser).toList();
                title = res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            } else {
                users = this.userService.getUsers(room).stream().filter(UserBean::isEnabledUser).toList();
                List spaces = this.userService.getSpaces(user);
                for (Object spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List roomBeans = this.userService.getTeams(user);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
                title = roomName + " : " + res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            }
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users);
            ArrayList<String> tos = new ArrayList<String>();
            String senderName = user;
            String senderMail = "";
            for (UserBean userBean : users) {
                if (!"".equals(userBean.getEmail())) {
                    tos.add(userBean.getEmail());
                }
                if (!user.equals(userBean.getName())) continue;
                senderName = userBean.getFullname();
                senderMail = userBean.getEmail();
            }
            String serverBase = ChatUtils.getServerBase();
            String html = reportBean.getAsHtml((String)title, serverBase, locale);
            String prevUser = "";
            int index = 0;
            HashMap<String, String> inlineImages = new HashMap<String, String>();
            for (MessageBean messageBean : reportBean.getMessages()) {
                if (!messageBean.getUser().equals(prevUser)) {
                    String keyAvatar = messageBean.getUser() + index;
                    String valueAvatar = serverBase + "/portal/rest/v1/social/users/{}/avatar".replace("{}", messageBean.getUser());
                    inlineImages.put(keyAvatar, valueAvatar);
                    ++index;
                }
                prevUser = messageBean.getUser();
            }
            try {
                this.sendMailWithAuth(senderName, senderMail, tos, html, (String)title, inlineImages);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        this.writeTextResponse(response, "sent");
    }

    protected void getMeetingNotes(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String fromTimestamp = request.getParameter("fromTimestamp");
        String toTimestamp = request.getParameter("toTimestamp");
        String portalURI = request.getParameter("portalURI");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        Long from = StringUtils.isNumeric((CharSequence)fromTimestamp) ? Long.valueOf(Long.parseLong(fromTimestamp)) : null;
        Long to = StringUtils.isNumeric((CharSequence)toTimestamp) ? Long.valueOf(Long.parseLong(toTimestamp)) : null;
        String wikiPageContent = "";
        ArrayList<UserBean> users = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        String data = this.chatService.read(user, room, false, from, to, 0);
        String typeRoom = this.chatService.getTypeRoomChat(room);
        BasicDBObject datao = BasicDBObject.parse((String)data);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(typeRoom)) {
                users = this.userService.getUsersInRoomChatOneToOne(room).stream().filter(UserBean::isEnabledUser).toList();
            }
            Locale locale = request.getLocale();
            ResourceBundle res = this.resolveBundle(request, locale);
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users);
            ArrayList<String> usersInGroup = new ArrayList<String>();
            String serverBase = ChatUtils.getServerBase();
            wikiPageContent = reportBean.getWikiPageContent(serverBase, portalURI);
            try {
                for (UserBean userBean : users) {
                    if ("".equals(userBean.getName())) continue;
                    usersInGroup.add(userBean.getName());
                }
                jsonObject.put((Object)"users", usersInGroup);
                jsonObject.put((Object)"wikiPageContent", (Object)wikiPageContent);
                jsonObject.put((Object)"typeRoom", (Object)typeRoom);
                this.writeJsonResponse(response, jsonObject.toString());
            }
            catch (Exception e) {
                this.writeTextResponse(response, "No Room yet", 404);
            }
        }
    }

    protected void delete(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String messageId = request.getParameter("messageId");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        MessageBean message = this.chatService.getMessage(room, messageId);
        if (message == null || !message.getUser().equals(user)) {
            this.writeTextResponse(response, "", 404);
            return;
        }
        try {
            this.chatService.delete(room, user, messageId);
            this.writeTextResponse(response, "Updated!");
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void deleteTeamRoom(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        try {
            String creator = this.chatService.getTeamCreator(room);
            if (!creator.equals(user)) {
                this.writeTextResponse(response, "", 404);
                return;
            }
            this.chatService.deleteTeamRoom(room, user);
            this.writeTextResponse(response, "Updated!");
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void edit(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String messageId = request.getParameter("messageId");
        String message = request.getParameter("message");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        MessageBean currentMessage = this.chatService.getMessage(room, messageId);
        if (currentMessage == null || !currentMessage.getUser().equals(user)) {
            this.writeTextResponse(response, "", 404);
            return;
        }
        try {
            message = URLDecoder.decode(message, StandardCharsets.UTF_8);
            this.chatService.edit(room, user, messageId, message);
            this.writeTextResponse(response, "Updated!");
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void toggleFavorite(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String targetUser = request.getParameter("targetUser");
        String favorite = request.getParameter("favorite");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)favorite, (CharSequence)"true")) {
            this.userService.addFavorite(user, targetUser);
        } else {
            this.userService.removeFavorite(user, targetUser);
        }
        this.writeTextResponse(response, "Updated!");
    }

    protected void isFavorite(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String targetUser = request.getParameter("targetUser");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        boolean isFavorite = false;
        try {
            isFavorite = this.userService.isFavorite(user, targetUser);
            this.writeTextResponse(response, String.valueOf(isFavorite));
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void getUserDesktopNotificationSettings(HttpServletRequest request, HttpServletResponse response) {
        String token;
        String user = request.getParameter("user");
        if (!this.tokenService.hasUserWithToken(user, token = request.getParameter("token"))) {
            response.setStatus(404);
            return;
        }
        JSONObject content = this.getUserDesktopNotificationSettings(user);
        this.writeJsonResponse(response, content.toJSONString());
    }

    protected void setPreferredNotification(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String notifManner = request.getParameter("notifManner");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        JSONObject content = new JSONObject();
        try {
            this.userService.setPreferredNotification(user, notifManner);
            content.put((Object)"done", (Object)true);
        }
        catch (Exception e) {
            content.put((Object)"done", (Object)false);
        }
        this.writeJsonResponse(response, content.toJSONString());
    }

    protected void setRoomNotificationTrigger(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String notifCondition = request.getParameter("notifCondition");
        String notifConditionType = request.getParameter("notifConditionType");
        String time = request.getParameter("time");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        try {
            Long timeMs = StringUtils.isNumeric((CharSequence)time) ? Long.valueOf(Long.parseLong(time)) : null;
            this.userService.setRoomNotificationTrigger(user, room, notifCondition, notifConditionType, timeMs.longValue());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("notificationTrigger", notifConditionType);
            data.put("targetRoom", room);
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_NOTIFICATION_SETTINGS_UPDATED, null, user, null, data);
            this.realTimeMessageService.sendMessage(messageBean, user);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
        JSONObject content = this.getUserDesktopNotificationSettings(user);
        this.writeJsonResponse(response, content.toJSONString());
    }

    protected void setNotificationSettings(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String[] notifConditions = request.getParameterValues("notifConditions");
        String[] notifManners = request.getParameterValues("notifManners");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        if (notifConditions != null) {
            for (String notifCondition : notifConditions) {
                try {
                    this.userService.setPreferredNotification(user, notifCondition);
                }
                catch (Exception e) {
                    LOG.severe("Error while updating the preferences of the user notifications: " + e.getMessage());
                }
            }
        }
        if (notifManners != null) {
            for (String notifManner : notifManners) {
                try {
                    this.userService.setNotificationTrigger(user, notifManner);
                }
                catch (Exception e) {
                    this.writeErrorResponse(response, e);
                }
            }
        }
        JSONObject content = this.getUserDesktopNotificationSettings(user);
        this.writeJsonResponse(response, content.toJSONString());
    }

    protected void setNotificationTrigger(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String notifCondition = request.getParameter("notifCondition");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        try {
            this.userService.setNotificationTrigger(user, notifCondition);
            JSONObject content = this.getUserDesktopNotificationSettings(user);
            this.writeJsonResponse(response, content.toJSONString());
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void getRoom(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String targetUser = request.getParameter("targetUser");
        String withDetail = request.getParameter("withDetail");
        String type = request.getParameter("type");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        String room = targetUser;
        RoomBean roomBean = null;
        try {
            if (type != null) {
                if ("room-id".equals(type)) {
                    room = targetUser;
                } else if ("space-name".equals(type)) {
                    room = this.chatService.getSpaceRoomByName(targetUser);
                } else if ("space-id".equals(type)) {
                    room = ChatUtils.getRoomId((String)targetUser);
                } else if ("username".equals(type)) {
                    users = new ArrayList();
                    users.add(user);
                    users.add(targetUser);
                    room = this.chatService.getRoom(users);
                } else if ("external".equals(type)) {
                    room = this.chatService.getExternalRoom(targetUser);
                }
            } else if (targetUser.startsWith("space-")) {
                room = this.chatService.getSpaceRoom(targetUser);
            } else if (targetUser.startsWith("team-")) {
                room = this.chatService.getTeamRoom(targetUser, user);
            } else if (targetUser.startsWith("external-")) {
                room = this.chatService.getExternalRoom(targetUser);
            } else {
                users = new ArrayList<String>(2);
                users.add(user);
                users.add(targetUser);
                room = this.chatService.getRoom(users);
            }
            if ("true".equals(withDetail)) {
                roomBean = this.userService.getRoom(user, room);
            }
            String out = room;
            if (roomBean != null) {
                out = roomBean.toJSON();
            }
            this.writeJsonResponse(response, out);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void saveTeamRoom(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String teamName = request.getParameter("teamName");
        String room = request.getParameter("room");
        String users = request.getParameter("users");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        teamName = URLDecoder.decode(teamName, StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)(teamName = teamName.trim()))) {
            this.writeTextResponse(response, "Data is invalid!", 400);
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            String creator;
            List existingUsers;
            if (room == null || "".equals(room) || "---".equals(room)) {
                List roomBeans = this.chatService.getTeamRoomsByName(teamName);
                if (roomBeans != null && !roomBeans.isEmpty()) {
                    for (RoomBean roomBean : roomBeans) {
                        if (user.equals(roomBean.getUser())) {
                            this.writeTextResponse(response, "roomAlreadyExists.creator", 400);
                            return;
                        }
                        existingUsers = this.userService.getUsersFilterBy(null, roomBean.getRoom(), "t");
                        if (existingUsers == null || !existingUsers.contains(user)) continue;
                        this.writeTextResponse(response, "roomAlreadyExists.notCreator", 400);
                        return;
                    }
                }
                room = this.chatService.getTeamRoom(teamName, user);
            }
            if (!user.equals(creator = this.chatService.getTeamCreator(room))) {
                response.setStatus(404);
                return;
            }
            JSONArray usersToNotifyForAdd = new JSONArray();
            JSONArray usersToAdd = new JSONArray();
            if (users != null && !users.isEmpty()) {
                String fullName;
                UserBean userBean;
                StringBuilder sbUsers;
                existingUsers = this.userService.getUsersFilterBy(null, room, "t");
                List<String> usersNew = Arrays.asList(users.split(","));
                usersToAdd.addAll(usersNew);
                JSONArray usersToRemove = new JSONArray();
                for (String u : existingUsers) {
                    if (usersNew.contains(u)) {
                        usersToNotifyForAdd.add(u);
                        usersToAdd.remove(u);
                        continue;
                    }
                    usersToRemove.add(u);
                }
                if (!usersToRemove.isEmpty()) {
                    this.userService.removeTeamUsers(room, (List)usersToRemove);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String u : usersToRemove) {
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        fullName = (userBean = this.userService.getUser(u)).isExternal() != null && userBean.isExternal().equals("true") ? this.userService.getUserFullName(u) + " (" + ChatServer.getResourceBundleLabel(new Locale(ChatServer.getCurrentUserLanguage(user)), "external.label.tag") + ")" : this.userService.getUserFullName(u);
                        sbUsers.append(fullName);
                        first = false;
                        this.notificationService.setNotificationsAsRead(u, "chat", "room", room);
                    }
                    String removeTeamUserOptions = "{\"type\":\"type-remove-team-user\",\"users\":\"" + String.valueOf(sbUsers) + "\", \"fullname\":\"" + this.userService.getUserFullName(user) + "\"}";
                    this.send(response, user, token, "", room, "true", removeTeamUserOptions);
                }
                this.chatService.setRoomName(room, teamName);
                if (!usersToAdd.isEmpty()) {
                    this.userService.addTeamUsers(room, (List)usersToAdd);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String usert : usersToAdd) {
                        if (usert.equals(creator)) continue;
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        fullName = (userBean = this.userService.getUser(usert)).isExternal() != null && userBean.isExternal().equals("true") ? this.userService.getUserFullName(usert) + " (" + ChatServer.getResourceBundleLabel(new Locale(ChatServer.getCurrentUserLanguage(user)), "external.label.tag") + ")" : this.userService.getUserFullName(usert);
                        sbUsers.append(fullName);
                        first = false;
                    }
                    String addTeamUserOptions = "{\"type\":\"type-add-team-user\",\"users\":\"" + String.valueOf(sbUsers) + "\", \"fullname\":\"" + this.userService.getUserFullName(user) + "\"}";
                    this.send(user, "", room, "true", addTeamUserOptions);
                }
            }
            RoomBean roomBean = this.userService.getRoom(user, room);
            JSONObject data = roomBean.toJSONObject();
            data.put((Object)"title", (Object)teamName);
            data.put((Object)"participants", (Object)usersToAdd);
            RealTimeMessageBean updatedRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_UPDATED, room, user, null, (Map)data);
            if (!usersToNotifyForAdd.contains(creator)) {
                usersToNotifyForAdd.add(creator);
            }
            this.realTimeMessageService.sendMessage(updatedRoomMessage, (List<String>)usersToNotifyForAdd);
            jsonObject.putAll((Map)data);
            jsonObject.put((Object)"name", (Object)teamName);
            jsonObject.put((Object)"room", (Object)room);
            this.writeJsonResponse(response, jsonObject.toJSONString());
        }
        catch (Exception e) {
            this.writeErrorResponse(response, "No Room yet");
        }
    }

    protected void updateRoomMeetingStatus(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String start = request.getParameter("start");
        String room = request.getParameter("room");
        String startTime = request.getParameter("startTime");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        if (this.chatService.isMemberOfRoom(user, room)) {
            this.chatService.setRoomMeetingStatus(room, Boolean.parseBoolean(start), startTime);
            this.writeTextResponse(response, "Updated!");
        } else {
            this.writeTextResponse(response, "", 404);
        }
    }

    protected void isRoomEnabled(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String spaceId = request.getParameter("spaceId");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        String room = ChatUtils.getRoomId((String)spaceId);
        Boolean isEnabled = this.chatService.isRoomEnabled(room);
        this.writeTextResponse(response, isEnabled.toString());
    }

    protected void setRoomEnabled(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String spaceId = request.getParameter("spaceId");
        String enabled = request.getParameter("enabled");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        String room = ChatUtils.getRoomId((String)spaceId);
        this.chatService.setRoomEnabled(room, StringUtils.equalsIgnoreCase((CharSequence)enabled, (CharSequence)"true"));
        this.writeTextResponse(response, "Updated!");
    }

    protected void updateUnreadMessages(HttpServletRequest request, HttpServletResponse response) {
        String token;
        String room = request.getParameter("room");
        String user = request.getParameter("user");
        if (!this.tokenService.hasUserWithToken(user, token = request.getParameter("token"))) {
            response.setStatus(404);
            return;
        }
        try {
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
            if (this.userService.isAdmin(user)) {
                this.notificationService.setNotificationsAsRead("__support_", "chat", "room", room);
            }
            this.writeTextResponse(response, "Updated!");
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void notification(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String event = request.getParameter("event");
        String withDetails = request.getParameter("withDetails");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        boolean detailed = StringUtils.equalsIgnoreCase((CharSequence)withDetails, (CharSequence)"true");
        int totalUnread = 0;
        List notifications = null;
        if (!detailed) {
            List notificationBeans = this.notificationService.getUnreadNotifications(user, this.userService);
            totalUnread = notificationBeans.size();
            if (this.userService.isAdmin(user)) {
                totalUnread += this.notificationService.getUnreadNotificationsTotal("__support_");
            }
        } else {
            notifications = this.notificationService.getUnreadNotifications(user, this.userService);
            totalUnread = notifications.size();
        }
        if (event != null && event.equals("1")) {
            String data = "id: " + totalUnread + "\n";
            data = data + "data: {\"total\": " + totalUnread + "}\n\n";
            this.writeJsonResponse(response, data);
        } else {
            JSONObject json = new JSONObject();
            json.put((Object)"total", (Object)totalUnread);
            if (detailed) {
                JSONArray notifies = new JSONArray();
                if (CollectionUtils.isNotEmpty((Collection)notifications)) {
                    for (NotificationBean o : notifications) {
                        notifies.add((Object)o.toJSONObject());
                    }
                }
                json.put((Object)"notifications", (Object)notifies);
            }
            this.writeJsonResponse(response, json.toJSONString());
        }
    }

    protected void getStatus(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String targetUser = request.getParameter("targetUser");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        String status = "invisible";
        try {
            if (targetUser != null) {
                status = this.userService.getStatus(targetUser);
            }
            this.writeTextResponse(response, status);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, e);
        }
    }

    protected void setStatus(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String status = request.getParameter("status");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        try {
            this.userService.setStatus(user, status);
            this.writeTextResponse(response, status);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, "No Status for this User");
        }
    }

    protected void getCreator(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String creator = "";
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        try {
            creator = this.chatService.getTeamCreator(room);
            this.writeTextResponse(response, creator);
        }
        catch (Exception e) {
            this.writeErrorResponse(response, "No Status for this User");
        }
    }

    protected void users(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String onlineUsers = request.getParameter("onlineUsers");
        String room = request.getParameter("room");
        String filter = request.getParameter("filter");
        String limitString = request.getParameter("limit");
        String onlineOnly = request.getParameter("onlineOnly");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        boolean showOnlyOnlineUsers = StringUtils.isNotBlank((CharSequence)onlineOnly) && "true".equals(onlineOnly);
        int limit = StringUtils.isNumeric((CharSequence)limitString) ? Integer.parseInt(limitString) : 20;
        List<String> onlineUserList = StringUtils.isNotBlank((CharSequence)onlineUsers) ? Arrays.asList(onlineUsers.split(",")) : null;
        List users = this.userService.getUsers(room, onlineUserList, filter, limit, showOnlyOnlineUsers);
        if (StringUtils.isNotBlank((CharSequence)user)) {
            UserBean currentUser = this.userService.getUser(user);
            users.remove(currentUser);
        }
        UsersBean usersBean = new UsersBean();
        usersBean.setUsers(users);
        this.writeJsonResponse(response, usersBean.usersToJSON());
    }

    protected void usersCount(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter("user");
        String token = request.getParameter("token");
        String room = request.getParameter("room");
        String filter = request.getParameter("filter");
        if (!this.tokenService.hasUserWithToken(user, token)) {
            response.setStatus(404);
            return;
        }
        StringBuilder data = new StringBuilder();
        data.append("{");
        data.append(" \"usersCount\": ").append(this.userService.getUsersCount(room, filter)).append(",");
        data.append(" \"activeUsersCount\": ").append(this.userService.getActiveUsersCount(room, filter));
        data.append("}");
        this.writeJsonResponse(response, data.toString());
    }

    protected void statistics(HttpServletResponse response) {
        StringBuilder data = new StringBuilder();
        data.append("{");
        data.append(" \"users\": " + this.userService.getNumberOfUsers() + ", ");
        data.append(" \"rooms\": " + this.chatService.getNumberOfRooms() + ", ");
        data.append(" \"messages\": " + this.chatService.getNumberOfMessages() + ", ");
        data.append(" \"notifications\": " + this.notificationService.getNumberOfNotifications() + ", ");
        data.append(" \"notificationsUnread\": " + this.notificationService.getNumberOfUnreadNotifications());
        data.append("}");
        this.writeJsonResponse(response, data.toString());
    }

    private Session getMailSession() {
        String protocal = PropertyManager.getProperty((String)"email.smtp.protocal");
        String host = PropertyManager.getProperty((String)"email.smtp.host");
        final String user = PropertyManager.getProperty((String)"email.smtp.username");
        final String password = PropertyManager.getProperty((String)"email.smtp.password");
        String port = PropertyManager.getProperty((String)"email.smtp.port");
        String auth = PropertyManager.getProperty((String)"email.smtp.auth");
        String starttlsEnable = PropertyManager.getProperty((String)"email.smtp.starttls.enable");
        String enableSSL = PropertyManager.getProperty((String)"email.smtp.EnableSSL.enable");
        String smtpAuth = PropertyManager.getProperty((String)"email.smtp.auth");
        String socketFactoryPort = PropertyManager.getProperty((String)"email.smtp.socketFactory.port");
        String socketFactoryClass = PropertyManager.getProperty((String)"email.smtp.socketFactory.class");
        String socketFactoryFallback = PropertyManager.getProperty((String)"email.smtp.socketFactory.fallback");
        Properties props = new Properties();
        props.put("mail.transport.protocol", protocal);
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", auth);
        if (Boolean.parseBoolean(smtpAuth)) {
            props.put("mail.smtp.socketFactory.port", socketFactoryPort);
            props.put("mail.smtp.socketFactory.class", socketFactoryClass);
            props.put("mail.smtp.socketFactory.fallback", socketFactoryFallback);
            props.put("mail.smtp.starttls.enable", starttlsEnable);
            props.put("mail.smtp.ssl.enable", enableSSL);
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(this){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    private void sendMailWithAuth(String senderFullname, String senderMail, List<String> toList, String htmlBody, String subject, Map<String, String> inlineImages) throws Exception {
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(senderMail, senderFullname, "UTF-8"));
        for (String to : toList) {
            message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)to));
        }
        message.setSubject(subject, "UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (inlineImages != null && inlineImages.size() > 0) {
            Set<String> setImageID = inlineImages.keySet();
            for (String contentId : setImageID) {
                messageBodyPart = new MimeBodyPart();
                String imageFilePath = inlineImages.get(contentId);
                URL url = new URL(imageFilePath);
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                InputStream is = con.getInputStream();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, con.getContentType());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                messageBodyPart.setContentID("<" + contentId + ">");
                messageBodyPart.setDisposition("inline");
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        message.setContent((Multipart)multipart);
        try {
            Transport.send((Message)message);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static String getResourceBundleLabel(Locale locale, String label) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        return resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), locale).getString(label);
    }

    public static String getCurrentUserLanguage(String userId) {
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
        String lang = Locale.getDefault().getLanguage();
        if (localePolicy != null) {
            Locale locale = localePolicy.determineLocale(localeCtx);
            lang = locale.toString();
        }
        return lang;
    }

    private void send(HttpServletResponse response, String sender, String token, String message, String room, String isSystem, String options) {
        if (!this.tokenService.hasUserWithToken(sender, token)) {
            response.setStatus(404);
            return;
        }
        try {
            this.send(sender, message, room, isSystem, options);
            this.writeTextResponse(response, "ok");
        }
        catch (ChatException e) {
            this.writeErrorResponse(response, e);
        }
    }

    private JSONObject getUserDesktopNotificationSettings(String user) {
        JSONObject response = new JSONObject();
        JSONObject res = this.userService.getUserDesktopNotificationSettings(user).toJSON();
        response.put((Object)"done", (Object)(res != null && !res.isEmpty() ? 1 : 0));
        response.put((Object)"userDesktopNotificationSettings", (Object)res);
        return response;
    }

    private ResourceBundle resolveBundle(HttpServletRequest request, Locale locale) {
        try {
            return ResourceBundle.getBundle("locale.chat.server.Resource", locale, request.getServletContext().getClassLoader());
        }
        catch (Exception e) {
            return ResourceBundle.getBundle("locale.chat.server.Resource", Locale.ENGLISH, request.getServletContext().getClassLoader());
        }
    }

    private void send(String sender, String message, String room, String isSystem, String options) {
        if (message != null) {
            message = URLDecoder.decode(message, StandardCharsets.UTF_8);
            options = URLDecoder.decode(options, StandardCharsets.UTF_8);
            this.chatService.write(null, message, sender, room, isSystem, options);
        }
    }
}

