/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatDataStorage;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Named(value="chatStorage")
@ApplicationScoped
@Singleton
public class ChatMongoDataStorage
implements ChatDataStorage {
    private static final Logger LOG = Logger.getLogger("ChatMongoDataStorage");
    public static final String M_ROOM_PREFIX = "messages_room_";
    public static final String M_ROOMS_COLLECTION = "rooms";
    public static final String BR = "<br/>";
    public static final String MESSAGE = "message";
    public static final String TIMESTAMP1 = "timestamp";
    public static final String TIMESTAMP = "timestamp";
    public static final String USER = "user";
    public static final String IS_SYSTEM = "isSystem";
    public static final String ROOM_ID = "roomId";
    public static final String OPTIONS = "options";
    public static final String LAST_UPDATED_TIMESTAMP = "lastUpdatedTimestamp";
    public static final String MEETING_STARTED = "meetingStarted";
    public static final String START_TIME = "startTime";
    public static final String IS_ENABLED = "isEnabled";
    public static final String USERS = "users";
    public static final String TYPE = "type";
    public static final String ID = "_id";
    public static final String TEAM = "team";
    public static final String ROOM = "room";
    public static final String MESSAGES = "messages";
    public static final String TRUE = "true";
    public static final String SPACE = "space";
    private final int readTotalJson;
    private final int readTotalTxt;
    @Inject
    private UserDataStorage userDataStorage;
    private final SimpleDateFormat formatterDate = new SimpleDateFormat("dd/MM/yyyy hh:mm aaa");

    public ChatMongoDataStorage() {
        this.readTotalJson = Integer.parseInt(PropertyManager.getProperty((String)"chatReadTotalJson"));
        this.readTotalTxt = Integer.parseInt(PropertyManager.getProperty((String)"chatReadTotalTxt"));
    }

    private MongoDatabase db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public void write(String message, String user, String room, String isSystem) {
        this.write(message, user, room, isSystem, null);
    }

    @Override
    public void write(String message, String user, String room, String isSystem, String options) {
        this.save(message, user, room, isSystem, options);
    }

    @Override
    public String save(String message, String user, String room, String isSystem, String options) {
        String roomType = this.getTypeRoomChat(room);
        MongoCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        message = StringUtils.chomp((String)message);
        message = message.replace("&", "&#38");
        message = message.replace("<", "&lt;");
        message = message.replace(">", "&gt;");
        message = message.replace("\"", "&quot;");
        message = message.replace("\n", BR);
        message = message.replace("\\\\", "&#92");
        message = message.replace("\t", "  ");
        Document doc = new Document();
        doc.put(USER, (Object)user);
        doc.put(MESSAGE, (Object)message);
        doc.put("timestamp", (Object)System.currentTimeMillis());
        doc.put(IS_SYSTEM, (Object)isSystem);
        doc.put(ROOM_ID, (Object)room);
        if (options != null) {
            options = options.replace("<", "&lt;");
            options = options.replace(">", "&gt;");
            doc.put(OPTIONS, (Object)options);
        }
        coll.insertOne((Object)doc);
        this.updateRoomTimestamp(room);
        return doc.get((Object)ID).toString();
    }

    @Override
    public void delete(String room, String user, String messageId) {
        String roomType = this.getTypeRoomChat(room);
        MongoCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        Document query = new Document();
        query.put(ID, (Object)new ObjectId(messageId));
        query.put(USER, (Object)user);
        query.put(ROOM_ID, (Object)room);
        MongoCursor cursor = coll.find((Bson)query).cursor();
        if (cursor.hasNext()) {
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)MESSAGE, (Object)"DELETED"), Updates.set((String)TYPE, (Object)"DELETED"), Updates.set((String)LAST_UPDATED_TIMESTAMP, (Object)System.currentTimeMillis())});
            coll.updateOne((Bson)query, update);
        }
    }

    @Override
    public List<RoomBean> getTeamRoomByName(String teamName) {
        if (StringUtils.isBlank((CharSequence)teamName)) {
            return null;
        }
        MongoCollection cRooms = this.db().getCollection(M_ROOMS_COLLECTION);
        Document qRoom = new Document();
        qRoom.put(TEAM, (Object)teamName);
        qRoom.put(TYPE, (Object)"t");
        ArrayList<RoomBean> roomBeans = new ArrayList<RoomBean>();
        FindIterable roomsCursor = cRooms.find((Bson)qRoom);
        roomsCursor.forEach(dbRoom -> {
            RoomBean room = new RoomBean();
            room.setRoom(dbRoom.get((Object)ID).toString());
            room.setFullName((String)dbRoom.get((Object)TEAM));
            room.setUser((String)dbRoom.get((Object)USER));
            room.setType((String)dbRoom.get((Object)TYPE));
            if (dbRoom.containsKey((Object)MEETING_STARTED)) {
                room.setMeetingStarted(((Boolean)dbRoom.get((Object)MEETING_STARTED)).booleanValue());
            }
            if (dbRoom.containsKey((Object)START_TIME)) {
                room.setStartTime((String)dbRoom.get((Object)START_TIME));
            }
            if (StringUtils.isNotBlank((CharSequence)room.getUser())) {
                room.setAdmins(new String[]{room.getUser()});
            }
            if (dbRoom.containsKey((Object)"timestamp")) {
                room.setTimestamp(((Long)dbRoom.get((Object)"timestamp")).longValue());
            }
            roomBeans.add(room);
        });
        return roomBeans;
    }

    @Override
    public RoomBean getTeamRoomById(String roomId) {
        if (roomId == null || roomId.isEmpty()) {
            return null;
        }
        MongoCollection cRooms = this.db().getCollection(M_ROOMS_COLLECTION);
        Document qRoom = new Document();
        qRoom.put(ID, (Object)roomId);
        qRoom.put(TYPE, (Object)"t");
        Document document = (Document)cRooms.find((Bson)qRoom).first();
        if (document != null) {
            RoomBean room = new RoomBean();
            room.setRoom((String)document.get((Object)ID));
            room.setFullName((String)document.get((Object)TEAM));
            room.setUser((String)document.get((Object)USER));
            room.setType((String)document.get((Object)TYPE));
            if (document.containsKey((Object)MEETING_STARTED)) {
                room.setMeetingStarted(((Boolean)document.get((Object)MEETING_STARTED)).booleanValue());
            }
            if (document.containsKey((Object)START_TIME)) {
                room.setStartTime((String)document.get((Object)START_TIME));
            }
            if (StringUtils.isNotBlank((CharSequence)room.getUser())) {
                room.setAdmins(new String[]{room.getUser()});
            }
            if (document.containsKey((Object)"timestamp")) {
                room.setTimestamp(((Long)document.get((Object)"timestamp")).longValue());
            }
            return room;
        }
        return null;
    }

    @Override
    public void deleteTeamRoom(String roomId, String user) {
        RoomBean room = this.getTeamRoomById(roomId);
        if (room == null) {
            LOG.warning("No room with id [" + roomId + "] available to delete");
            return;
        }
        if (!room.getType().equals("t")) {
            LOG.warning("The room with id [" + roomId + "] is not a Team Room so it won't be deleted.");
            return;
        }
        LOG.info("Deleting Team Chat Room [" + room.getFullName() + "] (id:" + room.getRoom() + ")");
        if (!room.getUser().equals(user)) {
            LOG.warning("The user [" + user + "] is not the owner of the room with id [" + roomId + "] so this room won't be deleted.");
            return;
        }
        MongoCollection cMessages = this.db().getCollection("messages_room_t");
        Bson filter = Filters.eq((String)ROOM_ID, (Object)roomId);
        cMessages.deleteMany(filter);
        LOG.info("Messages of room [" + roomId + "] deleted");
        List<String> users = this.userDataStorage.getUsersFilterBy(null, roomId, "t");
        this.userDataStorage.removeTeamUsers(roomId, users);
        LOG.info("All users removed from the team room [" + roomId + "]");
        MongoCollection cRooms = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson qRoom = Filters.eq((String)ID, (Object)roomId);
        cRooms.deleteMany(qRoom);
        LOG.info("Team room [" + roomId + "] deleted");
    }

    @Override
    public void edit(String room, String user, String messageId, String message) {
        String roomType = this.getTypeRoomChat(room);
        MongoCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        message = StringUtils.chomp((String)message);
        message = message.replace("&", "&#38");
        message = message.replace("<", "&lt;");
        message = message.replace(">", "&gt;");
        message = message.replace("\"", "&quot;");
        message = message.replace("\n", BR);
        message = message.replace("\\\\", "&#92");
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)new ObjectId(messageId)), Filters.eq((String)USER, (Object)user), Filters.eq((String)ROOM_ID, (Object)room)});
        Bson updateDocument = Updates.combine((Bson[])new Bson[]{Updates.set((String)MESSAGE, (Object)message), Updates.set((String)TYPE, (Object)"EDITED"), Updates.set((String)LAST_UPDATED_TIMESTAMP, (Object)System.currentTimeMillis())});
        coll.findOneAndUpdate(query, updateDocument);
    }

    @Override
    public String read(String room) {
        return this.read(room, false, null, null, 0);
    }

    @Override
    public String read(String room, boolean isTextOnly, Long fromTimestamp) {
        return this.read(room, isTextOnly, fromTimestamp, null, 0);
    }

    @Override
    public String read(String room, boolean isTextOnly, Long fromTimestamp, Long toTimestamp, int limitToLoad) {
        StringBuilder sb;
        block26: {
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            String roomType = this.getTypeRoomChat(room);
            MongoCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)ROOM_ID, (Object)room);
            BasicDBObject duration = null;
            if (fromTimestamp != null) {
                duration = new BasicDBObject("$gt", (Object)fromTimestamp);
            }
            if (toTimestamp != null) {
                if (duration == null) {
                    duration = new BasicDBObject("$lt", (Object)toTimestamp);
                } else {
                    duration.append("$lt", (Object)toTimestamp);
                }
            }
            if (duration != null) {
                BasicDBObject ts = new BasicDBObject("timestamp", (Object)duration);
                BasicDBObject updts = new BasicDBObject(LAST_UPDATED_TIMESTAMP, (Object)duration);
                query.put((Object)"$or", (Object)new BasicDBObject[]{ts, updts});
            }
            BasicDBObject sort = new BasicDBObject();
            sort.put((Object)"timestamp", (Object)-1);
            int limit = limitToLoad > 0 ? limitToLoad : (isTextOnly ? this.readTotalTxt : this.readTotalJson);
            sb = new StringBuilder();
            try (MongoCursor messagesCursor = coll.find((Bson)query).sort((Bson)sort).limit(limit).cursor();){
                if (!messagesCursor.hasNext()) {
                    if (isTextOnly) {
                        sb.append("no messages");
                    } else {
                        sb.append("{\"room\": \"").append(room).append("\",\"messages\": []}");
                    }
                    break block26;
                }
                HashMap<String, UserBean> users = new HashMap<String, UserBean>();
                boolean first = true;
                JSONObject data = new JSONObject();
                while (messagesCursor.hasNext()) {
                    String user;
                    UserBean userBean;
                    Document dbo = (Document)messagesCursor.next();
                    String timestamp = dbo.get((Object)"timestamp").toString();
                    if (first && !isTextOnly) {
                        data.put((Object)ROOM, (Object)room);
                        data.put((Object)"timestamp", (Object)timestamp);
                        data.put((Object)MESSAGES, (Object)new JSONArray());
                    }
                    if ((userBean = (UserBean)users.get(user = dbo.get((Object)USER).toString())) == null) {
                        userBean = this.userDataStorage.getUser(user);
                        users.put(user, userBean);
                    }
                    String fullName = userBean.getFullname();
                    if (isTextOnly) {
                        String date = "";
                        try {
                            Date date1 = new Date(Long.parseLong(timestamp));
                            date = this.formatterDate.format(date1);
                        }
                        catch (Exception e) {
                            LOG.info("Message Date Format Error : " + e.getMessage());
                        }
                        StringBuilder line = new StringBuilder();
                        line.append("[").append(date).append("] ");
                        String message = dbo.get((Object)MESSAGE).toString();
                        if ("DELETED".equals(message)) {
                            message = "DELETED";
                        }
                        if (TRUE.equals(dbo.get((Object)IS_SYSTEM))) {
                            line.append("System Message: ");
                            if (message.endsWith(BR)) {
                                message = message.substring(0, message.length() - 5);
                            }
                            line.append(message).append("\n");
                        } else {
                            line.append(fullName).append(": ");
                            message = message.replace(BR, "\n");
                            line.append(message).append("\n");
                        }
                        sb.insert(0, line);
                    } else {
                        MessageBean msg = this.toMessageBean(dbo);
                        msg.setFullName(fullName);
                        msg.setEnabledUser(Boolean.valueOf(userBean.isEnabledUser()));
                        msg.setExternal(userBean.isExternal());
                        ((JSONArray)data.get((Object)MESSAGES)).add((Object)msg.toJSONObject());
                    }
                    first = false;
                }
                if (!isTextOnly) {
                    sb.append(data.toJSONString());
                }
            }
        }
        return sb.toString();
    }

    @Override
    public MessageBean getMessage(String roomId, String messageId) {
        String roomType = this.getTypeRoomChat(roomId);
        MongoCollection coll = this.db().getCollection(M_ROOM_PREFIX + roomType);
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)ROOM_ID, (Object)roomId), Filters.eq((String)ID, (Object)new ObjectId(messageId))});
        Document object = (Document)coll.find(query).first();
        if (object != null) {
            return this.toMessageBean(object);
        }
        return null;
    }

    private void updateRoomTimestamp(String room) {
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson query = Filters.eq((String)ID, (Object)room);
        coll.findOneAndUpdate(query, Updates.set((String)"timestamp", (Object)System.currentTimeMillis()));
    }

    private void ensureIndexInRoom(String type) {
        MongoCollection coll = this.db().getCollection(M_ROOM_PREFIX + type);
        Document doc = new Document();
        Long currentMessageTimestamp = System.currentTimeMillis();
        doc.put("timestamp", (Object)currentMessageTimestamp);
        doc.put(MESSAGE, (Object)"#### TO DELETE ####");
        coll.insertOne((Object)doc);
        ConnectionManager.getInstance().ensureIndexesInRoom(type);
        coll.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"timestamp", (Object)currentMessageTimestamp), Filters.eq((String)MESSAGE, (Object)"#### TO DELETE ####")}));
    }

    @Override
    public String getSpaceRoom(String space) {
        String room = ChatUtils.getRoomId((String)space);
        MongoCollection spaceCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filter = Filters.eq((String)ID, (Object)room);
        try (MongoCursor spacesIterator = spaceCollection.find(filter).cursor();){
            if (!spacesIterator.hasNext()) {
                try {
                    Document document = new Document();
                    document.put(SPACE, (Object)space);
                    document.put(TYPE, (Object)"s");
                    document.put(MEETING_STARTED, (Object)false);
                    document.put(START_TIME, (Object)"");
                    spaceCollection.insertOne((Object)document);
                    this.ensureIndexInRoom("s");
                }
                catch (MongoException me) {
                    LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
                }
            }
        }
        return room;
    }

    @Override
    public String getSpaceRoomByName(String name) {
        String room = null;
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filter = Filters.eq((String)"shortName", (Object)name);
        try (MongoCursor roomIterator = coll.find(filter).cursor();){
            if (roomIterator.hasNext()) {
                Document doc = (Document)roomIterator.next();
                room = doc.get((Object)ID).toString();
            }
        }
        return room;
    }

    @Override
    public String getTeamRoom(String team, String user) {
        String room = ChatUtils.getRoomId((String)team, (String)user);
        MongoCollection teamRoomCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterById = Filters.eq((String)ID, (Object)room);
        try (MongoCursor teamRoomiterator = teamRoomCollection.find(filterById).cursor();){
            if (!teamRoomiterator.hasNext()) {
                try {
                    Document document = new Document();
                    document.put(ID, (Object)room);
                    document.put(TEAM, (Object)team);
                    document.put(USER, (Object)user);
                    document.put(TYPE, (Object)"t");
                    document.put(MEETING_STARTED, (Object)false);
                    document.put(START_TIME, (Object)"");
                    document.put("timestamp", (Object)System.currentTimeMillis());
                    document.put(IS_ENABLED, (Object)true);
                    teamRoomCollection.insertOne((Object)document);
                    this.ensureIndexInRoom("t");
                }
                catch (MongoException me) {
                    LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
                }
            }
        }
        return room;
    }

    @Override
    public String getExternalRoom(String identifier) {
        String room = ChatUtils.getExternalRoomId((String)identifier);
        MongoCollection externalRoomsCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filter = Filters.eq((String)ID, (Object)room);
        try (MongoCursor iterator = externalRoomsCollection.find(filter).cursor();){
            if (!iterator.hasNext()) {
                try {
                    Document document = new Document();
                    document.put("identifier", (Object)identifier);
                    document.put(TYPE, (Object)"e");
                    document.put(IS_ENABLED, (Object)true);
                    externalRoomsCollection.insertOne((Object)document);
                    this.ensureIndexInRoom("e");
                }
                catch (MongoException me) {
                    LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
                }
            }
        }
        return room;
    }

    @Override
    public String getTeamCreator(String room) {
        if (room.indexOf("team-") == 0) {
            room = room.substring("team-".length());
        }
        MongoCollection teamCreatorCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        String creator = "";
        Bson query = Filters.eq((String)ID, (Object)room);
        try (MongoCursor teamCreatorsIterator = teamCreatorCollection.find(query).cursor();){
            if (teamCreatorsIterator.hasNext()) {
                try {
                    Document dbo = (Document)teamCreatorsIterator.next();
                    creator = dbo.get((Object)USER).toString();
                }
                catch (MongoException me) {
                    LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
                }
            }
        }
        return creator;
    }

    @Override
    public void setRoomName(String room, String name) {
        MongoCollection roomsCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterById = Filters.eq((String)ID, (Object)room);
        try (MongoCursor roomsIterator = roomsCollection.find(filterById).cursor();){
            if (roomsIterator.hasNext()) {
                roomsCollection.updateOne(filterById, Updates.set((String)TEAM, (Object)name));
            }
        }
    }

    @Override
    public boolean isRoomEnabled(String room) {
        boolean isEnabled;
        block9: {
            isEnabled = true;
            MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
            Bson filterById = Filters.eq((String)ID, (Object)room);
            try (MongoCursor roomsIterator = coll.find(filterById).cursor();){
                if (!roomsIterator.hasNext()) break block9;
                try {
                    Document doc = (Document)roomsIterator.next();
                    if (doc.get((Object)IS_ENABLED) != null) {
                        isEnabled = StringUtils.equals((CharSequence)doc.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE);
                        break block9;
                    }
                    coll.updateOne(filterById, Updates.set((String)IS_ENABLED, (Object)true));
                }
                catch (MongoException me) {
                    LOG.severe(me.getCode() + " : " + room + " : " + me.getMessage());
                }
            }
        }
        return isEnabled;
    }

    @Override
    public void setRoomEnabled(String room, boolean enabled) {
        MongoCollection roomCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterById = Filters.eq((String)ID, (Object)room);
        try (MongoCursor cursor = roomCollection.find(filterById).cursor();){
            if (cursor.hasNext()) {
                roomCollection.updateOne(filterById, Updates.set((String)IS_ENABLED, (Object)enabled));
            }
        }
    }

    @Override
    public void setRoomMeetingStatus(String room, boolean start, String startTime) {
        MongoCollection roomCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterById = Filters.eq((String)ID, (Object)room);
        try (MongoCursor roomIterator = roomCollection.find(filterById).cursor();){
            if (roomIterator.hasNext()) {
                Bson updateDocument = Updates.combine((Bson[])new Bson[]{Updates.set((String)MEETING_STARTED, (Object)start), Updates.set((String)START_TIME, (Object)startTime)});
                roomCollection.updateOne(filterById, updateDocument);
            }
        }
    }

    @Override
    public String getRoom(List<String> users) {
        Collections.sort(users);
        String room = ChatUtils.getRoomId(users);
        MongoCollection roomCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterById = Filters.eq((String)ID, (Object)room);
        try (MongoCursor roomIterator = roomCollection.find(filterById).iterator();){
            if (!roomIterator.hasNext()) {
                try {
                    Document document = new Document();
                    document.put(ID, (Object)room);
                    document.put(USERS, users);
                    document.put(TYPE, (Object)"u");
                    document.put(IS_ENABLED, (Object)true);
                    roomCollection.insertOne((Object)document);
                    this.ensureIndexInRoom("u");
                }
                catch (MongoException me) {
                    LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
                }
            }
        }
        return room;
    }

    @Override
    public String getTypeRoomChat(String roomId) {
        MongoCollection roomsCollection = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterById = Filters.eq((String)ID, (Object)roomId);
        MongoCursor roomsIterator = roomsCollection.find(filterById).iterator();
        String roomType = "";
        while (roomsIterator.hasNext()) {
            Document doc = (Document)roomsIterator.next();
            roomType = (String)doc.get((Object)TYPE);
        }
        return roomType;
    }

    @Override
    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        Bson filterByUsers = Filters.eq((String)USERS, (Object)user);
        try (MongoCursor cursor = coll.find(filterByUsers).cursor();){
            while (cursor.hasNext()) {
                String creator;
                Document dbo = (Document)cursor.next();
                String roomId = dbo.get((Object)ID).toString();
                long timestamp = -1L;
                if (dbo.containsKey((Object)"timestamp")) {
                    timestamp = (Long)dbo.get((Object)"timestamp");
                }
                List users = (List)dbo.get((Object)USERS);
                users.remove(user);
                if (users.isEmpty() || user.equals(users.get(0))) continue;
                String targetUser = (String)users.get(0);
                UserBean targetUserBean = this.userDataStorage.getUser(targetUser);
                boolean isDemoUser = tokenService.isDemoUser(targetUser);
                if (isAdmin && (!isAdmin || (withPublic || isDemoUser) && (!withPublic || !isDemoUser))) continue;
                RoomBean roomBean = new RoomBean();
                roomBean.setRoom(roomId);
                roomBean.setEnabledUser(targetUserBean.isEnabled());
                roomBean.setExternal(targetUserBean.isExternal());
                roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", ROOM, roomId));
                roomBean.setUser((String)users.get(0));
                roomBean.setTimestamp(timestamp);
                roomBean.setType((String)dbo.get((Object)TYPE));
                if (dbo.containsKey((Object)IS_ENABLED)) {
                    roomBean.setEnabledRoom(StringUtils.equals((CharSequence)dbo.get((Object)IS_ENABLED).toString(), (CharSequence)TRUE));
                }
                if (dbo.containsKey((Object)MEETING_STARTED)) {
                    roomBean.setMeetingStarted(((Boolean)dbo.get((Object)MEETING_STARTED)).booleanValue());
                }
                if (dbo.containsKey((Object)START_TIME)) {
                    roomBean.setStartTime((String)dbo.get((Object)START_TIME));
                }
                if (StringUtils.isNotBlank((CharSequence)(creator = (String)dbo.get((Object)USER)))) {
                    roomBean.setAdmins(new String[]{creator});
                }
                rooms.add(roomBean);
            }
        }
        return rooms;
    }

    @Override
    public RoomsBean getRooms(String user, List<String> onlineUsers, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, int limit, NotificationService notificationService, TokenService tokenService) {
        List<Object> rooms;
        UserBean userBean = this.userDataStorage.getUser(user, true);
        int unreadOffline = 0;
        int unreadOnline = 0;
        if (withUsers) {
            rooms = this.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService);
            if (isAdmin) {
                rooms.addAll(this.getExistingRooms("__support_", withPublic, isAdmin, notificationService, tokenService));
            }
            Map availableUsers = tokenService.getActiveUsersFilterBy(user, onlineUsers, withUsers, withPublic, isAdmin, limit);
            ArrayList<RoomBean> roomsOffline = new ArrayList<RoomBean>();
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getUser();
                roomBean.setFavorite(userBean.isFavorite(roomBean.getRoom()));
                if (availableUsers.containsKey(targetUser)) {
                    UserBean userBean2 = (UserBean)availableUsers.remove(targetUser);
                    roomBean.setFullName(userBean2.getFullname());
                    roomBean.setExternal(userBean2.isExternal());
                    roomBean.setStatus(userBean2.getStatus());
                    roomBean.setAvailableUser(true);
                    if (roomBean.getUnreadTotal() <= 0) continue;
                    unreadOnline += roomBean.getUnreadTotal();
                    continue;
                }
                UserBean userBean3 = this.userDataStorage.getUser(targetUser);
                roomBean.setFullName(userBean3.getFullname());
                roomBean.setExternal(userBean3.isExternal());
                roomBean.setAvailableUser(false);
                if (!withOffline) {
                    roomsOffline.add(roomBean);
                }
                if (roomBean.getUnreadTotal() <= 0) continue;
                unreadOffline += roomBean.getUnreadTotal();
            }
            if (!withOffline) {
                for (RoomBean roomBean : roomsOffline) {
                    rooms.remove(roomBean);
                }
            }
            for (UserBean userBean4 : availableUsers.values()) {
                String status = userBean4.getStatus();
                if (!withOffline && (withOffline || "invisible".equals(status) || "offline".equals(status))) continue;
                RoomBean roomBean = new RoomBean();
                roomBean.setUser(userBean4.getName());
                roomBean.setFullName(userBean4.getFullname());
                roomBean.setExternal(userBean4.isExternal());
                roomBean.setStatus(userBean4.getStatus());
                roomBean.setAvailableUser(true);
                roomBean.setType("u");
                rooms.add(roomBean);
            }
        } else {
            rooms = new ArrayList();
        }
        int unreadSpaces = 0;
        List<SpaceBean> spaces = this.userDataStorage.getSpaces(user);
        for (SpaceBean spaceBean : spaces) {
            RoomBean room = new RoomBean();
            room.setUser("space-" + spaceBean.getRoom());
            room.setRoom(spaceBean.getRoom());
            room.setFullName(spaceBean.getDisplayName());
            room.setStatus(SPACE);
            room.setTimestamp(spaceBean.getTimestamp());
            room.setAvailableUser(true);
            room.setType("s");
            room.setPrettyName(spaceBean.getPrettyName());
            room.setGroupId(spaceBean.getGroupId());
            String string = this.getSpaceRoom("space-" + spaceBean.getRoom());
            room.setEnabledRoom(this.isRoomEnabled(string));
            room.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", ROOM, string));
            if (room.getUnreadTotal() > 0) {
                unreadSpaces += room.getUnreadTotal();
            }
            room.setFavorite(userBean.isFavorite(room.getRoom()));
            if (!withSpaces) continue;
            rooms.add(room);
        }
        int unreadTeams = 0;
        List<RoomBean> list = this.userDataStorage.getTeams(user);
        for (RoomBean roomBean : list) {
            RoomBean roomBean2 = new RoomBean();
            roomBean2.setUser("team-" + roomBean.getRoom());
            roomBean2.setRoom(roomBean.getRoom());
            roomBean2.setFullName(roomBean.getFullName());
            roomBean2.setExternal(roomBean.isExternal());
            roomBean2.setStatus(TEAM);
            roomBean2.setTimestamp(roomBean.getTimestamp());
            roomBean2.setAvailableUser(true);
            roomBean2.setType(roomBean.getType());
            roomBean2.setMeetingStarted(roomBean.isMeetingStarted());
            roomBean2.setEnabledRoom(roomBean.isEnabledRoom());
            roomBean2.setStartTime(roomBean.getStartTime());
            roomBean2.setAdmins(roomBean.getAdmins());
            roomBean2.setEnabledRoom(roomBean.isEnabledRoom());
            roomBean2.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", ROOM, roomBean.getRoom()));
            if (roomBean2.getUnreadTotal() > 0) {
                unreadTeams += roomBean2.getUnreadTotal();
            }
            roomBean2.setFavorite(userBean.isFavorite(roomBean2.getRoom()));
            if (!withSpaces) continue;
            rooms.add(roomBean2);
        }
        List<Object> finalRooms = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getFullName();
                if (!this.filter(targetUser, filter)) continue;
                finalRooms.add(roomBean);
            }
        } else {
            finalRooms = rooms;
        }
        finalRooms = finalRooms.stream().filter(RoomBean::isEnabledRoom).collect(Collectors.toList());
        RoomsBean roomsBean = new RoomsBean();
        roomsBean.setRooms(finalRooms);
        roomsBean.setUnreadOffline(unreadOffline);
        roomsBean.setUnreadOnline(unreadOnline);
        roomsBean.setUnreadSpaces(unreadSpaces);
        roomsBean.setUnreadTeams(unreadTeams);
        roomsBean.setRoomsCount(finalRooms.size());
        return roomsBean;
    }

    @Override
    public RoomsBean getUserRooms(String user, List<String> onlineUsers, String filter, int offset, int limit, NotificationService notificationService, TokenService tokenService) {
        return this.getUserRooms(user, onlineUsers, filter, offset, limit, notificationService, tokenService, null);
    }

    @Override
    public RoomsBean getUserRooms(String user, List<String> onlineUsers, String filter, int offset, int limit, NotificationService notificationService, TokenService tokenService, String roomType) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        int unreadOffline = 0;
        int unreadOnline = 0;
        int unreadSpaces = 0;
        int unreadTeams = 0;
        int unreadSilentRooms = 0;
        int roomsCount = 0;
        UserBean userBean = this.userDataStorage.getUser(user, true);
        MongoCollection coll = this.db().getCollection(USERS);
        Bson filterByUser = Filters.eq((String)USER, (Object)user);
        try (MongoCursor userRooms = coll.find(filterByUser).cursor();){
            if (userRooms.hasNext()) {
                ArrayList roomsIds = new ArrayList();
                ArrayList<Bson> andList = new ArrayList<Bson>();
                ArrayList<Bson> orList = new ArrayList<Bson>();
                Document doc = (Document)userRooms.next();
                if ("Favorites".equals(roomType)) {
                    List favoriteRoomsIds = userBean.getFavorites();
                    if (favoriteRoomsIds != null) {
                        orList.add(Filters.in((String)ID, (Iterable)favoriteRoomsIds));
                    }
                } else {
                    ArrayList teams;
                    ArrayList spaces;
                    if ((StringUtils.isBlank((CharSequence)roomType) || "s".equals(roomType)) && (spaces = (ArrayList)doc.get((Object)"spaces")) != null) {
                        roomsIds.addAll(spaces);
                    }
                    if ((StringUtils.isBlank((CharSequence)roomType) || "t".equals(roomType)) && (teams = (ArrayList)doc.get((Object)"teams")) != null) {
                        roomsIds.addAll(teams);
                    }
                    orList.add(Filters.in((String)ID, (Iterable)roomsIds));
                    if (StringUtils.isBlank((CharSequence)roomType) || "u".equals(roomType)) {
                        orList.add(Filters.eq((String)USERS, (Object)user));
                    }
                }
                Bson roomsQuery = Filters.and(andList);
                ArrayList<Bson> enabledRoomOrList = new ArrayList<Bson>();
                enabledRoomOrList.add(Filters.eq((String)IS_ENABLED, (Object)true));
                enabledRoomOrList.add(Filters.exists((String)IS_ENABLED, (boolean)false));
                andList.add(Filters.or(enabledRoomOrList));
                andList.add(Filters.or(orList));
                roomsCount = this.db().getCollection(M_ROOMS_COLLECTION).find(roomsQuery).cursor().available();
                MongoCursor roomsCursor = StringUtils.isBlank((CharSequence)filter) ? this.db().getCollection(M_ROOMS_COLLECTION).find(roomsQuery).sort(Sorts.descending((String[])new String[]{"timestamp"})).skip(offset).limit(limit).cursor() : this.db().getCollection(M_ROOMS_COLLECTION).find(roomsQuery).sort(Sorts.descending((String[])new String[]{"timestamp"})).limit(100).cursor();
                while (roomsCursor.hasNext()) {
                    Document room = (Document)roomsCursor.next();
                    RoomBean roomBean = this.convertToBean(userBean, onlineUsers, room, notificationService);
                    if (roomBean.getUnreadTotal() > 0) {
                        switch (roomBean.getType()) {
                            case "u": {
                                if (roomBean.isActive()) {
                                    unreadOnline += roomBean.getUnreadTotal();
                                    break;
                                }
                                unreadOffline += roomBean.getUnreadTotal();
                                break;
                            }
                            case "s": {
                                unreadSpaces += roomBean.getUnreadTotal();
                                if (!roomBean.isRoomSilent()) break;
                                unreadSilentRooms += roomBean.getUnreadTotal();
                                break;
                            }
                            case "t": {
                                unreadTeams += roomBean.getUnreadTotal();
                                if (!roomBean.isRoomSilent()) break;
                                unreadSilentRooms += roomBean.getUnreadTotal();
                            }
                        }
                    }
                    rooms.add(roomBean);
                }
            }
        }
        ArrayList<RoomBean> finalRooms = new ArrayList<RoomBean>();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            roomsCount = 0;
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getFullName();
                if (this.filter(targetUser, filter)) {
                    finalRooms.add(roomBean);
                }
                ++roomsCount;
            }
        } else {
            finalRooms = rooms;
        }
        RoomsBean roomsBean = new RoomsBean();
        roomsBean.setRooms(finalRooms);
        roomsBean.setUnreadOffline(unreadOffline);
        roomsBean.setUnreadOnline(unreadOnline);
        roomsBean.setUnreadSpaces(unreadSpaces);
        roomsBean.setUnreadTeams(unreadTeams);
        roomsBean.setRoomsCount(roomsCount);
        roomsBean.setUnreadSilentRooms(unreadSilentRooms);
        return roomsBean;
    }

    private RoomBean convertToBean(UserBean userBean, List<String> onlineUsers, Document room, NotificationService notificationService) {
        String type = room.get((Object)TYPE).toString();
        String roomId = room.get((Object)ID).toString();
        RoomBean roomBean = new RoomBean();
        switch (type) {
            case "t": {
                roomBean.setUser("team-" + roomId);
                roomBean.setStatus(TEAM);
                roomBean.setAvailableUser(true);
                roomBean.setFullName(room.get((Object)TEAM).toString());
                roomBean.setType("t");
                roomBean.setFavorite(userBean.isFavorite(roomId));
                if (!StringUtils.isNotBlank((CharSequence)roomBean.getUser())) break;
                roomBean.setAdmins(new String[]{room.get((Object)USER).toString()});
                break;
            }
            case "u": {
                List users = (List)room.get((Object)USERS);
                users.remove(userBean.getName());
                if (users.isEmpty()) break;
                String targetUser = (String)users.get(0);
                UserBean targetUserBean = this.userDataStorage.getUser(targetUser);
                roomBean.setFullName(targetUserBean.getFullname());
                roomBean.setFavorite(userBean.isFavorite(room.get((Object)ID).toString()));
                roomBean.setEnabledUser(Boolean.valueOf(targetUserBean.isEnabledUser()));
                roomBean.setExternal(targetUserBean.isExternal());
                if (onlineUsers.contains(targetUser)) {
                    roomBean.setAvailableUser(true);
                    roomBean.setStatus(this.userDataStorage.getStatus(targetUser));
                } else {
                    roomBean.setAvailableUser(false);
                    roomBean.setStatus("offline");
                }
                roomBean.setUser(targetUser);
                roomBean.setType("u");
                break;
            }
            case "s": {
                roomBean.setUser("space-" + roomId);
                roomBean.setFullName(room.get((Object)"displayName").toString());
                roomBean.setStatus(SPACE);
                roomBean.setType("s");
                roomBean.setAvailableUser(true);
                roomBean.setType("s");
                roomBean.setGroupId(room.get((Object)"groupId").toString());
                if (room.containsKey((Object)"prettyName")) {
                    roomBean.setPrettyName(room.get((Object)"prettyName").toString());
                }
                roomBean.setFavorite(userBean.isFavorite(roomId));
            }
        }
        roomBean.setRoom(roomId);
        roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(userBean.getName(), "chat", ROOM, roomId));
        boolean isSilent = notificationService.isRoomSilentForUser(userBean.getName(), roomId);
        roomBean.setRoomSilent(isSilent);
        if (room.containsKey((Object)MEETING_STARTED)) {
            roomBean.setMeetingStarted(((Boolean)room.get((Object)MEETING_STARTED)).booleanValue());
        }
        if (room.containsKey((Object)START_TIME)) {
            roomBean.setStartTime((String)room.get((Object)START_TIME));
        }
        if (room.containsKey((Object)"timestamp")) {
            roomBean.setTimestamp(((Long)room.get((Object)"timestamp")).longValue());
        }
        return roomBean;
    }

    private boolean filter(String user, String filter) {
        if (user == null || filter == null || "".equals(filter)) {
            return true;
        }
        String[] args = filter.toLowerCase().split(" ");
        String s = user.toLowerCase();
        for (String arg : args) {
            int ind = s.indexOf(arg);
            if (ind == -1) {
                return false;
            }
            s = s.substring(ind);
        }
        return true;
    }

    @Override
    public int getNumberOfRooms() {
        MongoCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        FindIterable rooms = coll.find(Filters.empty());
        return rooms.cursor().available();
    }

    @Override
    public int getNumberOfMessages() {
        String[] roomTypes;
        int nb = 0;
        for (String type : roomTypes = new String[]{"u", "s", "t", "e"}) {
            MongoCollection collaboration = this.db().getCollection(M_ROOM_PREFIX + type);
            Document queryMessages = new Document();
            MongoCursor messagesCursor = collaboration.find((Bson)queryMessages).cursor();
            nb += messagesCursor.available();
        }
        return nb;
    }

    private MessageBean toMessageBean(Document dbo) {
        MessageBean msg = new MessageBean();
        msg.setId(dbo.get((Object)ID).toString());
        msg.setUser(dbo.get((Object)USER).toString());
        msg.setMessage(dbo.get((Object)MESSAGE).toString());
        msg.setTimestamp(Long.parseLong(dbo.get((Object)"timestamp").toString()));
        if (dbo.containsKey((Object)LAST_UPDATED_TIMESTAMP)) {
            msg.setLastUpdatedTimestamp(Long.parseLong(dbo.get((Object)LAST_UPDATED_TIMESTAMP).toString()));
        }
        msg.setSystem(Boolean.parseBoolean(dbo.get((Object)IS_SYSTEM).toString()));
        if (dbo.containsKey((Object)OPTIONS)) {
            msg.setOptions(dbo.get((Object)OPTIONS).toString());
        }
        if (dbo.containsKey((Object)TYPE)) {
            msg.setType(dbo.get((Object)TYPE).toString());
        }
        return msg;
    }
}

