/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.services.UserService;
import org.json.JSONException;
import org.json.simple.JSONObject;

@Named(value="userService")
@ApplicationScoped
@Singleton
public class UserServiceImpl
implements UserService {
    private static final Logger LOG = Logger.getLogger(UserServiceImpl.class.getName());
    @Inject
    private UserDataStorage userStorage;
    @Inject
    private RealTimeMessageService realTimeMessageService;

    public void toggleFavorite(String user, String targetUser) {
        if (this.isFavorite(user, targetUser)) {
            this.removeFavorite(user, targetUser);
        } else {
            this.addFavorite(user, targetUser);
        }
    }

    public void addFavorite(String user, String room) {
        this.userStorage.addFavorite(user, room);
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.FAVORITE_ADDED, room, user, new Date(), null);
        this.realTimeMessageService.sendMessage(messageBean, user);
    }

    public void removeFavorite(String user, String room) {
        this.userStorage.removeFavorite(user, room);
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.FAVORITE_REMOVED, room, user, new Date(), null);
        this.realTimeMessageService.sendMessage(messageBean, user);
    }

    public void setPreferredNotification(String user, String notifManner) throws Exception {
        this.userStorage.setPreferredNotification(user, notifManner);
    }

    public void setNotificationTrigger(String user, String notifCond) throws Exception {
        this.userStorage.setNotificationTrigger(user, notifCond);
    }

    public void setRoomNotificationTrigger(String user, String room, String notifCondition, String notifConditionType, long time) throws Exception {
        this.userStorage.setRoomNotificationTrigger(user, room, notifCondition, notifConditionType, time);
    }

    public NotificationSettingsBean getUserDesktopNotificationSettings(String user) throws JSONException {
        return this.userStorage.getUserDesktopNotificationSettings(user);
    }

    public boolean isFavorite(String user, String targetUser) {
        return this.userStorage.isFavorite(user, targetUser);
    }

    public void addUserFullName(String user, String fullname) {
        this.userStorage.addUserFullName(user, fullname);
    }

    public void addUserEmail(String user, String email) {
        this.userStorage.addUserEmail(user, email);
    }

    public void deleteUser(String user) {
        this.userStorage.deleteUser(user);
    }

    public void setEnabledUser(String user, Boolean isEnabled) {
        this.userStorage.setEnabledUser(user, isEnabled);
    }

    public void setExternalUser(String user, String isExternal) {
        this.userStorage.setExternalUser(user, isExternal);
    }

    public void setSpaces(String user, List<SpaceBean> spaces) {
        this.userStorage.setSpaces(user, spaces);
    }

    public void removeUserFromSpace(String user, SpaceBean space) {
        this.userStorage.removeUserFromSpace(user, space);
    }

    public void addTeamRoom(String user, String teamRoomId) {
        this.userStorage.addTeamRoom(user, teamRoomId);
        JSONObject data = this.getRoom(user, teamRoomId).toJSONObject();
        RealTimeMessageBean joinRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_MEMBER_JOIN, teamRoomId, user, new Date(), (Map)data);
        this.realTimeMessageService.sendMessage(joinRoomMessage, user);
    }

    public void addTeamUsers(String teamRoomId, List<String> users) {
        for (String user : users) {
            this.addTeamRoom(user, teamRoomId);
        }
    }

    public void removeTeamUsers(String teamRoomId, List<String> users) {
        this.userStorage.removeTeamUsers(teamRoomId, users);
    }

    public List<RoomBean> getTeams(String user) {
        return this.userStorage.getTeams(user);
    }

    public RoomBean getRoom(String user, String roomId) {
        return this.userStorage.getRoom(user, roomId);
    }

    public List<SpaceBean> getSpaces(String user) {
        return this.userStorage.getSpaces(user);
    }

    public List<UserBean> getUsersInRoomChatOneToOne(String roomId) {
        return this.userStorage.getUsersInRoomChatOneToOne(roomId);
    }

    public List<UserBean> getUsers(String roomId) {
        return this.userStorage.getUsers(roomId, null, 0);
    }

    public List<UserBean> getUsers(String filter, boolean fullBean) {
        return this.userStorage.getUsers(null, filter, 0);
    }

    public List<UserBean> getUsers(String roomId, String filter, int limit) {
        return this.userStorage.getUsers(roomId, filter, limit);
    }

    public List<UserBean> getUsers(String roomId, List<String> onlineUsers, String filter, int limit, boolean onlyOnlineUsers) {
        return this.userStorage.getUsers(roomId, onlineUsers, filter, limit, onlyOnlineUsers);
    }

    public String setStatus(String user, String status) {
        return this.userStorage.setStatus(user, status);
    }

    public void setAsAdmin(String user, boolean isAdmin) {
        this.userStorage.setAsAdmin(user, isAdmin);
    }

    public boolean isAdmin(String user) {
        return this.userStorage.isAdmin(user);
    }

    public String getStatus(String user) {
        return this.userStorage.getStatus(user);
    }

    public String getUserFullName(String user) {
        return this.userStorage.getUserFullName(user);
    }

    public UserBean getUser(String user) {
        return this.getUser(user, false);
    }

    public UserBean getUser(String user, boolean withFavorites) {
        return this.userStorage.getUser(user, withFavorites);
    }

    public List<String> getUsersFilterBy(String user, String room, String type) {
        return this.userStorage.getUsersFilterBy(user, room, type);
    }

    public int getNumberOfUsers() {
        return this.userStorage.getNumberOfUsers();
    }

    public long getUsersCount(String room, String filter) {
        return this.userStorage.getUsersCount(room, filter);
    }

    public long getActiveUsersCount(String room, String filter) {
        return this.userStorage.getUsersCount(room, filter, true);
    }
}

