/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.exoplatform.addons.chat.model.MentionModel;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class NotificationUtils {
    public static final ArgumentLiteral<MentionModel> MENTION_MODEL = new ArgumentLiteral(MentionModel.class, "mention_model");
    public static final String CHAT_MENTION_NOTIFICATION_PLUGIN = "ChatMentionNotificationPlugin";
    public static final PluginKey CHAT_MENTION_KEY = PluginKey.key((String)"ChatMentionNotificationPlugin");
    private static String defaultSite;

    public static final void setNotificationRecipients(NotificationInfo notification, List<String> users) {
        notification.to(users);
    }

    public static final TemplateContext buildTemplateParameters(TemplateProvider templateProvider, NotificationInfo notification) {
        String language = NotificationPluginUtils.getLanguage((String)notification.getTo());
        TemplateContext templateContext = NotificationUtils.getTemplateContext(templateProvider, notification, language);
        Boolean isRead = Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
        templateContext.put((Object)"READ", (Object)(isRead != null && isRead != false ? "read" : "unread"));
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"ROOM_ID", (Object)notification.getValueOwnerParameter("roomId"));
        templateContext.put((Object)"ROOM_NAME", (Object)notification.getValueOwnerParameter("roomName"));
        templateContext.put((Object)"USER", (Object)notification.getValueOwnerParameter("senderFullName"));
        templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)notification.getTo()));
        templateContext.put((Object)"CHAT_URL", (Object)NotificationUtils.getRoomURL(notification.getValueOwnerParameter("roomId")));
        String userAvatar = "/portal/rest/v1/social/users/{}/avatar".replace("{}", notification.getValueOwnerParameter("sender"));
        templateContext.put((Object)"AVATAR", (Object)userAvatar);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
        return templateContext;
    }

    private static final TemplateContext getTemplateContext(TemplateProvider templateProvider, NotificationInfo notification, String language) {
        PluginKey pluginKey = notification.getKey();
        String pluginId = pluginKey.getId();
        ChannelKey channelKey = templateProvider.getChannelKey();
        return TemplateContext.newChannelInstance((ChannelKey)channelKey, (String)pluginId, (String)language);
    }

    public static String getDefaultSite() {
        if (defaultSite != null) {
            return defaultSite;
        }
        UserPortalConfigService portalConfig = (UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class);
        defaultSite = portalConfig.getDefaultPortal();
        return defaultSite;
    }

    public static String getRoomURL(String roomId) {
        String currentSite = NotificationUtils.getDefaultSite();
        String currentDomain = CommonsUtils.getCurrentDomain();
        if (!currentDomain.endsWith("/")) {
            currentDomain = currentDomain + "/";
        }
        String notificationURL = "";
        notificationURL = roomId != null ? currentDomain + "portal/" + currentSite + "/chat?roomId=" + roomId : currentDomain + "portal/" + currentSite + "/chat";
        return notificationURL;
    }
}

