/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ServerBootstrap {
    private static final Log LOG = ExoLogger.getLogger((String)ServerBootstrap.class.getName());
    private static String serverURL = null;
    private static String serviceURL = null;
    private static String serverURI = null;

    public static String getStatus(String username, String token, String targetUser) {
        return ServerBootstrap.callServer("getStatus", "user=" + username + "&targetUser=" + targetUser + "&token=" + token);
    }

    public static String getUsers(String username, String token, String room) {
        return ServerBootstrap.callServer("users", "user=" + username + "&room=" + room + "&token=" + token);
    }

    public static String getUserFullName(String username) {
        return ServerBootstrap.callServer("getUserFullName", "username=" + username);
    }

    public static String shouldUpdate(String user) {
        return ServerBootstrap.callServer("shouldUpdate", "user=" + user);
    }

    public static void addUser(String username, String token) {
        ServerBootstrap.postServer("addUser", "username=" + username + "&token=" + token);
    }

    public static void logout(String username, String token, String sessionId, boolean uniqueSession) {
        ServerBootstrap.postServer("logout", "username=" + username + "&token=" + token + "&sessionId=" + sessionId + "&uniqueSession=" + uniqueSession);
    }

    public static void setAsAdmin(String username, boolean isAdmin) {
        ServerBootstrap.postServer("setAsAdmin", "username=" + username + "&isAdmin=" + isAdmin);
    }

    public static void addUserFullNameAndEmail(String username, String fullname, String email) {
        try {
            ServerBootstrap.postServer("addUserFullNameAndEmail", "username=" + username + "&fullname=" + URLEncoder.encode(ChatUtils.toString((Serializable)((Object)fullname)), "UTF-8") + "&email=" + email);
        }
        catch (IOException e) {
            LOG.error("Error while updating user information for user {} [ {} ]", new Object[]{username, email, e});
        }
    }

    public static void deleteUser(String username) {
        ServerBootstrap.postServer("deleteUser", "username=" + username);
    }

    public static void setEnabledUser(String username, Boolean enabled) {
        ServerBootstrap.postServer("setEnabledUser", "username=" + username + "&enabled=" + enabled);
    }

    public static void setExternalUser(String username, String external) {
        ServerBootstrap.postServer("setExternalUser", "username=" + username + "&external=" + external);
    }

    public static String getToken(String username) {
        String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
        String in = username + passphrase;
        String token = MessageDigester.getHash((String)in);
        return token;
    }

    public static void saveSpaces(String username) {
        try {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            ListAccess spacesListAccess = spaceService.getAccessibleSpacesWithListAccess(username);
            List<Space> spaces = Arrays.asList((Space[])spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                spaceBean.setPrettyName(space.getPrettyName());
                beans.add(spaceBean);
            }
            ServerBootstrap.setSpaces(username, new SpaceBeans(beans));
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while initializing spaces of User '" + username + "'"), (Throwable)e);
        }
    }

    public static void setSpaces(String username, SpaceBeans beans) {
        String params = "username=" + username;
        String serSpaces = "";
        try {
            serSpaces = ChatUtils.toString((Serializable)beans);
            serSpaces = URLEncoder.encode(serSpaces, "UTF-8");
        }
        catch (IOException e) {
            LOG.error((Object)"Error encoding spaces", (Throwable)e);
        }
        params = params + "&spaces=" + serSpaces;
        ServerBootstrap.postServer("setSpaces", params);
    }

    private static String callServer(String serviceUri, String params) {
        String serverURLBase = ServerBootstrap.getServiceURL() + "/" + serviceUri;
        String serviceUrl = serverURLBase + "?passphrase=" + PropertyManager.getProperty((String)"chatPassPhrase") + "&" + params;
        String body = null;
        try {
            URL url = new URL(serviceUrl);
            URLConnection con = url.openConnection();
            InputStream in = con.getInputStream();
            String encoding = con.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            body = IOUtils.toString((InputStream)in, (String)encoding);
            if ("null".equals(body)) {
                body = null;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Malformed URI " + serverURLBase), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not establish connection to URL " + serverURLBase), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error occurred while sending request to " + serverURLBase), (Throwable)e);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String postServer(String serviceUri, String params) {
        String serviceUrl = ServerBootstrap.getServiceURL() + "/" + serviceUri;
        String allParams = "passphrase=" + PropertyManager.getProperty((String)"chatPassPhrase") + "&" + params;
        String body = null;
        OutputStreamWriter writer = null;
        try {
            URL url = new URL(serviceUrl);
            URLConnection con = url.openConnection();
            int timeout = Integer.parseInt(PropertyManager.getProperty((String)"request.timeout"));
            con.setConnectTimeout(timeout);
            con.setReadTimeout(timeout);
            con.setDoOutput(true);
            writer = new OutputStreamWriter(con.getOutputStream());
            writer.write(allParams);
            writer.flush();
            InputStream in = con.getInputStream();
            String encoding = con.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            body = IOUtils.toString((InputStream)in, (String)encoding);
            if ("null".equals(body)) {
                body = null;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Malformed URL " + serviceUrl), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error converting input stream", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error occurred while sending request to " + serviceUrl), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when closing writer", (Throwable)e);
                }
            }
        }
        return body;
    }

    public static String getServerURL() {
        if (StringUtils.isBlank((String)serverURL)) {
            serverURL = PropertyManager.getProperty((String)"chatServerUrl");
        }
        if (StringUtils.isNotBlank((String)serverURL) && serverURL.startsWith("http")) {
            return serverURL;
        }
        serverURL = ChatUtils.getServerBase() + ServerBootstrap.getServerURI();
        return serverURL;
    }

    public static String getServiceURL() {
        if (serviceURL != null) {
            return serviceURL;
        }
        serviceURL = PropertyManager.getProperty((String)"chatServiceUrl");
        if (StringUtils.isBlank((String)serviceURL)) {
            serviceURL = ServerBootstrap.getServerURL();
        }
        return serviceURL;
    }

    public static String getServerURI() {
        if (StringUtils.isBlank((String)serverURI)) {
            serverURI = PropertyManager.getProperty((String)"chatServerUrl");
        }
        return serverURI;
    }

    public static void init(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((String)ChatUtils.getServerBase())) {
            String scheme = request.getScheme();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String serverBase = scheme + "://" + serverName;
            if (serverPort != 80) {
                serverBase = serverBase + ":" + serverPort;
            }
            ChatUtils.initServerBase((String)serverBase);
        }
    }
}

