/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceMembershipListener
extends SpaceListenerPlugin {
    public void grantedLead(SpaceLifeCycleEvent event) {
        this.saveSpaces(event.getTarget());
    }

    public void joined(SpaceLifeCycleEvent event) {
        this.saveSpaces(event.getTarget());
    }

    public void left(SpaceLifeCycleEvent event) {
        this.saveSpaces(event.getTarget());
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        this.saveSpaces(event.getTarget());
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        this.refreshSpaceChatRoom(space);
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        this.refreshSpaceChatRoom(space);
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        this.refreshSpaceChatRoom(space);
    }

    private void refreshSpaceChatRoom(Space space) {
        String[] members = space.getMembers();
        if (members != null) {
            for (String username : members) {
                this.saveSpaces(username);
            }
        }
    }

    private void saveSpaces(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            ServerBootstrap.saveSpaces(username);
        }
    }
}

