/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.benjp.listener.ConnectionManager;
import org.benjp.model.RoomBean;
import org.benjp.model.RoomsBean;
import org.benjp.model.SpaceBean;
import org.benjp.model.UserBean;
import org.benjp.services.NotificationService;
import org.benjp.services.TokenService;
import org.benjp.services.UserService;
import org.benjp.utils.MessageDigester;
import org.benjp.utils.PropertyManager;
import org.bson.types.ObjectId;

@Named(value="chatService")
@ApplicationScoped
public class ChatService {
    public static final String M_ROOM_PREFIX = "room_";
    public static final String M_ROOMS_COLLECTION = "rooms";
    public static final String SPACE_PREFIX = "space-";
    public static final String TYPE_DELETED = "DELETED";
    public static final String TYPE_EDITED = "EDITED";
    private static Logger log = Logger.getLogger("ChatService");
    private long readMillis;
    private int readTotalJson;
    private int readTotalTxt;

    public ChatService() {
        long readDays = Long.parseLong(PropertyManager.getProperty("chatReadDays"));
        this.readMillis = readDays * 24L * 60L * 60L * 1000L;
        this.readTotalJson = Integer.parseInt(PropertyManager.getProperty("chatReadTotalJson"));
        this.readTotalTxt = Integer.parseInt(PropertyManager.getProperty("chatReadTotalTxt"));
    }

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    public void write(String message, String user, String room, String isSystem) {
        this.write(message, user, room, isSystem, null);
    }

    public void write(String message, String user, String room, String isSystem, String options) {
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + room);
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        BasicDBObject doc = new BasicDBObject();
        doc.put("user", (Object)user);
        doc.put("message", (Object)message);
        doc.put("time", (Object)new Date());
        doc.put("timestamp", (Object)System.currentTimeMillis());
        doc.put("isSystem", (Object)isSystem);
        if (options != null) {
            options = options.replaceAll("<", "&lt;");
            options = options.replaceAll(">", "&gt;");
            doc.put("options", (Object)options);
        }
        coll.insert(new DBObject[]{doc});
        this.updateRoomTimestamp(room);
    }

    public void delete(String room, String user, String messageId) {
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + room);
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)new ObjectId(messageId));
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("message", (Object)TYPE_DELETED);
            dbo.put("type", (Object)TYPE_DELETED);
            coll.save(dbo, WriteConcern.NONE);
        }
    }

    public void edit(String room, String user, String messageId, String message) {
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + room);
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)new ObjectId(messageId));
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("message", (Object)message);
            dbo.put("type", (Object)TYPE_EDITED);
            coll.save(dbo, WriteConcern.NONE);
        }
    }

    public String read(String room, UserService userService) {
        return this.read(room, userService, false);
    }

    public String read(String room, UserService userService, boolean isTextOnly) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm aaa");
        SimpleDateFormat formatterDate = new SimpleDateFormat("dd/MM/yyyy hh:mm aaa");
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date today = calendar.getTime();
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + room);
        BasicDBObject query = new BasicDBObject();
        query.put("timestamp", (Object)new BasicDBObject("$gt", (Object)(System.currentTimeMillis() - this.readMillis)));
        BasicDBObject sort = new BasicDBObject();
        sort.put("timestamp", (Object)-1);
        int limit = isTextOnly ? this.readTotalTxt : this.readTotalJson;
        DBCursor cursor = coll.find((DBObject)query).sort((DBObject)sort).limit(limit);
        if (!cursor.hasNext()) {
            if (isTextOnly) {
                sb.append("no messages");
            } else {
                sb.append("{\"messages\": []}");
            }
        } else {
            HashMap<String, UserBean> users2 = new HashMap<String, UserBean>();
            boolean first = true;
            while (cursor.hasNext()) {
                DBObject dbo = cursor.next();
                String timestamp = dbo.get("timestamp").toString();
                if (first && !isTextOnly) {
                    sb.append("{\"room\": \"").append(room).append("\",");
                    sb.append("\"timestamp\": \"").append(timestamp).append("\",");
                    sb.append("\"messages\": [");
                }
                String user = dbo.get("user").toString();
                String msgId = dbo.get("_id").toString();
                UserBean userBean = (UserBean)users2.get(user);
                if (userBean == null) {
                    userBean = userService.getUser(user);
                    users2.put(user, userBean);
                }
                String fullname = userBean.getFullname();
                String email = userBean.getEmail();
                String date = "";
                try {
                    if (dbo.containsField("time")) {
                        Date date1 = (Date)dbo.get("time");
                        date = date1.before(today) || isTextOnly ? formatterDate.format(date1) : formatter.format(date1);
                    }
                }
                catch (Exception e) {
                    log.info("Message Date Format Error : " + e.getMessage());
                }
                if (isTextOnly) {
                    StringBuilder line = new StringBuilder();
                    line.append("[").append(date).append("] ");
                    String message = dbo.get("message").toString();
                    if (TYPE_DELETED.equals(message)) {
                        message = TYPE_DELETED;
                    }
                    if ("true".equals(dbo.get("isSystem"))) {
                        line.append("System Message: ");
                        if (message.endsWith("<br/>")) {
                            message = message.substring(0, message.length() - 5);
                        }
                        line.append(message).append("\n");
                    } else {
                        line.append(fullname).append(": ");
                        message = message.replaceAll("<br/>", "\n");
                        line.append(message).append("\n");
                    }
                    sb.insert(0, line);
                } else {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append("{\"id\": \"").append(msgId).append("\",");
                    sb.append("\"timestamp\": ").append(timestamp).append(",");
                    sb.append("\"user\": \"").append(user).append("\",");
                    sb.append("\"fullname\": \"").append(fullname).append("\",");
                    sb.append("\"email\": \"").append(email).append("\",");
                    sb.append("\"date\": \"").append(date).append("\",");
                    sb.append("\"message\": \"").append(dbo.get("message")).append("\",");
                    if (dbo.containsField("options")) {
                        String options = dbo.get("options").toString();
                        if (options.startsWith("{")) {
                            sb.append("\"options\": ").append(options).append(",");
                        } else {
                            sb.append("\"options\": \"").append(options).append("\",");
                        }
                    } else {
                        sb.append("\"options\": \"\",");
                    }
                    sb.append("\"type\": \"").append(dbo.get("type")).append("\",");
                    sb.append("\"isSystem\": \"").append(dbo.get("isSystem")).append("\"}");
                }
                first = false;
            }
            if (!isTextOnly) {
                sb.append("]}");
            }
        }
        return sb.toString();
    }

    private void updateRoomTimestamp(String room) {
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            if (dbo.containsField("space")) {
                String spaceId = dbo.get("space").toString();
                if (spaceId.indexOf(SPACE_PREFIX) > -1) {
                    spaceId = spaceId.substring(6);
                }
                DBCollection colls = this.db().getCollection("spaces");
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)spaceId);
                DBCursor cursors = colls.find((DBObject)query);
                if (cursors.hasNext()) {
                    DBObject doc = cursors.next();
                    doc.put("timestamp", (Object)System.currentTimeMillis());
                    colls.save(doc, WriteConcern.NONE);
                }
            } else {
                dbo.put("timestamp", (Object)System.currentTimeMillis());
                coll.save(dbo, WriteConcern.NONE);
            }
        }
    }

    private void ensureIndexInRoom(String room) {
        DBCollection coll = this.db().getCollection(M_ROOM_PREFIX + room);
        BasicDBObject doc = new BasicDBObject();
        doc.put("timestamp", (Object)System.currentTimeMillis());
        coll.insert(new DBObject[]{doc});
        coll.ensureIndex("timestamp");
        coll.remove((DBObject)doc);
    }

    private String getRoomId(String space) {
        ArrayList<String> spaces = new ArrayList<String>();
        spaces.add("1-space-room");
        spaces.add(space);
        return this.getRoomId(spaces);
    }

    private String getRoomId(List<String> users2) {
        Collections.sort(users2);
        StringBuilder sb = new StringBuilder();
        for (String user : users2) {
            sb.append(user).append(";");
        }
        String roomId = MessageDigester.getHash(sb.toString());
        return roomId;
    }

    public String getSpaceRoom(String space) {
        String room = this.getRoomId(space);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put("space", (Object)space);
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom(room);
            }
            catch (MongoException me) {
                log.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    public String getRoom(List<String> users2) {
        Collections.sort(users2);
        String room = this.getRoomId(users2);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put("users", users2);
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom(room);
            }
            catch (MongoException me) {
                log.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        String roomId = null;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("users", (Object)user);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            roomId = dbo.get("_id").toString();
            long timestamp = -1L;
            if (dbo.containsField("timestamp")) {
                timestamp = (Long)dbo.get("timestamp");
            }
            List users2 = (List)dbo.get("users");
            users2.remove(user);
            if (users2.size() <= 0 || user.equals(users2.get(0))) continue;
            String targetUser = (String)users2.get(0);
            boolean isDemoUser = tokenService.isDemoUser(targetUser);
            if (isAdmin && (!isAdmin || (withPublic || isDemoUser) && (!withPublic || !isDemoUser))) continue;
            RoomBean roomBean = new RoomBean();
            roomBean.setRoom(roomId);
            roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", roomId));
            roomBean.setUser((String)users2.get(0));
            roomBean.setTimestamp(timestamp);
            rooms.add(roomBean);
        }
        return rooms;
    }

    /*
     * WARNING - void declaration
     */
    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, NotificationService notificationService, UserService userService, TokenService tokenService) {
        void var19_27;
        List<Object> rooms = new ArrayList();
        ArrayList<RoomBean> roomsOffline = new ArrayList<RoomBean>();
        UserBean userBean = userService.getUser(user, true);
        int unreadOffline = 0;
        int unreadOnline = 0;
        int unreadSpaces = 0;
        List<String> availableUsers = tokenService.getActiveUsersFilterBy(user, withUsers, withPublic, isAdmin);
        rooms = this.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService);
        if (isAdmin) {
            rooms.addAll(this.getExistingRooms("__support_", withPublic, isAdmin, notificationService, tokenService));
        }
        for (RoomBean roomBean : rooms) {
            String targetUser = roomBean.getUser();
            UserBean userBean2 = userService.getUser(targetUser);
            roomBean.setFullname(userBean2.getFullname());
            roomBean.setFavorite(userBean.isFavorite(targetUser));
            if (availableUsers.contains(targetUser)) {
                roomBean.setAvailableUser(true);
                roomBean.setStatus(userBean2.getStatus());
                availableUsers.remove(targetUser);
                if (roomBean.getUnreadTotal() <= 0) continue;
                unreadOnline += roomBean.getUnreadTotal();
                continue;
            }
            roomBean.setAvailableUser(false);
            if (!withOffline) {
                roomsOffline.add(roomBean);
            }
            if (roomBean.getUnreadTotal() <= 0) continue;
            unreadOffline += roomBean.getUnreadTotal();
        }
        if (withUsers) {
            if (!withOffline) {
                for (RoomBean roomBean : roomsOffline) {
                    rooms.remove(roomBean);
                }
            }
            for (String string : availableUsers) {
                RoomBean roomBean = new RoomBean();
                roomBean.setUser(string);
                UserBean userBean3 = userService.getUser(string);
                roomBean.setFullname(userBean3.getFullname());
                roomBean.setStatus(userBean3.getStatus());
                roomBean.setAvailableUser(true);
                roomBean.setFavorite(userBean.isFavorite(roomBean.getUser()));
                String status = roomBean.getStatus();
                if (!withOffline && (withOffline || "invisible".equals(roomBean.getStatus()) || "offline".equals(roomBean.getStatus()))) continue;
                rooms.add(roomBean);
            }
        } else {
            rooms = new ArrayList();
        }
        List<SpaceBean> spaces = userService.getSpaces(user);
        for (SpaceBean space : spaces) {
            RoomBean roomBean = new RoomBean();
            roomBean.setUser(SPACE_PREFIX + space.getId());
            roomBean.setFullname(space.getDisplayName());
            roomBean.setStatus("space");
            roomBean.setTimestamp(space.getTimestamp());
            roomBean.setAvailableUser(true);
            roomBean.setSpace(true);
            roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", this.getSpaceRoom(SPACE_PREFIX + space.getId())));
            if (roomBean.getUnreadTotal() > 0) {
                unreadSpaces += roomBean.getUnreadTotal();
            }
            roomBean.setFavorite(userBean.isFavorite(roomBean.getUser()));
            if (!withSpaces) continue;
            rooms.add(roomBean);
        }
        ArrayList<RoomBean> arrayList = new ArrayList<RoomBean>();
        if (filter != null) {
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getFullname();
                if (!this.filter(targetUser, filter)) continue;
                arrayList.add(roomBean);
            }
        } else {
            List<Object> list = rooms;
        }
        RoomsBean roomsBean = new RoomsBean();
        roomsBean.setRooms((List<RoomBean>)var19_27);
        roomsBean.setUnreadOffline(unreadOffline);
        roomsBean.setUnreadOnline(unreadOnline);
        roomsBean.setUnreadSpaces(unreadSpaces);
        return roomsBean;
    }

    private boolean filter(String user, String filter) {
        if (user == null || filter == null || "".equals(filter)) {
            return true;
        }
        String[] args = filter.toLowerCase().split(" ");
        String s = user.toLowerCase();
        for (String arg : args) {
            int ind = s.indexOf(arg);
            if (ind == -1) {
                return false;
            }
            s = s.substring(ind);
        }
        return true;
    }

    public int getNumberOfRooms() {
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    public int getNumberOfMessages() {
        int nb = 0;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            String roomId = dbo.get("_id").toString();
            DBCollection collr = this.db().getCollection(M_ROOM_PREFIX + roomId);
            BasicDBObject queryr = new BasicDBObject();
            DBCursor cursorr = collr.find((DBObject)queryr);
            nb += cursorr.count();
        }
        return nb;
    }
}

