/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.benjp.listener.ConnectionManager;

@Named(value="notificationService")
@ApplicationScoped
public class NotificationService {
    public static final String M_NOTIFICATIONS = "notifications";

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    public static void cleanupNotifications() {
        DBCollection coll = ConnectionManager.getInstance().getDB().getCollection(M_NOTIFICATIONS);
        BasicDBObject query = new BasicDBObject();
        query.put("timestamp", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - 86400000L)));
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            coll.remove(doc);
        }
    }

    public void addNotification(String user, String type, String category, String categoryId, String content, String link) {
        DBCollection coll = this.db().getCollection(M_NOTIFICATIONS);
        BasicDBObject doc = new BasicDBObject();
        doc.put("timestamp", (Object)System.currentTimeMillis());
        doc.put("user", (Object)user);
        doc.put("type", (Object)type);
        doc.put("category", (Object)category);
        doc.put("categoryId", (Object)categoryId);
        doc.put("content", (Object)content);
        doc.put("link", (Object)link);
        doc.put("isRead", (Object)false);
        coll.insert(new DBObject[]{doc});
    }

    public void setNotificationsAsRead(String user, String type, String category, String categoryId) {
        DBCollection coll = this.db().getCollection(M_NOTIFICATIONS);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        if (categoryId != null) {
            query.put("categoryId", (Object)categoryId);
        }
        if (category != null) {
            query.put("category", (Object)category);
        }
        if (type != null) {
            query.put("type", (Object)type);
        }
        coll.remove((DBObject)query);
    }

    public int getUnreadNotificationsTotal(String user) {
        return this.getUnreadNotificationsTotal(user, null, null, null);
    }

    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId) {
        int total = -1;
        DBCollection coll = this.db().getCollection(M_NOTIFICATIONS);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        if (type != null) {
            query.put("type", (Object)type);
        }
        if (category != null) {
            query.put("category", (Object)category);
        }
        if (categoryId != null) {
            query.put("categoryId", (Object)categoryId);
        }
        DBCursor cursor = coll.find((DBObject)query);
        total = cursor.size();
        return total;
    }

    public int getNumberOfNotifications() {
        DBCollection coll = this.db().getCollection(M_NOTIFICATIONS);
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    public int getNumberOfUnreadNotifications() {
        DBCollection coll = this.db().getCollection(M_NOTIFICATIONS);
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }
}

