/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.benjp.jobs.NotificationCleanupJob;
import org.benjp.listener.ConnectionManager;
import org.benjp.utils.PropertyManager;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@Named(value="schedulerService")
@ApplicationScoped
public class SchedulerService {
    Logger log = Logger.getLogger("SchedulerService");
    private static Scheduler sched;

    public SchedulerService() {
        this.log.info("Start Scheduler");
        this.startScheduler();
    }

    private void startScheduler() {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            sched = sf.getScheduler();
            JobDetail notificationCleanupJob = JobBuilder.newJob(NotificationCleanupJob.class).withIdentity("notificationCleanupJob", "chatServer").build();
            CronTrigger notificationTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("notificationTrigger", "chatServer").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)PropertyManager.getProperty("chatCronNotifCleanup"))).build();
            sched.scheduleJob(notificationCleanupJob, (Trigger)notificationTrigger);
            sched.start();
            this.log.info("Scheduler Started");
            try {
                ConnectionManager.getInstance().ensureIndexes();
                this.log.info("MongoDB Indexes Up to Date");
            }
            catch (Exception e) {
                this.log.severe("MongoDB Indexes couldn't be created during startup. Chat Extension may be unstable!");
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() throws SchedulerException {
        sched.shutdown();
    }
}

