/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.benjp.listener.ConnectionManager;
import org.benjp.utils.MessageDigester;
import org.benjp.utils.PropertyManager;

@Named(value="tokenService")
@ApplicationScoped
public class TokenService {
    public static final String M_TOKENS_COLLECTION = "tokens";
    public static final String ANONIM_USER = "__anonim_";
    private int validity_ = -1;

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty("chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash(in);
        return token;
    }

    public boolean hasUserWithToken(String user, String token) {
        DBCollection coll = this.db().getCollection(M_TOKENS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        query.put("token", (Object)token);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext();
    }

    public void addUser(String user, String token) {
        if (!this.hasUserWithToken(user, token)) {
            this.removeUser(user);
            DBCollection coll = this.db().getCollection(M_TOKENS_COLLECTION);
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)token);
            doc.put("user", (Object)user);
            doc.put("token", (Object)token);
            doc.put("validity", (Object)System.currentTimeMillis());
            doc.put("isDemoUser", (Object)user.startsWith(ANONIM_USER));
            coll.insert(new DBObject[]{doc});
        }
    }

    private void removeUser(String user) {
        DBCollection coll = this.db().getCollection(M_TOKENS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            coll.remove(doc);
        }
    }

    public void updateValidity(String user, String token) {
        DBCollection coll = this.db().getCollection(M_TOKENS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        query.put("token", (Object)token);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("validity", (Object)System.currentTimeMillis());
            coll.save(doc, WriteConcern.SAFE);
        }
    }

    public List<String> getActiveUsersFilterBy(String user, boolean withUsers, boolean withPublic, boolean isAdmin) {
        ArrayList<String> users2 = new ArrayList<String>();
        DBCollection coll = this.db().getCollection(M_TOKENS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("validity", (Object)new BasicDBObject("$gt", (Object)(System.currentTimeMillis() - (long)this.getValidity())));
        if (isAdmin) {
            if (withPublic && !withUsers) {
                query.put("isDemoUser", (Object)true);
            } else if (!withPublic && withUsers) {
                query.put("isDemoUser", (Object)false);
            }
        } else {
            query.put("isDemoUser", (Object)user.startsWith(ANONIM_USER));
        }
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user.equals(target)) continue;
            users2.add(target);
        }
        return users2;
    }

    public boolean isUserOnline(String user) {
        DBCollection coll = this.db().getCollection(M_TOKENS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        query.put("validity", (Object)new BasicDBObject("$gt", (Object)(System.currentTimeMillis() - (long)this.getValidity())));
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext();
    }

    public boolean isDemoUser(String user) {
        return user.startsWith(ANONIM_USER);
    }

    private int getValidity() {
        if (this.validity_ == -1) {
            this.validity_ = 25000;
            try {
                this.validity_ = new Integer(PropertyManager.getProperty("chatTokenValidity"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity_;
    }
}

