/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.listener;

import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.benjp.services.mongodb.MongoBootstrap;

public class ConnectionManager
implements ServletContextListener {
    private static MongoBootstrap mongoBootstrap;
    private static Logger log;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        log.info("INITIALIZING MONGODB");
        mongoBootstrap = new MongoBootstrap();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        log.info("CLOSING MONGODB");
        mongoBootstrap.close();
    }

    public static MongoBootstrap getInstance() {
        return mongoBootstrap;
    }

    public static MongoBootstrap forceNew() {
        log.warning("ConnectionManager.forceNew has been used : this should never happen in Production!");
        if (mongoBootstrap != null) {
            mongoBootstrap.close();
        }
        mongoBootstrap = new MongoBootstrap();
        return mongoBootstrap;
    }

    static {
        log = Logger.getLogger("ConnectionManager");
    }
}

