/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.benjp.model.RoomBean;
import org.benjp.model.SpaceBean;
import org.benjp.model.UserBean;
import org.benjp.services.UserService;
import org.benjp.services.jcr.AbstractJCRService;
import org.benjp.services.jcr.JCRBootstrap;
import org.benjp.utils.ChatUtils;

public class UserServiceImpl
extends AbstractJCRService
implements UserService {
    @Override
    public void toggleFavorite(String user, String targetUser) {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                ArrayList<String> favorites = new ArrayList<String>();
                boolean hasAlready = false;
                if (userNode.hasProperty("chat:favorites")) {
                    Value[] values;
                    for (Value value : values = userNode.getProperty("chat:favorites").getValues()) {
                        String fav = value.getString();
                        if (!fav.equals(targetUser)) {
                            favorites.add(fav);
                            continue;
                        }
                        hasAlready = true;
                    }
                }
                if (!hasAlready) {
                    favorites.add(targetUser);
                }
                String[] favtab = new String[favorites.size()];
                int i = 0;
                for (String fav : favorites) {
                    favtab[i++] = fav;
                }
                userNode.setProperty("chat:favorites", favtab);
                userNode.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isFavorite(String user, String targetUser) {
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user) && (userNode = usersNode.getNode(user)).hasProperty("chat:favorites")) {
                Value[] values;
                for (Value value : values = userNode.getProperty("chat:favorites").getValues()) {
                    String fav = value.getString();
                    if (!fav.equals(targetUser)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void addUserFullName(String user, String fullname) {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                userNode.setProperty("chat:fullname", fullname);
                userNode.save();
                session.save();
            } else {
                Node userNode = usersNode.addNode(user, "chat:user");
                userNode.setProperty("chat:user", user);
                userNode.setProperty("chat:fullname", fullname);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addUserEmail(String user, String email) {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                userNode.setProperty("chat:email", email);
                userNode.save();
                session.save();
            } else {
                Node userNode = usersNode.addNode(user, "chat:user");
                userNode.setProperty("chat:user", user);
                userNode.setProperty("chat:email", email);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSpaces(String user, List<SpaceBean> spaces) {
        ArrayList<String> spaceIds = new ArrayList<String>();
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node roomsNode = session.getRootNode().getNode("chat/room_rooms");
            for (SpaceBean bean : spaces) {
                Node roomNode;
                String room = ChatUtils.getRoomId(bean.getId());
                spaceIds.add(room);
                if (!roomsNode.hasNode(room)) {
                    roomNode = roomsNode.addNode(room, "chat:room");
                    roomNode.setProperty("chat:id", bean.getId());
                    roomNode.setProperty("chat:displayname", bean.getDisplayName());
                    roomNode.setProperty("chat:groupid", bean.getGroupId());
                    roomNode.setProperty("chat:shortname", bean.getShortName());
                    roomNode.setProperty("chat:type", "s");
                    session.save();
                    continue;
                }
                roomNode = roomsNode.getNode(room);
                String displayName = roomNode.getProperty("chat:displayname").getString();
                if (bean.getDisplayName().equals(displayName)) continue;
                roomNode.setProperty("chat:id", bean.getId());
                roomNode.setProperty("chat:displayname", bean.getDisplayName());
                roomNode.setProperty("chat:groupid", bean.getGroupId());
                roomNode.setProperty("chat:shortname", bean.getShortName());
                roomNode.save();
                session.save();
            }
            String[] sids = new String[spaceIds.size()];
            int i = 0;
            for (String id : spaceIds) {
                sids[i++] = id;
            }
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                userNode = usersNode.getNode(user);
                userNode.setProperty("chat:spaces", sids);
                userNode.save();
                session.save();
            } else {
                userNode = usersNode.addNode(user, "chat:user");
                userNode.setProperty("chat:user", user);
                userNode.setProperty("chat:spaces", sids);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTeamRoom(String user, String teamRoomId) {
        String[] teamsIds = new String[]{teamRoomId};
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                if (userNode.hasProperty("chat:teams")) {
                    Value[] values = userNode.getProperty("chat:teams").getValues();
                    ArrayList<String> tlist = new ArrayList<String>();
                    boolean containsTeamRoomId = false;
                    for (Value val : values) {
                        String id = val.getString();
                        if (teamRoomId.equals(id)) {
                            containsTeamRoomId = true;
                        }
                        tlist.add(id);
                    }
                    if (!containsTeamRoomId) {
                        tlist.add(teamRoomId);
                    }
                    String[] ids = new String[tlist.size()];
                    int i = 0;
                    for (String id : tlist) {
                        ids[i++] = id;
                    }
                    userNode.setProperty("chat:teams", ids);
                } else {
                    userNode.setProperty("chat:teams", teamsIds);
                }
                userNode.save();
                session.save();
            } else {
                Node userNode = usersNode.addNode(user, "chat:user");
                userNode.setProperty("chat:user", user);
                userNode.setProperty("chat:teams", teamsIds);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTeamUsers(String teamRoomId, List<String> users2) {
        for (String user : users2) {
            this.addTeamRoom(user, teamRoomId);
        }
    }

    @Override
    public void removeTeamUsers(String teamRoomId, List<String> users2) {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            for (String user : users2) {
                Node userNode;
                if (!usersNode.hasNode(user) || !(userNode = usersNode.getNode(user)).hasProperty("chat:teams")) continue;
                Value[] values = userNode.getProperty("chat:teams").getValues();
                ArrayList<String> tlist = new ArrayList<String>();
                boolean containsTeamRoomId = false;
                for (Value val : values) {
                    String id = val.getString();
                    if (teamRoomId.equals(id)) {
                        containsTeamRoomId = true;
                        continue;
                    }
                    tlist.add(id);
                }
                if (!containsTeamRoomId) continue;
                String[] ids = new String[tlist.size()];
                int i = 0;
                for (String id : tlist) {
                    ids[i++] = id;
                }
                userNode.setProperty("chat:teams", ids);
                userNode.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RoomBean getTeam(String teamId) {
        RoomBean roomBean = null;
        try {
            Session session = JCRBootstrap.getSession();
            Node roomsNode = session.getRootNode().getNode("chat/room_rooms");
            if (roomsNode.hasNode(teamId)) {
                Node roomNode = roomsNode.getNode(teamId);
                roomBean = new RoomBean();
                roomBean.setRoom(teamId);
                roomBean.setUser(roomNode.getProperty("chat:user").getString());
                roomBean.setFullname(roomNode.getProperty("chat:team").getString());
                if (roomNode.hasProperty("chat:timestamp")) {
                    roomBean.setTimestamp(roomNode.getProperty("chat:timestamp").getLong());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return roomBean;
    }

    @Override
    public List<RoomBean> getTeams(String user) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user) && (userNode = usersNode.getNode(user)).hasProperty("chat:teams")) {
                Value[] values;
                for (Value val : values = userNode.getProperty("chat:teams").getValues()) {
                    rooms.add(this.getTeam(val.getString()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rooms;
    }

    private SpaceBean getSpace(String spaceId) {
        SpaceBean spaceBean = null;
        try {
            Session session = JCRBootstrap.getSession();
            Node roomsNode = session.getRootNode().getNode("chat/room_rooms");
            if (roomsNode.hasNode(spaceId)) {
                Node roomNode = roomsNode.getNode(spaceId);
                spaceBean = new SpaceBean();
                spaceBean.setId(roomNode.getProperty("chat:id").getString());
                spaceBean.setRoom(spaceId);
                spaceBean.setDisplayName(roomNode.getProperty("chat:displayname").getString());
                spaceBean.setGroupId(roomNode.getProperty("chat:groupid").getString());
                spaceBean.setShortName(roomNode.getProperty("chat:shortname").getString());
                if (roomNode.hasProperty("chat:timestamp")) {
                    spaceBean.setTimestamp(roomNode.getProperty("chat:timestamp").getLong());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spaceBean;
    }

    @Override
    public List<SpaceBean> getSpaces(String user) {
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user) && (userNode = usersNode.getNode(user)).hasProperty("chat:spaces")) {
                Value[] values;
                for (Value val : values = userNode.getProperty("chat:spaces").getValues()) {
                    spaces.add(this.getSpace(val.getString()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spaces;
    }

    @Override
    public List<UserBean> getUsers(String roomId) {
        if (roomId.indexOf("space-") == 0) {
            roomId = roomId.substring("space-".length());
        }
        if (roomId.indexOf("team-") == 0) {
            roomId = roomId.substring("team-".length());
        }
        ArrayList<UserBean> users2 = new ArrayList<UserBean>();
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:user").append(" WHERE ");
            statement.append("chat:spaces").append(" = '").append(roomId).append("'");
            statement.append(" OR ");
            statement.append("chat:teams").append(" = '").append(roomId).append("'");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                UserBean userBean = new UserBean();
                Node userNode = nodeIterator.nextNode();
                userBean.setName(userNode.getName());
                userBean.setFullname(userNode.hasProperty("chat:fullname") ? userNode.getProperty("chat:fullname").getString() : "");
                userBean.setEmail(userNode.hasProperty("chat:email") ? userNode.getProperty("chat:email").getString() : "");
                userBean.setStatus(userNode.hasProperty("chat:status") ? userNode.getProperty("chat:status").getString() : "");
                users2.add(userBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users2;
    }

    @Override
    public List<UserBean> getUsers(String filter, boolean fullBean) {
        filter = filter.trim();
        filter = ("" + filter.charAt(0)).toUpperCase() + (filter.length() > 1 ? filter.substring(1) : "");
        if (filter.indexOf(" ") > -1) {
            String name = filter.substring(filter.indexOf(" ") + 1);
            name = ("" + name.charAt(0)).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
            filter = filter.substring(0, filter.indexOf(" ")) + "%" + name;
        }
        filter = filter.replaceAll(" ", "%");
        ArrayList<UserBean> users2 = new ArrayList<UserBean>();
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:user").append(" WHERE ");
            statement.append("chat:fullname").append(" like '").append(filter).append("%'");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                UserBean userBean = new UserBean();
                Node userNode = nodeIterator.nextNode();
                userBean.setName(userNode.getName());
                userBean.setFullname(userNode.hasProperty("chat:fullname") ? userNode.getProperty("chat:fullname").getString() : "");
                userBean.setEmail(userNode.hasProperty("chat:email") ? userNode.getProperty("chat:email").getString() : "");
                userBean.setStatus(userNode.hasProperty("chat:status") ? userNode.getProperty("chat:status").getString() : "");
                users2.add(userBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users2;
    }

    @Override
    public String setStatus(String user, String status) {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                userNode.setProperty("chat:status", status);
                userNode.save();
                session.save();
            } else {
                Node userNode = usersNode.addNode(user, "chat:user");
                userNode.setProperty("chat:user", user);
                userNode.setProperty("chat:status", status);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    @Override
    public void setAsAdmin(String user, boolean isAdmin) {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                userNode.setProperty("chat:issupport", isAdmin);
                userNode.save();
                session.save();
            } else {
                Node userNode = usersNode.addNode(user, "chat:user");
                userNode.setProperty("chat:user", user);
                userNode.setProperty("chat:issupport", isAdmin);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isAdmin(String user) {
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user) && (userNode = usersNode.getNode(user)).hasProperty("chat:issupport")) {
                return userNode.getProperty("chat:issupport").getBoolean();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getStatus(String user) {
        String status = "none";
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            status = usersNode.hasNode(user) ? ((userNode = usersNode.getNode(user)).hasProperty("chat:status") ? userNode.getProperty("chat:status").getString() : this.setStatus(user, "available")) : this.setStatus(user, "available");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    @Override
    public String getUserFullName(String user) {
        String fullname = null;
        try {
            Node userNode;
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user) && (userNode = usersNode.getNode(user)).hasProperty("chat:fullname")) {
                fullname = userNode.getProperty("chat:fullname").getString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fullname;
    }

    @Override
    public UserBean getUser(String user) {
        return this.getUser(user, false);
    }

    @Override
    public UserBean getUser(String user, boolean withFavorites) {
        UserBean userBean = new UserBean();
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            if (usersNode.hasNode(user)) {
                Node userNode = usersNode.getNode(user);
                userBean.setName(user);
                if (userNode.hasProperty("chat:fullname")) {
                    userBean.setFullname(userNode.getProperty("chat:fullname").getString());
                }
                if (userNode.hasProperty("chat:email")) {
                    userBean.setEmail(userNode.getProperty("chat:email").getString());
                }
                if (userNode.hasProperty("chat:status")) {
                    userBean.setStatus(userNode.getProperty("chat:status").getString());
                }
                if (withFavorites && userNode.hasProperty("chat:favorites")) {
                    Value[] values;
                    ArrayList<String> favorites = new ArrayList<String>();
                    for (Value val : values = userNode.getProperty("chat:favorites").getValues()) {
                        favorites.add(val.getString());
                    }
                    userBean.setFavorites(favorites);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userBean;
    }

    @Override
    public List<String> getUsersFilterBy(String user, String room, String type) {
        ArrayList<String> users2 = new ArrayList<String>();
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:user").append(" WHERE ");
            if ("s".equals(type)) {
                statement.append("chat:spaces").append(" = '").append(room).append("'");
            } else {
                statement.append("chat:teams").append(" = '").append(room).append("'");
            }
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node userNode = nodeIterator.nextNode();
                if (user != null && user.equals(userNode.getName())) continue;
                users2.add(userNode.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users2;
    }

    @Override
    public int getNumberOfUsers() {
        try {
            Session session = JCRBootstrap.getSession();
            Node usersNode = session.getRootNode().getNode("chat/users");
            return new Long(usersNode.getNodes().getSize()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

