/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.benjp.utils.PropertyManager;

public class MongoBootstrap {
    private static MongodExecutable mongodExe;
    private static MongodProcess mongod;
    private Mongo m;
    private DB db;
    private static Logger log;

    private Mongo mongo() {
        if (this.m == null) {
            try {
                if ("embed".equals(PropertyManager.getProperty("dbServerType"))) {
                    log.warning("WE WILL NOW USE MONGODB IN EMBED MODE...");
                    log.warning("BE AWARE...");
                    log.warning("EMBED MODE SHOULD NEVER BE USED IN PRODUCTION!");
                    MongoBootstrap.setupEmbedMongo();
                }
                MongoOptions options = new MongoOptions();
                options.connectionsPerHost = 200;
                options.connectTimeout = 60000;
                options.threadsAllowedToBlockForConnectionMultiplier = 10;
                options.autoConnectRetry = true;
                String host = PropertyManager.getProperty("dbServerHost");
                int port = Integer.parseInt(PropertyManager.getProperty("dbServerPort"));
                this.m = new Mongo(new ServerAddress(host, port), options);
                this.m.setWriteConcern(WriteConcern.SAFE);
            }
            catch (UnknownHostException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.m;
    }

    public void close() {
        try {
            if (mongod != null) {
                mongod.stop();
                mongodExe.stop();
            }
            if (this.m != null) {
                this.m.close();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void initialize() {
        this.close();
        this.m = null;
        this.mongo();
    }

    public void dropDB(String dbName) {
        log.info("---- Dropping DB " + dbName);
        this.mongo().dropDatabase(dbName);
        log.info("-------- DB " + dbName + " dropped!");
    }

    public DB getDB() {
        return this.getDB(null);
    }

    public DB getDB(String dbName) {
        if (this.db == null || dbName != null) {
            this.db = dbName != null ? this.mongo().getDB(dbName) : this.mongo().getDB(PropertyManager.getProperty("dbName"));
            boolean authenticate = "true".equals(PropertyManager.getProperty("dbAuthentication"));
            if (authenticate) {
                this.db.authenticate(PropertyManager.getProperty("dbUser"), PropertyManager.getProperty("dbPassword").toCharArray());
            }
            this.initCollection("notifications");
            this.initCollection("room_rooms");
            this.initCollection("users");
            this.dropTokenCollectionIfExists();
        }
        return this.db;
    }

    private static Mongo setupEmbedMongo() throws IOException {
        MongodStarter runtime = MongodStarter.getDefaultInstance();
        int port = Integer.parseInt(PropertyManager.getProperty("dbServerPort"));
        mongodExe = (MongodExecutable)runtime.prepare((ExecutableProcessConfig)new MongodConfig((IVersion)Version.V2_3_0, port, Network.localhostIsIPv6()));
        mongod = (MongodProcess)mongodExe.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.info(e.getMessage());
        }
        String host = PropertyManager.getProperty("dbServerHost");
        return new Mongo(new ServerAddress(host, port));
    }

    public void initCappedCollection(String name, int size) {
        this.initCollection(name, true, size);
    }

    private void initCollection(String name) {
        this.initCollection(name, false, 0);
    }

    private void initCollection(String name, boolean isCapped, int size) {
        if (this.getDB().collectionExists(name)) {
            return;
        }
        BasicDBObject doc = new BasicDBObject();
        doc.put("capped", (Object)isCapped);
        if (isCapped) {
            doc.put("size", (Object)size);
        }
        this.getDB().createCollection(name, (DBObject)doc);
    }

    private void dropTokenCollectionIfExists() {
        if (this.getDB().collectionExists("tokens")) {
            DBCollection tokens = this.getDB().getCollection("tokens");
            tokens.drop();
        }
    }

    public void ensureIndexesInRoom(String roomId) {
        String dbName = this.getDB().getName();
        BasicDBObject unique = new BasicDBObject();
        unique.put("unique", (Object)true);
        unique.put("background", (Object)true);
        BasicDBObject notUnique = new BasicDBObject();
        notUnique.put("unique", (Object)false);
        notUnique.put("background", (Object)true);
        DBCollection collr = this.getDB().getCollection("room_" + roomId);
        collr.ensureIndex((DBObject)new BasicDBObject("timestamp", (Object)1), (DBObject)notUnique.append("name", (Object)"timestamp_1").append("ns", (Object)(dbName + ".room_" + roomId)));
        collr.ensureIndex((DBObject)new BasicDBObject("timestamp", (Object)-1), (DBObject)notUnique.append("name", (Object)"timestamp_m1").append("ns", (Object)(dbName + ".room_" + roomId)));
        log.info("##### room index in " + roomId);
    }

    public void ensureIndexes() {
        String dbName = this.getDB().getName();
        log.info("### ensureIndexes in " + dbName);
        BasicDBObject unique = new BasicDBObject();
        unique.put("unique", (Object)true);
        unique.put("background", (Object)true);
        BasicDBObject notUnique = new BasicDBObject();
        notUnique.put("unique", (Object)false);
        notUnique.put("background", (Object)true);
        DBCollection notifications = this.getDB().getCollection("notifications");
        notifications.dropIndexes();
        notifications.createIndex((DBObject)new BasicDBObject("user", (Object)1), (DBObject)notUnique.append("name", (Object)"user_1").append("ns", (Object)(dbName + ".notifications")));
        notifications.createIndex((DBObject)new BasicDBObject("isRead", (Object)1), (DBObject)notUnique.append("name", (Object)"isRead_1").append("ns", (Object)(dbName + ".notifications")));
        BasicDBObject index2 = new BasicDBObject();
        index2.put("user", (Object)1);
        index2.put("categoryId", (Object)1);
        index2.put("category", (Object)1);
        index2.put("type", (Object)1);
        notifications.createIndex((DBObject)index2, (DBObject)notUnique.append("name", (Object)"user_1_type_1_category_1_categoryId_1").append("ns", (Object)(dbName + ".notifications")));
        log.info("### notifications indexes in " + this.getDB().getName());
        DBCollection rooms = this.getDB().getCollection("room_rooms");
        rooms.dropIndexes();
        rooms.createIndex((DBObject)new BasicDBObject("space", (Object)1), (DBObject)notUnique.append("name", (Object)"space_1").append("ns", (Object)(dbName + ".room_rooms")));
        rooms.createIndex((DBObject)new BasicDBObject("users", (Object)1), (DBObject)notUnique.append("name", (Object)"users_1").append("ns", (Object)(dbName + ".room_rooms")));
        rooms.createIndex((DBObject)new BasicDBObject("shortName", (Object)1), (DBObject)notUnique.append("name", (Object)"shortName_1").append("ns", (Object)(dbName + ".room_rooms")));
        log.info("### rooms indexes in " + this.getDB().getName());
        DBCollection coll = this.getDB().getCollection("room_rooms");
        DBCursor cursor = coll.find();
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            String roomId = dbo.get("_id").toString();
            DBCollection collr = this.getDB().getCollection("room_" + roomId);
            collr.ensureIndex((DBObject)new BasicDBObject("timestamp", (Object)1), (DBObject)notUnique.append("name", (Object)"timestamp_1").append("ns", (Object)(dbName + ".room_" + roomId)));
            collr.ensureIndex((DBObject)new BasicDBObject("timestamp", (Object)-1), (DBObject)notUnique.append("name", (Object)"timestamp_m1").append("ns", (Object)(dbName + ".room_" + roomId)));
            log.info("##### room index in " + roomId);
        }
        DBCollection users2 = this.getDB().getCollection("users");
        users2.dropIndexes();
        users2.createIndex((DBObject)new BasicDBObject("token", (Object)1), (DBObject)notUnique.append("name", (Object)"token_1").append("ns", (Object)(dbName + ".users")));
        users2.createIndex((DBObject)new BasicDBObject("validity", (Object)-1), (DBObject)notUnique.append("name", (Object)"validity_m1").append("ns", (Object)(dbName + ".users")));
        index2 = new BasicDBObject();
        index2.put("user", (Object)1);
        index2.put("token", (Object)1);
        users2.createIndex((DBObject)index2, (DBObject)unique.append("name", (Object)"user_1_token_1").append("ns", (Object)(dbName + ".users")));
        index2 = new BasicDBObject();
        index2.put("user", (Object)1);
        index2.put("validity", (Object)-1);
        users2.createIndex((DBObject)index2, (DBObject)unique.append("name", (Object)"user_1_validity_m1").append("ns", (Object)(dbName + ".users")));
        index2 = new BasicDBObject();
        index2.put("validity", (Object)-1);
        index2.put("isDemoUser", (Object)1);
        users2.createIndex((DBObject)index2, (DBObject)notUnique.append("name", (Object)"validity_1_isDemoUser_m1").append("ns", (Object)(dbName + ".users")));
        users2.createIndex((DBObject)new BasicDBObject("user", (Object)1), (DBObject)unique.append("name", (Object)"user_1").append("ns", (Object)(dbName + ".users")));
        users2.createIndex((DBObject)new BasicDBObject("spaces", (Object)1), (DBObject)notUnique.append("name", (Object)"spaces_1").append("ns", (Object)(dbName + ".users")));
        log.info("### users indexes in " + this.getDB().getName());
        log.info("### Indexes creation completed in " + this.getDB().getName());
    }

    static {
        log = Logger.getLogger("MongoBootstrap");
    }
}

